/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedWriterRecord
extends WriterRecord {
    private static final char[] TAB = "   ".toCharArray();
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    public void endDocument() {
        try {
            this.getWriter().write(Helper.cr());
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.getWriter().write(62);
            }
            if (!this.isLastEventText) {
                if (this.numberOfTabs > 0) {
                    this.getWriter().write(Helper.cr());
                }
                for (int i = 0; i < this.numberOfTabs; ++i) {
                    this.getWriter().write(TAB);
                }
            }
            this.isStartElementOpen = true;
            this.getWriter().write(60);
            this.getWriter().write(xPathFragment.getShortName());
            ++this.numberOfTabs;
            this.isLastEventText = false;
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void element(String string, String string2, String string3) {
        try {
            this.isLastEventText = false;
            if (this.isStartElementOpen) {
                this.getWriter().write(62);
                this.isStartElementOpen = false;
            }
            this.getWriter().write(Helper.cr());
            for (int i = 0; i < this.numberOfTabs; ++i) {
                this.getWriter().write(TAB);
            }
            super.element(string, string2, string3);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            this.isLastEventText = false;
            --this.numberOfTabs;
            if (this.isStartElementOpen) {
                this.getWriter().write(47);
                this.getWriter().write(62);
                this.isStartElementOpen = false;
                return;
            }
            if (this.complexType) {
                this.getWriter().write(Helper.cr());
                for (int i = 0; i < this.numberOfTabs; ++i) {
                    this.getWriter().write(TAB);
                }
            } else {
                this.complexType = true;
            }
            super.endElement(xPathFragment, namespaceResolver);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void characters(String string) {
        super.characters(string);
        this.isLastEventText = true;
        this.complexType = false;
    }

    public void cdata(String string) {
        try {
            if (this.isStartElementOpen) {
                this.getWriter().write(62);
                this.isStartElementOpen = false;
            }
            this.getWriter().write(Helper.cr());
            for (int i = 0; i < this.numberOfTabs; ++i) {
                this.getWriter().write(TAB);
            }
            super.cdata(string);
            this.complexType = true;
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String string = null;
            if (namespaceResolver != null) {
                string = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (string != null) {
                this.attribute(attr.getNamespaceURI(), "", string + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else {
            try {
                FormattedWriterRecordContentHandler formattedWriterRecordContentHandler = new FormattedWriterRecordContentHandler();
                XMLFragmentReader xMLFragmentReader = new XMLFragmentReader(namespaceResolver);
                xMLFragmentReader.setContentHandler(formattedWriterRecordContentHandler);
                xMLFragmentReader.setProperty("http://xml.org/sax/properties/lexical-handler", formattedWriterRecordContentHandler);
                xMLFragmentReader.parse(node);
            }
            catch (SAXException sAXException) {
                throw XMLMarshalException.marshalException(sAXException);
            }
        }
    }

    private class FormattedWriterRecordContentHandler
    extends WriterRecord.WriterRecordContentHandler {
        private FormattedWriterRecordContentHandler() {
            super(FormattedWriterRecord.this);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.getWriter().write(62);
                }
                if (!FormattedWriterRecord.this.isLastEventText) {
                    FormattedWriterRecord.this.getWriter().write(Helper.cr());
                    for (int i = 0; i < FormattedWriterRecord.this.numberOfTabs; ++i) {
                        FormattedWriterRecord.this.getWriter().write(TAB);
                    }
                }
                FormattedWriterRecord.this.getWriter().write(60);
                FormattedWriterRecord.this.getWriter().write(string3);
                FormattedWriterRecord.this.numberOfTabs++;
                FormattedWriterRecord.this.isStartElementOpen = true;
                FormattedWriterRecord.this.isLastEventText = false;
                this.handleAttributes(attributes);
                this.writePrefixMappings();
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                FormattedWriterRecord.this.isLastEventText = false;
                FormattedWriterRecord.this.numberOfTabs--;
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.getWriter().write(47);
                    FormattedWriterRecord.this.getWriter().write(62);
                    FormattedWriterRecord.this.isStartElementOpen = false;
                    FormattedWriterRecord.this.complexType = true;
                    return;
                }
                if (FormattedWriterRecord.this.complexType) {
                    FormattedWriterRecord.this.getWriter().write(Helper.cr());
                    for (int i = 0; i < FormattedWriterRecord.this.numberOfTabs; ++i) {
                        FormattedWriterRecord.this.getWriter().write(TAB);
                    }
                } else {
                    FormattedWriterRecord.this.complexType = true;
                }
                super.endElement(string, string2, string3);
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (FormattedWriterRecord.this.isProcessingCData) {
                FormattedWriterRecord.this.cdata(new String(cArray, n, n2));
                return;
            }
            if (new String(cArray).trim().length() == 0) {
                return;
            }
            super.characters(cArray, n, n2);
            FormattedWriterRecord.this.isLastEventText = true;
            FormattedWriterRecord.this.complexType = false;
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            try {
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.getWriter().write(62);
                    FormattedWriterRecord.this.getWriter().write(Helper.cr());
                    FormattedWriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(cArray, n, n2);
                FormattedWriterRecord.this.complexType = false;
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }
    }
}

