/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class HSQLPlatform
extends DatabasePlatform {
    protected Hashtable buildFieldTypes() {
        Hashtable hashtable = super.buildFieldTypes();
        hashtable.put(Boolean.class, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("REAL", false));
        hashtable.put(Double.class, new FieldTypeDefinition("REAL", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 38));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 38).setLimits(38, -19, 19));
        hashtable.put(Number.class, new FieldTypeDefinition("NUMERIC", 38).setLimits(38, -19, 19));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BINARY", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("LONGVARCHAR", false));
        hashtable.put(byte[].class, new FieldTypeDefinition("BINARY", false));
        hashtable.put(char[].class, new FieldTypeDefinition("LONGVARCHAR", false));
        hashtable.put(Blob.class, new FieldTypeDefinition("BINARY", false));
        hashtable.put(Clob.class, new FieldTypeDefinition("LONGVARCHAR", false));
        return hashtable;
    }

    public boolean isHSQL() {
        return true;
    }

    public boolean supportsForeignKeyConstraints() {
        return false;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        return new ValueReadQuery("CALL IDENTITY()");
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }
}

