/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.platform.xml.jaxp.JAXPNamespaceContext;
import org.eclipse.persistence.platform.xml.jaxp.JAXPParser;
import org.eclipse.persistence.platform.xml.jaxp.JAXPTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXPPlatform
implements XMLPlatform {
    private XPathFactory xPathFactory;
    private SchemaFactory schemaFactory;

    public XPathFactory getXPathFactory() {
        if (null == this.xPathFactory) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        return this.xPathFactory;
    }

    public SchemaFactory getSchemaFactory() {
        if (null == this.schemaFactory) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        return this.schemaFactory;
    }

    @Override
    public NodeList selectNodesAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            Object object;
            XPath xPath = this.getXPathFactory().newXPath();
            if (null != xMLNamespaceResolver) {
                object = new JAXPNamespaceContext(xMLNamespaceResolver);
                xPath.setNamespaceContext((NamespaceContext)object);
            }
            object = xPath.compile(string);
            return (NodeList)object.evaluate(node, XPathConstants.NODESET);
        }
        catch (XPathException xPathException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath(xPathException);
        }
    }

    @Override
    public Node selectSingleNodeAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            Object object;
            XPath xPath = this.getXPathFactory().newXPath();
            if (null != xMLNamespaceResolver) {
                object = new JAXPNamespaceContext(xMLNamespaceResolver);
                xPath.setNamespaceContext((NamespaceContext)object);
            }
            object = xPath.compile(string);
            return (Node)object.evaluate(node, XPathConstants.NODE);
        }
        catch (XPathException xPathException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath(xPathException);
        }
    }

    @Override
    public boolean isWhitespaceNode(Text text) {
        String string = text.getNodeValue();
        if (null == string) {
            return false;
        }
        return string.trim().equals("");
    }

    @Override
    public XMLParser newXMLParser() {
        return new JAXPParser();
    }

    @Override
    public XMLTransformer newXMLTransformer() {
        return new JAXPTransformer();
    }

    @Override
    public Document createDocument() throws XMLPlatformException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    @Override
    public Document createDocumentWithPublicIdentifier(String string, String string2, String string3) throws XMLPlatformException {
        try {
            if (null == string2) {
                return this.createDocumentWithSystemIdentifier(string, string3);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
            Document document = dOMImplementation.createDocument(null, string, documentType);
            return document;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    @Override
    public Document createDocumentWithSystemIdentifier(String string, String string2) throws XMLPlatformException {
        try {
            Document document = null;
            if (null == string2) {
                document = this.createDocument();
                Element element = document.createElement(string);
                document.appendChild(element);
                return document;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, null, string2);
            document = dOMImplementation.createDocument(null, string, documentType);
            return document;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    @Override
    public String resolveNamespacePrefix(Node node, String string) throws XMLPlatformException {
        Node node2;
        if (null == string ? null == node.getPrefix() : string.equals(node.getPrefix())) {
            return node.getNamespaceURI();
        }
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            Attr attr = null;
            attr = string != null ? node2.getAttributeNode("xmlns:" + string) : node2.getAttributeNode("xmlns");
            if (null != attr) {
                return attr.getValue();
            }
        }
        if ((node2 = node.getParentNode()) != null && node2.getNodeType() == 1) {
            return this.resolveNamespacePrefix(node2, string);
        }
        return null;
    }

    @Override
    public boolean validateDocument(Document document, URL uRL, ErrorHandler errorHandler) throws XMLPlatformException {
        Schema schema;
        try {
            schema = this.getSchemaFactory().newSchema(uRL);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(uRL, sAXException);
        }
        try {
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(new DOMSource(document));
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformValidationException(exception);
        }
        return true;
    }

    @Override
    public boolean validate(Element element, XMLDescriptor xMLDescriptor, ErrorHandler errorHandler) throws XMLPlatformException {
        return true;
    }

    @Override
    public void namespaceQualifyFragment(Element element) {
        this.namespaceQualifyFragment(element, new ArrayList<String>());
    }

    private void namespaceQualifyFragment(Element element, List<String> list) {
        Object object;
        Node node;
        Object object2;
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        if (string2 != null && null == (object2 = element.getAttributeNode("xmlns:" + string2)) && !list.contains(string2)) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
            list.add(string2);
        }
        object2 = element.getAttributes();
        int n = object2.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            Attr attr = (Attr)object2.item(i);
            String string3 = attr.getPrefix();
            if (string3 == null) continue;
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                list.add(attr.getLocalName());
                continue;
            }
            node = element.getAttributeNode("xmlns:" + string3);
            if (null == node && !list.contains(string3)) {
                object = attr.getNamespaceURI();
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, (String)object);
                list.add(string3);
            }
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI()) || !"type".equals(attr.getLocalName()) || (n2 = ((String)(object = attr.getValue())).indexOf(58)) <= -1) continue;
            String string4 = ((String)object).substring(0, n2);
            node = element.getAttributeNode("xmlns:" + string4);
            if (null != node || list.contains(string4)) continue;
            String string5 = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(element, string4);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string5);
            list.add(string4);
        }
        NodeList nodeList = element.getChildNodes();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            object = (Element)node;
            this.namespaceQualifyFragment((Element)object, list);
        }
    }
}

