/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class EntityResult
extends SQLResult {
    protected String entityClassName;
    protected Class entityClass;
    protected Map fieldResults;
    protected String discriminatorColumn;

    public EntityResult(Class clazz) {
        this.entityClass = clazz;
        if (this.entityClass == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
    }

    public EntityResult(String string) {
        this.entityClassName = string;
        if (this.entityClassName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
    }

    public void addFieldResult(FieldResult fieldResult) {
        if (fieldResult == null || fieldResult.getAttributeName() == null) {
            return;
        }
        FieldResult fieldResult2 = (FieldResult)this.getFieldResults().get(fieldResult.getAttributeName());
        if (fieldResult2 == null) {
            this.getFieldResults().put(fieldResult.getAttributeName(), fieldResult);
        } else {
            fieldResult2.add(fieldResult);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            clazz = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.entityClassName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.entityClassName, privilegedActionException.getException());
                    }
                }
                clazz = PrivilegedAccessHelper.getClassForName(this.entityClassName, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.entityClassName, classNotFoundException);
            }
        }
        this.entityClass = clazz;
    }

    public Map getFieldResults() {
        if (this.fieldResults == null) {
            this.fieldResults = new HashMap();
        }
        return this.fieldResults;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(String string) {
        if (string == null) {
            return;
        }
        this.discriminatorColumn = string;
    }

    public Object getValueFromRecord(DatabaseRecord databaseRecord, ResultSetMappingQuery resultSetMappingQuery) {
        ClassDescriptor classDescriptor = resultSetMappingQuery.getSession().getDescriptor(this.entityClass);
        DatabaseRecord databaseRecord2 = new DatabaseRecord(classDescriptor.getFields().size());
        if (classDescriptor.hasInheritance()) {
            Object object;
            if (this.discriminatorColumn != null) {
                object = databaseRecord.get(this.discriminatorColumn);
                if (object == null) {
                    throw QueryException.discriminatorColumnNotSelected(this.discriminatorColumn, resultSetMappingQuery.getSQLResultSetMapping().getName());
                }
                databaseRecord2.put(classDescriptor.getInheritancePolicy().getClassIndicatorField(), databaseRecord.get(this.discriminatorColumn));
            } else {
                databaseRecord2.put(classDescriptor.getInheritancePolicy().getClassIndicatorField(), databaseRecord.get(classDescriptor.getInheritancePolicy().getClassIndicatorField()));
            }
            if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                object = classDescriptor.getInheritancePolicy().classFromRow(databaseRecord2, resultSetMappingQuery.getSession());
                classDescriptor = resultSetMappingQuery.getSession().getDescriptor((Class)object);
            }
        }
        for (DatabaseMapping databaseMapping : classDescriptor.getMappings()) {
            FieldResult fieldResult = (FieldResult)this.getFieldResults().get(databaseMapping.getAttributeName());
            if (fieldResult != null) {
                if (databaseMapping.getFields().size() == 1) {
                    databaseRecord2.put(databaseMapping.getFields().firstElement(), databaseRecord.get(fieldResult.getColumnName()));
                    continue;
                }
                if (databaseMapping.getFields().size() <= 1) continue;
                this.getValueFromRecordForMapping(databaseRecord2, databaseMapping, fieldResult, databaseRecord);
                continue;
            }
            for (DatabaseField databaseField : databaseMapping.getFields()) {
                databaseRecord2.put(databaseField, databaseRecord.get(databaseField));
            }
        }
        resultSetMappingQuery.setReferenceClass(this.entityClass);
        resultSetMappingQuery.setDescriptor(classDescriptor);
        return classDescriptor.getObjectBuilder().buildObject(resultSetMappingQuery, databaseRecord2, null);
    }

    public boolean isEntityResult() {
        return true;
    }

    public void getValueFromRecordForMapping(DatabaseRecord databaseRecord, DatabaseMapping databaseMapping, FieldResult fieldResult, DatabaseRecord databaseRecord2) {
        ClassDescriptor classDescriptor = databaseMapping.getReferenceDescriptor();
        if (fieldResult.getFieldResults() == null) {
            DatabaseField databaseField = this.processValueFromRecordForMapping(classDescriptor, fieldResult.getMultipleFieldIdentifiers(), 1);
            if (databaseMapping.isOneToOneMapping()) {
                databaseField = ((OneToOneMapping)databaseMapping).getTargetToSourceKeyFields().get(databaseField);
            }
            databaseRecord.put(databaseField, databaseRecord2.get(fieldResult.getColumnName()));
            return;
        }
        for (FieldResult fieldResult2 : fieldResult.getFieldResults()) {
            DatabaseField databaseField = this.processValueFromRecordForMapping(classDescriptor, fieldResult2.getMultipleFieldIdentifiers(), 1);
            if (databaseMapping.isOneToOneMapping()) {
                databaseField = ((OneToOneMapping)databaseMapping).getTargetToSourceKeyFields().get(databaseField);
            }
            databaseRecord.put(databaseField, databaseRecord2.get(fieldResult2.getColumnName()));
        }
    }

    public DatabaseField processValueFromRecordForMapping(ClassDescriptor classDescriptor, String[] stringArray, int n) {
        DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(stringArray[n]);
        if (databaseMapping == null) {
            throw QueryException.mappingForFieldResultNotFound(stringArray, n);
        }
        if (stringArray.length != ++n) {
            ClassDescriptor classDescriptor2 = databaseMapping.getReferenceDescriptor();
            DatabaseField databaseField = this.processValueFromRecordForMapping(classDescriptor2, stringArray, n);
            if (databaseMapping.isOneToOneMapping()) {
                return ((OneToOneMapping)databaseMapping).getTargetToSourceKeyFields().get(databaseField);
            }
            return databaseField;
        }
        return databaseMapping.getFields().firstElement();
    }
}

