/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class ReadQuery
extends DatabaseQuery {
    protected int maxRows = 0;
    protected int firstResult = 0;
    protected long queryId = 0L;
    protected int fetchSize = 0;
    protected QueryResultsCachePolicy queryResultCachingPolicy = null;
    protected transient Object temporaryCachedQueryResults = null;

    public Object buildObject(AbstractRecord abstractRecord) {
        return abstractRecord;
    }

    public void cacheQueryResults() {
        this.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
    }

    public abstract void cacheResult(Object var1);

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (this.shouldCacheQueryResults()) {
            this.setQueryResults(((ReadQuery)databaseQuery).getTemporaryCachedQueryResults(), databaseQuery.getTranslationRow(), databaseQuery.getSession());
        }
    }

    public void clearQueryResults(AbstractSession abstractSession) {
        abstractSession.getIdentityMapAccessor().clearQueryCache(this);
    }

    public void doNotCacheQueryResults() {
        this.setQueryResultsCachePolicy(null);
    }

    public QueryResultsCachePolicy getQueryResultsCachePolicy() {
        return this.queryResultCachingPolicy;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected Object getQueryResults(AbstractSession abstractSession) {
        return this.getQueryResults(abstractSession, this.getTranslationRow(), true);
    }

    protected Object getQueryResults(AbstractSession abstractSession, boolean bl) {
        return this.getQueryResults(abstractSession, this.getTranslationRow(), bl);
    }

    protected Object getQueryResults(AbstractSession abstractSession, AbstractRecord abstractRecord, boolean bl) {
        Vector vector = null;
        vector = abstractRecord == null ? new NonSynchronizedVector(1) : abstractRecord.getValues();
        return abstractSession.getIdentityMapAccessorInstance().getQueryResult(this, vector, bl);
    }

    public Object getTemporaryCachedQueryResults() {
        return this.temporaryCachedQueryResults;
    }

    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && this.getMaxRows() == 0 && this.getFirstResult() == 0 && this.getFetchSize() == 0;
    }

    public boolean isReadQuery() {
        return true;
    }

    public void copyFromQuery(DatabaseQuery databaseQuery) {
        super.copyFromQuery(databaseQuery);
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            this.fetchSize = readQuery.fetchSize;
            this.firstResult = readQuery.firstResult;
            this.maxRows = readQuery.maxRows;
            this.queryResultCachingPolicy = readQuery.queryResultCachingPolicy;
        }
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.shouldCacheQueryResults()) {
            this.clearQueryResults(this.getSession());
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        DatabaseCall databaseCall = this.getCall();
        if (databaseCall != null && databaseCall.shouldIgnoreFirstRowMaxResultsSettings()) {
            AbstractRecord abstractRecord = this.getTranslationRow();
            if (abstractRecord.isEmpty()) {
                abstractRecord = new DatabaseRecord();
            }
            abstractRecord.add(DatabaseCall.FIRSTRESULT_FIELD, this.getFirstResult());
            abstractRecord.add(DatabaseCall.MAXROW_FIELD, this.session.getPlatform().computeMaxRowsForSQL(this.getFirstResult(), this.getMaxRows()));
            this.setTranslationRow(abstractRecord);
        }
    }

    public Object remoteExecute(AbstractSession abstractSession) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object object;
            AbstractRecord abstractRecord = new DatabaseRecord();
            if (this.translationRow != null) {
                abstractRecord = this.translationRow;
            }
            if ((object = this.getQueryResults(abstractSession, abstractRecord, true)) != null) {
                return object;
            }
            object = super.remoteExecute(abstractSession);
            if (object != null) {
                this.setQueryResults(object, abstractRecord, abstractSession);
            }
            return object;
        }
        return super.remoteExecute(abstractSession);
    }

    public void setQueryResultsCachePolicy(QueryResultsCachePolicy queryResultsCachePolicy) {
        this.queryResultCachingPolicy = queryResultsCachePolicy;
        this.setIsPrepared(false);
    }

    public void setFirstResult(int n) {
        if (this.isPrepared() && this.firstResult != n && (this.getCall() == null || !this.getCall().shouldIgnoreFirstRowMaxResultsSettings())) {
            this.setIsPrepared(false);
        }
        this.firstResult = n;
        this.shouldCloneCall = true;
    }

    public void setQueryId(long l) {
        this.queryId = l;
    }

    public void setMaxRows(int n) {
        if (this.isPrepared() && this.maxRows != n && (this.getCall() == null || !this.getCall().shouldIgnoreFirstRowMaxResultsSettings() || this.maxRows <= 0)) {
            this.setIsPrepared(false);
        }
        this.maxRows = n;
        this.shouldCloneCall = true;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    protected void setQueryResults(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector vector = null;
        vector = abstractRecord == null ? new NonSynchronizedVector(1) : abstractRecord.getValues();
        abstractSession.getIdentityMapAccessorInstance().putQueryResult(this, vector, object);
    }

    public boolean shouldCacheQueryResults() {
        return this.queryResultCachingPolicy != null;
    }

    public void setTemporaryCachedQueryResults(Object object) {
        this.temporaryCachedQueryResults = object;
    }
}

