/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.jms;

import java.util.Hashtable;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.coordination.jms.JMSTopicRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.broadcast.BroadcastTransportManager;

public class JMSTopicTransportManager
extends BroadcastTransportManager {
    protected String connectionFactoryName;
    public static final String DEFAULT_TOPIC = "jms/TopLinkTopic";
    public static final String DEFAULT_CONNECTION_FACTORY = "jms/TopLinkTopicConnectionFactory";

    public JMSTopicTransportManager(RemoteCommandManager remoteCommandManager) {
        super(remoteCommandManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalConnection() {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            if (this.connectionsToExternalServices.isEmpty()) {
                try {
                    this.connectionsToExternalServices.put(this.rcm.getServiceId().getId(), this.createConnection(false));
                }
                catch (RemoteCommandManagerException remoteCommandManagerException) {
                    this.rcm.handleException(remoteCommandManagerException);
                }
            }
        }
    }

    public synchronized void createLocalConnection() {
        if (this.localConnection == null) {
            try {
                this.localConnection = this.createConnection(true);
            }
            catch (RemoteCommandManagerException remoteCommandManagerException) {
                this.rcm.handleException(remoteCommandManagerException);
            }
        }
    }

    protected JMSTopicRemoteConnection createConnection(boolean bl) throws RemoteCommandManagerException {
        Context context = null;
        try {
            context = this.getRemoteHostContext(this.getTopicHostUrl());
            TopicConnectionFactory topicConnectionFactory = this.getTopicConnectionFactory(context);
            Topic topic = this.getTopic(context);
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
            JMSTopicRemoteConnection jMSTopicRemoteConnection = new JMSTopicRemoteConnection(this.rcm, topicConnection, topic, bl);
            return jMSTopicRemoteConnection;
        }
        catch (Exception exception) {
            RemoteCommandManagerException remoteCommandManagerException = bl ? RemoteCommandManagerException.errorCreatingLocalJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), exception) : RemoteCommandManagerException.errorCreatingJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), exception);
            throw remoteCommandManagerException;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalConnection() {
        JMSTopicRemoteConnection jMSTopicRemoteConnection = (JMSTopicRemoteConnection)this.localConnection;
        JMSTopicTransportManager jMSTopicTransportManager = this;
        synchronized (jMSTopicTransportManager) {
            if (jMSTopicRemoteConnection == this.localConnection) {
                this.localConnection = null;
            } else {
                jMSTopicRemoteConnection = null;
            }
        }
        if (jMSTopicRemoteConnection != null) {
            jMSTopicRemoteConnection.close();
        }
    }

    public void createConnections() {
        this.createExternalConnection();
        this.createLocalConnection();
    }

    public void setTopicConnectionFactoryName(String string) {
        this.connectionFactoryName = string;
    }

    public String getTopicConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void initialize() {
        super.initialize();
        this.topicName = DEFAULT_TOPIC;
        this.connectionFactoryName = DEFAULT_CONNECTION_FACTORY;
    }

    public String getTopicHostUrl() {
        return (String)this.getRemoteContextProperties().get("java.naming.provider.url");
    }

    public void setTopicHostUrl(String string) {
        this.getRemoteContextProperties().put("java.naming.provider.url", string);
        this.rcm.getServiceId().setURL(string);
    }

    public void setNamingServiceType(int n) {
        if (n != 0) {
            throw ValidationException.operationNotSupported("setNamingServiceType");
        }
    }

    protected Topic getTopic(Context context) {
        try {
            return (Topic)context.lookup(this.topicName);
        }
        catch (NamingException namingException) {
            RemoteCommandManagerException remoteCommandManagerException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.topicName, this.rcm.getUrl(), namingException);
            this.rcm.handleException(remoteCommandManagerException);
            throw remoteCommandManagerException;
        }
    }

    protected TopicConnectionFactory getTopicConnectionFactory(Context context) {
        try {
            return (TopicConnectionFactory)context.lookup(this.connectionFactoryName);
        }
        catch (NamingException namingException) {
            RemoteCommandManagerException remoteCommandManagerException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.connectionFactoryName, this.rcm.getUrl(), namingException);
            this.rcm.handleException(remoteCommandManagerException);
            throw remoteCommandManagerException;
        }
    }

    public Hashtable getConnectionsToExternalServicesForCommandPropagation() {
        if (this.getConnectionsToExternalServices().isEmpty() && !this.rcm.isStopped()) {
            this.createExternalConnection();
            if (this.localConnection == null) {
                this.rcm.getServerPlatform().launchContainerRunnable(new Runnable(){

                    public void run() {
                        try {
                            JMSTopicTransportManager.this.createLocalConnection();
                        }
                        catch (RemoteCommandManagerException remoteCommandManagerException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        return super.getConnectionsToExternalServicesForCommandPropagation();
    }
}

