/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class RemoteSession
extends DistributedSession {
    protected Sequencing sequencing;
    protected boolean shouldEnableDistributedIndirectionGarbageCollection = false;

    public RemoteSession(RemoteConnection remoteConnection) {
        super(remoteConnection);
        this.initializeSequencing();
    }

    public void setShouldEnableDistributedIndirectionGarbageCollection(boolean bl) {
        this.shouldEnableDistributedIndirectionGarbageCollection = bl;
    }

    public boolean shouldEnableDistributedIndirectionGarbageCollection() {
        return this.shouldEnableDistributedIndirectionGarbageCollection;
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        return new RemoteUnitOfWork(this, referenceMode);
    }

    public Object executeQuery(DatabaseQuery databaseQuery) {
        return databaseQuery.remoteExecute(this);
    }

    public Login getDatasourceLogin() {
        Login login = super.getDatasourceLogin();
        if (login == null) {
            login = this.getRemoteConnection().getLogin();
            this.setDatasourceLogin(login);
        }
        return login;
    }

    public Object getObjectCorrespondingTo(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery) {
        Cloneable cloneable;
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor.isAggregateCollectionDescriptor() || objectLevelReadQuery != null && !objectLevelReadQuery.shouldMaintainCache()) {
            if (objectLevelReadQuery != null && !objectLevelReadQuery.hasPartialAttributeExpressions()) {
                classDescriptor.getObjectBuilder().fixObjectReferences(object, map, map2, objectLevelReadQuery, this);
            }
            return object;
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)map.get(object);
        if (objectDescriptor == null) {
            objectDescriptor = new ObjectDescriptor();
            objectDescriptor.setKey(classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this));
            objectDescriptor.setObject(object);
            cloneable = classDescriptor.getOptimisticLockingPolicy();
            if (cloneable == null) {
                objectDescriptor.setWriteLockValue(null);
            } else {
                objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
            }
            map.put(object, objectDescriptor);
        }
        cloneable = objectDescriptor.getKey();
        Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap((Vector)cloneable, object.getClass(), classDescriptor);
        if (map2.containsKey(object)) {
            if (object2 == null) {
                return object;
            }
            return object2;
        }
        map2.put(object, object);
        if (object2 == null) {
            this.getIdentityMapAccessorInstance().putInIdentityMap(object, (Vector)cloneable, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), classDescriptor);
            classDescriptor.getObjectBuilder().fixObjectReferences(object, map, map2, objectLevelReadQuery, this);
            object2 = object;
        } else if (objectLevelReadQuery == null || objectLevelReadQuery.shouldRefreshRemoteIdentityMapResult() || this.getDescriptor(object2).shouldAlwaysRefreshCacheOnRemote()) {
            MergeManager mergeManager = new MergeManager(this);
            mergeManager.refreshRemoteObject();
            mergeManager.setObjectDescriptors(map);
            if (objectLevelReadQuery == null) {
                mergeManager.cascadePrivateParts();
            } else {
                mergeManager.setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
            }
            object2 = mergeManager.mergeChanges(object, null);
        }
        return object2;
    }

    public Object getObjectsCorrespondingToAll(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, ContainerPolicy containerPolicy) {
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, this);
            containerPolicy.addInto(this.getObjectCorrespondingTo(object4, map, map2, objectLevelReadQuery), object2, this);
        }
        return object2;
    }

    public Object instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        Transporter transporter = this.getRemoteConnection().instantiateRemoteValueHolderOnServer(remoteValueHolder);
        return remoteValueHolder.getMapping().getObjectCorrespondingTo(transporter.getObject(), this, transporter.getObjectDescriptors(), new IdentityHashMap(), remoteValueHolder.getQuery());
    }

    public boolean isRemoteSession() {
        return true;
    }

    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }
}

