/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.StringWriter;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ClientSessionIdentityMapAccessor;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Accessor writeConnection;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        this(serverSession, connectionPolicy, null);
    }

    public ClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy, Map map) {
        super(serverSession.getProject());
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject((Project)this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        this.isLoggingOff = serverSession.isLoggingOff();
        this.isActive = true;
        this.externalTransactionController = serverSession.getExternalTransactionController();
        this.parent = serverSession;
        this.connectionPolicy = connectionPolicy;
        this.writeConnection = this.accessor;
        this.accessor = serverSession.getAccessor();
        this.name = serverSession.getName();
        this.profiler = serverSession.getProfiler();
        this.isInProfile = serverSession.isInProfile();
        this.commitManager = serverSession.getCommitManager();
        this.sessionLog = serverSession.getSessionLog();
        this.eventManager = serverSession.getEventManager().clone(this);
        this.exceptionHandler = serverSession.getExceptionHandler();
        this.pessimisticLockTimeoutDefault = serverSession.getPessimisticLockTimeoutDefault();
        this.queryTimeoutDefault = serverSession.getQueryTimeoutDefault();
        this.properties = map;
        this.eventManager.postAcquireClientSession();
        this.incrementProfile("ClientSession");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    public void releaseJTSConnection() {
        if (this.hasWriteConnection()) {
            this.getWriteConnection().closeJTSConnection();
            this.releaseWriteConnection();
        }
    }

    public void basicBeginTransaction() {
        if (this.getWriteConnection() == null && this.getConnectionPolicy().isLazy()) {
            this.getParent().acquireClientConnection(this);
        }
        try {
            super.basicBeginTransaction();
        }
        catch (RuntimeException runtimeException) {
            if (this.getWriteConnection() != null && !this.getWriteConnection().isInTransaction() && this.getConnectionPolicy().isLazy()) {
                this.getParent().releaseClientSession(this);
            }
            throw runtimeException;
        }
    }

    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (this.hasExternalTransactionController()) {
            if (!this.isSynchronized()) {
                this.releaseJTSConnection();
            }
        } else {
            this.releaseWriteConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicRollbackTransaction() {
        try {
            if (this.hasWriteConnection()) {
                super.basicRollbackTransaction();
            }
        }
        finally {
            if (this.hasExternalTransactionController()) {
                if (!this.isSynchronized()) {
                    this.releaseJTSConnection();
                }
            } else {
                this.releaseWriteConnection();
            }
        }
    }

    public void connect() throws DatabaseException {
        this.getWriteConnection().connect(this.getDatasourceLogin(), this);
    }

    public boolean containsQuery(String string) {
        boolean bl = this.getQueries().containsKey(string);
        if (!bl) {
            bl = this.getParent().containsQuery(string);
        }
        return bl;
    }

    public void disconnect() throws DatabaseException {
        this.getWriteConnection().disconnect(this);
    }

    public Accessor getAccessor() {
        if (this.isInTransaction()) {
            return this.getWriteConnection();
        }
        return super.getAccessor();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public Map getDescriptors() {
        return this.getParent().getDescriptors();
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        return this.getParent().getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public Object getProperty(String string) {
        Object object = super.getProperties().get(string);
        if (object == null) {
            object = this.getParent().getProperty(string);
        }
        return object;
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public ServerSession getParent() {
        return this.parent;
    }

    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string);
        }
        return databaseQuery;
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string, vector);
        }
        return databaseQuery;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Accessor getWriteConnection() {
        return this.writeConnection;
    }

    protected boolean hasWriteConnection() {
        if (this.getWriteConnection() == null) {
            return false;
        }
        return this.getWriteConnection().isConnected();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isClientSession() {
        return true;
    }

    public boolean isConnected() {
        return this.getParent().isConnected();
    }

    public void release() throws DatabaseException {
        if (!this.isActive()) {
            return;
        }
        this.getEventManager().preReleaseClientSession();
        if (this.getWriteConnection() != null) {
            this.getParent().releaseClientSession(this);
        }
        this.setIsActive(false);
        this.log(2, "connection", "client_released");
        this.getEventManager().postReleaseClientSession();
    }

    protected void releaseWriteConnection() {
        if (this.getConnectionPolicy().isLazy() && this.getWriteConnection() != null) {
            this.getParent().releaseClientSession(this);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    protected void setParent(ServerSession serverSession) {
        this.parent = serverSession;
    }

    public void setWriteConnection(Accessor accessor) {
        if (accessor != null) {
            this.writeConnection = accessor;
            this.writeConnection.createCustomizer(this);
        } else if (this.writeConnection != null) {
            this.writeConnection.releaseCustomizer(this);
            this.writeConnection = null;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString());
        stringWriter.write("(");
        stringWriter.write(String.valueOf(this.getWriteConnection()));
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public CommandManager getCommandManager() {
        return this.getParent().getCommandManager();
    }

    public boolean shouldPropagateChanges() {
        return this.getParent().shouldPropagateChanges();
    }

    public void releaseReadConnection(Accessor accessor) {
        this.getParent().releaseReadConnection(accessor);
    }

    public void postConnectExternalConnection(Accessor accessor) {
        this.getEventManager().postAcquireConnection(accessor);
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        this.getEventManager().preReleaseConnection(accessor);
    }

    public boolean isExclusiveConnectionRequired() {
        return !this.getConnectionPolicy().isLazy && this.isActive();
    }
}

