/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected int initialNumberOfConnections;
    protected int waitTimeout;
    protected List<Accessor> connectionsAvailable;
    protected List<Accessor> connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;
    protected boolean checkConnections;
    public static final int MAX_CONNECTIONS = 32;
    public static final int MIN_CONNECTIONS = 32;
    public static final int INITIAL_CONNECTIONS = 1;
    public static final int WAIT_TIMEOUT = 180000;

    public ConnectionPool() {
        this.maxNumberOfConnections = 32;
        this.minNumberOfConnections = 32;
        this.initialNumberOfConnections = 1;
        this.waitTimeout = 180000;
        this.checkConnections = false;
        this.resetConnections();
    }

    public ConnectionPool(String string, Login login, ServerSession serverSession) {
        this(string, login, 1, 32, 32, serverSession);
    }

    public ConnectionPool(String string, Login login, int n, int n2, ServerSession serverSession) {
        this(string, login, Math.min(1, n), n, n2, serverSession);
    }

    public ConnectionPool(String string, Login login, int n, int n2, int n3, ServerSession serverSession) {
        this.login = login;
        this.owner = serverSession;
        this.name = string;
        this.maxNumberOfConnections = n3;
        this.minNumberOfConnections = n2;
        this.initialNumberOfConnections = n;
        this.checkConnections = false;
        this.resetConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        while (this.connectionsAvailable.isEmpty()) {
            if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.maxNumberOfConnections) {
                Accessor accessor = this.buildConnection();
                this.connectionsUsed.add(accessor);
                return accessor;
            }
            try {
                this.wait(this.waitTimeout);
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitFailureOnClientSession(interruptedException);
            }
        }
        int n = this.connectionsAvailable.size();
        Accessor accessor = this.connectionsAvailable.remove(n - 1);
        if (this.checkConnections) {
            while (n >= 0) {
                if (this.owner.getLogin().isConnectionHealthValidatedOnError() && this.owner.getServerPlatform().wasFailureCommunicationBased(null, accessor, this.owner)) {
                    try {
                        accessor.closeConnection();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        accessor.releaseCustomizer();
                    }
                    if (this.connectionsAvailable.isEmpty()) {
                        this.checkConnections = false;
                        return this.acquireConnection();
                    }
                    accessor = this.connectionsAvailable.remove(--n - 1);
                    continue;
                }
                this.checkConnections = false;
                break;
            }
        }
        this.connectionsUsed.add(accessor);
        if (this.owner.isInProfile()) {
            this.owner.updateProfile(this.name, new Integer(this.connectionsUsed.size()));
        }
        return accessor;
    }

    protected Accessor buildConnection() {
        Login login = (Login)this.getLogin().clone();
        Accessor accessor = login.buildAccessor();
        accessor.connect(login, this.getOwner());
        return accessor;
    }

    public List<Accessor> getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected List<Accessor> getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor accessor) throws DatabaseException {
        accessor.reset();
        this.connectionsUsed.remove(accessor);
        if (!accessor.isValid()) {
            this.owner.setCheckConnections();
            try {
                accessor.disconnect(this.owner);
            }
            catch (DatabaseException databaseException) {}
        } else if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.minNumberOfConnections) {
            this.connectionsAvailable.add(accessor);
        } else {
            accessor.disconnect(this.getOwner());
        }
        if (this.owner.isInProfile()) {
            this.owner.updateProfile(this.name, new Integer(this.connectionsUsed.size()));
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector<Accessor>();
        this.connectionsAvailable = new Vector<Accessor>();
        this.checkConnections = false;
    }

    public void setCheckConnections() {
        this.checkConnections = true;
    }

    protected void setConnectionsAvailable(Vector vector) {
        this.connectionsAvailable = vector;
    }

    protected void setConnectionsUsed(Vector vector) {
        this.connectionsUsed = vector;
    }

    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public int getInitialNumberOfConnections() {
        return this.initialNumberOfConnections;
    }

    public void setInitialNumberOfConnections(int n) {
        this.initialNumberOfConnections = n;
    }

    public void setMaxNumberOfConnections(int n) {
        this.maxNumberOfConnections = n;
    }

    public void setMinNumberOfConnections(int n) {
        this.minNumberOfConnections = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setOwner(ServerSession serverSession) {
        this.owner = serverSession;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Iterator<Accessor> iterator = this.getConnectionsAvailable().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        iterator = this.getConnectionsUsed().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        for (int i = this.getInitialNumberOfConnections(); i > 0; --i) {
            this.getConnectionsAvailable().add(this.buildConnection());
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.getMinNumberOfConnections()), new Integer(this.getMaxNumberOfConnections())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("min_max", objectArray);
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int n) {
        this.waitTimeout = n;
    }
}

