/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ForeignKeyConstraint
implements Serializable {
    protected String name = "";
    protected Vector sourceFields = new Vector();
    protected Vector targetFields = new Vector();
    protected String targetTable = "";
    protected boolean shouldCascadeOnDelete = false;

    public ForeignKeyConstraint() {
    }

    public ForeignKeyConstraint(String string, String string2, String string3, String string4) {
        this();
        this.name = string;
        this.sourceFields.addElement(string2);
        this.targetFields.addElement(string3);
        this.targetTable = string4;
    }

    public void addSourceField(String string) {
        this.getSourceFields().addElement(string);
    }

    public void addTargetField(String string) {
        this.getTargetFields().addElement(string);
    }

    public void appendDBString(Writer writer, AbstractSession abstractSession) {
        try {
            writer.write("FOREIGN KEY (");
            Enumeration enumeration = this.getSourceFields().elements();
            while (enumeration.hasMoreElements()) {
                writer.write((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(") REFERENCES ");
            writer.write(this.getTargetTable());
            writer.write(" (");
            enumeration = this.getTargetFields().elements();
            while (enumeration.hasMoreElements()) {
                writer.write((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
            if (this.shouldCascadeOnDelete()) {
                writer.write(" ON DELETE CASCADE");
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void cascadeOnDelete() {
        this.setShouldCascadeOnDelete(true);
    }

    public void dontCascadeOnDelete() {
        this.setShouldCascadeOnDelete(false);
    }

    public String getName() {
        return this.name;
    }

    public Vector getSourceFields() {
        return this.sourceFields;
    }

    public Vector getTargetFields() {
        return this.targetFields;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setShouldCascadeOnDelete(boolean bl) {
        this.shouldCascadeOnDelete = bl;
    }

    public void setSourceFields(Vector vector) {
        this.sourceFields = vector;
    }

    public void setTargetFields(Vector vector) {
        this.targetFields = vector;
    }

    public void setTargetTable(String string) {
        this.targetTable = string;
    }

    public boolean shouldCascadeOnDelete() {
        return this.shouldCascadeOnDelete;
    }
}

