/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.listener")
public class CreateHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttpListener.class);
    @Param(name="listeneraddress")
    String listenerAddress;
    @Param(name="listenerport")
    String listenerPort;
    @Param(name="defaultvs")
    String defaultVirtualServer;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="acceptorthreads", optional=true)
    String acceptorThreads;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy;
    @Param(name="redirectport", optional=true)
    String redirectPort;
    @Param(name="externalport", optional=true)
    String externalPort;
    @Param(name="securityenabled", optional=true, defaultValue="false")
    Boolean securityEnabled;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean secure;
    @Param(name="family", optional=true)
    String family;
    @Param(name="blockingenabled", optional=true, defaultValue="false")
    Boolean blockingEnabled;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        HttpService httpService = config.getHttpService();
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getName().equals(this.listenerId)) continue;
            report.setMessage(localStrings.getLocalString("create.http.listener.duplicate", "Http Listener named {0} already exists.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.listenerPort) || !listener.getAddress().trim().equals(this.listenerAddress)) continue;
            String def = "Port is already taken by another listener, choose another port.";
            String msg = localStrings.getLocalString("port.occupied", def, new Object[]{this.listenerPort, listener.getName(), this.listenerAddress});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.defaultVirtualServerExists(httpService)) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.notexists", "Virtual Server, {0} doesn't exist", new Object[]{this.defaultVirtualServer}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        VirtualServer vs = httpService.getVirtualServerByName(this.defaultVirtualServer);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(final NetworkConfig configParam) throws TransactionFailure {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

                        public Object run(NetworkListeners listenersParam) throws TransactionFailure, PropertyVetoException {
                            NetworkListener newListener = (NetworkListener)listenersParam.createChild(NetworkListener.class);
                            newListener.setName(CreateHttpListener.this.listenerId);
                            newListener.setAddress(CreateHttpListener.this.listenerAddress);
                            newListener.setPort(CreateHttpListener.this.listenerPort);
                            CreateHttpListener.this.createOrSetTransport(configParam, newListener);
                            CreateHttpListener.this.createProtocol(configParam, newListener);
                            CreateHttpListener.this.setThreadPool(configParam, newListener);
                            listenersParam.getNetworkListener().add(newListener);
                            return listenersParam;
                        }
                    }, (ConfigBeanProxy)configParam.getNetworkListeners());
                    return null;
                }
            }, (ConfigBeanProxy)networkConfig);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer avs) throws PropertyVetoException {
                    String DELIM = ",";
                    String lss = avs.getNetworkListeners();
                    boolean listenerShouldBeAdded = true;
                    if (lss == null || lss.length() == 0) {
                        lss = CreateHttpListener.this.listenerId;
                    } else if (!lss.contains(CreateHttpListener.this.listenerId)) {
                        if (!lss.endsWith(DELIM)) {
                            lss = lss + DELIM;
                        }
                        lss = lss + CreateHttpListener.this.listenerId;
                    } else {
                        listenerShouldBeAdded = false;
                    }
                    if (listenerShouldBeAdded) {
                        avs.setNetworkListeners(lss);
                    }
                    return avs;
                }
            }, (ConfigBeanProxy)vs);
        }
        catch (TransactionFailure e) {
            String actual = e.getMessage();
            String def = "Creation of: " + this.listenerId + "failed because of: " + actual;
            String msg = localStrings.getLocalString("create.http.listener.fail", def, new Object[]{this.listenerId, actual});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void setThreadPool(NetworkConfig config, NetworkListener newListener) {
        List pools = ((Config)config.getParent(Config.class)).getThreadPools().getThreadPool();
        for (ThreadPool pool : pools) {
            if (!"http-thread-pool".equals(pool.getName())) continue;
            newListener.setThreadPool(pool.getName());
        }
        if (newListener.getThreadPool() == null && !pools.isEmpty()) {
            newListener.setThreadPool(((ThreadPool)pools.get(0)).getName());
        }
    }

    private Transport createOrSetTransport(NetworkConfig config, NetworkListener listener) throws TransactionFailure {
        Transports transports = config.getTransports();
        Transport transport = null;
        for (Transport item : transports.getTransport()) {
            if (!"tcp".equals(item.getName())) continue;
            listener.setTransport(item.getName());
            transport = item;
        }
        if (transport == null) {
            transport = (Transport)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) throws TransactionFailure {
                    Transport newTransport = (Transport)param.createChild(Transport.class);
                    newTransport.setName(CreateHttpListener.this.listenerId + "-transport");
                    newTransport.setAcceptorThreads(CreateHttpListener.this.acceptorThreads);
                    param.getTransport().add(newTransport);
                    return newTransport;
                }
            }, (ConfigBeanProxy)config.getTransports());
            listener.setTransport(transport.getName());
        }
        return transport;
    }

    private Protocol createProtocol(NetworkConfig config, final NetworkListener listener) throws TransactionFailure {
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                protocol.setSecurityEnabled(CreateHttpListener.this.securityEnabled.toString());
                protocol.setName(CreateHttpListener.this.listenerId + "-protocol");
                param.getProtocol().add(protocol);
                listener.setProtocol(protocol.getName());
                Http http = (Http)protocol.createChild(Http.class);
                http.setDefaultVirtualServer(CreateHttpListener.this.defaultVirtualServer);
                http.setXpoweredBy(CreateHttpListener.this.xPoweredBy.toString());
                listener.setEnabled(CreateHttpListener.this.enabled.toString());
                http.setServerName(CreateHttpListener.this.serverName);
                protocol.setHttp(http);
                return protocol;
            }
        }, (ConfigBeanProxy)config.getProtocols());
    }

    private boolean defaultVirtualServerExists(HttpService httpService) {
        if (this.defaultVirtualServer == null) {
            return false;
        }
        List list = httpService.getVirtualServer();
        for (VirtualServer vs : list) {
            String currId = vs.getId();
            if (currId == null || !currId.equals(this.defaultVirtualServer)) continue;
            return true;
        }
        return false;
    }
}

