/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RenderingHelper {
    private static final String CHILD_COMP_MARKER = "___children___";
    private static final int CHILD_COMP_MARKER_LENGTH = "___children___".length();

    public static String getAfterText(String templateText) {
        String afterText = "";
        int index = templateText.indexOf(CHILD_COMP_MARKER);
        if (index > -1 && index + CHILD_COMP_MARKER_LENGTH > templateText.length()) {
            afterText = templateText.substring(index + CHILD_COMP_MARKER_LENGTH);
        }
        return afterText;
    }

    public static String getBeforeText(String templateText) {
        int index = templateText.indexOf(CHILD_COMP_MARKER);
        return index > -1 ? templateText.substring(0, index) : templateText;
    }

    public static String loadTemplateText(UIComponent comp, String templateFile) {
        StringBuilder builder = new StringBuilder();
        BufferedReader in = null;
        try {
            String str;
            URL url = comp.getClass().getClassLoader().getResource(templateFile.substring(1));
            if (url == null) {
                throw new IOException("File not found: " + templateFile);
            }
            in = new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream())));
            while ((str = in.readLine()) != null) {
                builder.append(str + "\n");
            }
        }
        catch (IOException e) {
            throw new FacesException("Unable to load template file " + templateFile, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
        return RenderingHelper.processTemplateMarkers(comp, builder.toString());
    }

    public static void outputElement(ResponseWriter writer, UIComponent component, String elementName, String[][] attrs) throws IOException {
        writer.startElement(elementName, component);
        for (String[] attr : attrs) {
            writer.writeAttribute(attr[0], (Object)attr[1], attr[0]);
        }
        writer.endElement(elementName);
    }

    public static String processTemplateMarkers(UIComponent comp, String templateText) {
        FacesContext context = FacesContext.getCurrentInstance();
        String processed = templateText.replaceAll("___id___", comp.getId());
        processed = processed.replaceAll("___clientId___", comp.getClientId(context));
        for (Map.Entry attr : comp.getAttributes().entrySet()) {
            Object value = attr.getValue();
            if (value == null) continue;
            String key = "___property_" + (String)attr.getKey() + "___";
            processed = processed.replaceAll(key, value.toString());
        }
        return processed;
    }

    public static void writeOnDomReady(ResponseWriter writer, String js) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.write("YAHOO.util.Event.onDOMReady(function (ev) {" + js + "});");
        writer.endElement("script");
    }

    public static void writeOnContentReady(ResponseWriter writer, String clientId, String js) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.write("YAHOO.util.Event.onContentReady('" + clientId + "', function (ev) {" + js + "});");
        writer.endElement("script");
    }
}

