/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.sql.DataSource;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.JPAApplication;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPAApplication> {
    @Inject
    private ConnectorRuntime connectorRuntime;

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin == OpsParams.Origin.undeploy) {
            Java2DBProcessorHelper helper = new Java2DBProcessorHelper(dc);
            helper.init();
            helper.createOrDropTablesInDB(false, "JPA");
        }
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        boolean prepared = super.prepare(context);
        if (prepared) {
            Application application = (Application)context.getModuleMetaData(Application.class);
            Set bundles = application.getBundleDescriptors();
            ArrayList<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
            for (BundleDescriptor bundle : bundles) {
                Collection pusReferencedFromBundle = bundle.findReferencedPUs();
                for (PersistenceUnitDescriptor pud : pusReferencedFromBundle) {
                    referencedPus.add(pud);
                }
            }
            RootDeploymentDescriptor currentBundle = (RootDeploymentDescriptor)context.getModuleMetaData(BundleDescriptor.class);
            if (currentBundle == null) {
                currentBundle = application;
            }
            ArrayList<PersistenceUnitDescriptor> pusToInitialize = new ArrayList<PersistenceUnitDescriptor>();
            Collection pusDescriptorForThisBundle = currentBundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class);
            for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : pusDescriptorForThisBundle) {
                for (PersistenceUnitDescriptor pud : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                    if (!referencedPus.contains(pud)) continue;
                    pusToInitialize.add(pud);
                }
                JPAApplication jpaApp = new JPAApplication(pusToInitialize, new ProviderContainerContractInfoImpl(context, this.connectorRuntime));
                context.addTransientAppMetaData(persistenceUnitsDescriptor.getAbsolutePuRoot(), (Object)jpaApp);
            }
        }
        return prepared;
    }

    public JPAApplication load(JPAContainer container, DeploymentContext context) {
        JPAApplication jpaApp = null;
        RootDeploymentDescriptor currentBundle = (RootDeploymentDescriptor)context.getModuleMetaData(BundleDescriptor.class);
        if (currentBundle == null) {
            currentBundle = (RootDeploymentDescriptor)context.getModuleMetaData(Application.class);
        }
        Collection pusDescriptorForThisBundle = currentBundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class);
        for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : pusDescriptorForThisBundle) {
            jpaApp = (JPAApplication)context.getTransientAppMetaData(persistenceUnitsDescriptor.getAbsolutePuRoot(), JPAApplication.class);
            if (jpaApp == null) continue;
            jpaApp.doJava2DB(context);
        }
        return jpaApp;
    }

    private static class ProviderContainerContractInfoImpl
    implements ProviderContainerContractInfo {
        private final DeploymentContext deploymentContext;
        private final ConnectorRuntime connectorRuntime;
        private final ClassLoader finalClassLoader;

        public ProviderContainerContractInfoImpl(DeploymentContext deploymentContext, ConnectorRuntime connectorRuntime) {
            this.deploymentContext = deploymentContext;
            this.connectorRuntime = connectorRuntime;
            this.finalClassLoader = deploymentContext.getFinalClassLoader();
        }

        public ClassLoader getClassLoader() {
            return this.finalClassLoader;
        }

        public ClassLoader getTempClassloader() {
            return ((InstrumentableClassLoader)this.deploymentContext.getClassLoader()).copy();
        }

        public void addTransformer(final ClassTransformer transformer) {
            this.deploymentContext.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                }
            });
        }

        public String getApplicationLocation() {
            ReadableArchive archive = this.deploymentContext.getSource();
            boolean appRootFound = false;
            while (!appRootFound) {
                ReadableArchive parentArchive = archive.getParentArchive();
                if (parentArchive != null) {
                    archive = parentArchive;
                    continue;
                }
                appRootFound = true;
            }
            return archive.getURI().getPath();
        }

        public DataSource lookupDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupPMResource(dataSourceName, false));
        }

        public DataSource lookupNonTxDataSource(String dataSourceName) throws NamingException {
            return (DataSource)DataSource.class.cast(this.connectorRuntime.lookupNonTxResource(dataSourceName, false));
        }

        public DeploymentContext getDeploymentContext() {
            return this.deploymentContext;
        }
    }
}

