/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.GrizzlyContext;
import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackApplicationFactory;
import com.sun.grizzly.jruby.rack.RackInitializationException;
import com.sun.grizzly.jruby.rack.RubyRuntimeFactory;
import com.sun.grizzly.scripting.pool.PoolAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RackApplicationPoolAdapter
implements PoolAdapter<RackApplication> {
    private final RackApplicationFactory factory;
    private final RubyRuntimeFactory rubyFactory = new RubyRuntimeFactory();
    private final RackGrizzlyAdapter adapter;

    public RackApplicationPoolAdapter(RackApplicationFactory f, RackGrizzlyAdapter adapter) {
        this.factory = f;
        this.adapter = adapter;
    }

    @Override
    public RackApplication initializeObject() {
        Ruby runtime = this.rubyFactory.makeRubyRuntime(this.adapter.config.jrubyHome());
        try {
            GrizzlyContext context = new GrizzlyContext(this.adapter);
            runtime.defineReadonlyVariable("$grizzly_context", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)context));
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)context.getLogger());
            runtime.defineReadonlyVariable("$logger", loggerObj);
            String log_level = this.getEffectiveLogLevel();
            IRubyObject GF_log_level = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)log_level);
            runtime.defineReadonlyVariable("$glassfish_log_level", GF_log_level);
            runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.adapter.config.contextRoot()));
            return this.factory.newApplication(runtime);
        }
        catch (RackInitializationException e) {
            this.adapter.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return this.factory.getErrorApplication(runtime);
        }
    }

    private String getEffectiveLogLevel() {
        Logger pLog = this.adapter.getLogger();
        Level myLevel = pLog.getLevel();
        while (myLevel == null) {
            pLog = pLog.getParent();
            myLevel = pLog.getLevel();
        }
        return myLevel.getName();
    }

    @Override
    public void dispose(RackApplication dead) {
        dead.destroy();
    }

    @Override
    public boolean validate(RackApplication toCheck) {
        return true;
    }
}

