/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class UtilHandlers {
    public static void ifHandler(HandlerContext context) {
    }

    public static void println(HandlerContext context) {
        String value = (String)context.getInputValue("value");
        System.out.println(value);
    }

    public static void write(HandlerContext context) {
        String text = (String)context.getInputValue("value");
        if (text == null) {
            text = "";
        }
        try {
            context.getFacesContext().getResponseWriter().write(text);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void dec(HandlerContext context) {
        Integer value = (Integer)context.getInputValue("number");
        context.setOutputValue("value", new Integer(value - 1));
    }

    public static void inc(HandlerContext context) {
        Integer value = (Integer)context.getInputValue("number");
        context.setOutputValue("value", new Integer(value + 1));
    }

    public static void getIterator(HandlerContext context) {
        List list = (List)context.getInputValue("list");
        context.setOutputValue("iterator", list.iterator());
    }

    public static void iteratorHasNext(HandlerContext context) {
        Iterator it = (Iterator)context.getInputValue("iterator");
        context.setOutputValue("hasNext", it.hasNext());
    }

    public static void iteratorNext(HandlerContext context) {
        Iterator it = (Iterator)context.getInputValue("iterator");
        context.setOutputValue("next", it.next());
    }

    public static void createList(HandlerContext context) {
        int size = (Integer)context.getInputValue("size");
        ArrayList<String> list = new ArrayList<String>(size);
        for (int count = 0; count < size; ++count) {
            list.add("");
        }
        context.setOutputValue("result", list);
    }

    public static void createMap(HandlerContext context) {
        HashMap map = new HashMap();
        context.setOutputValue("result", map);
    }

    public static void mapPut(HandlerContext context) {
        Map map = (Map)context.getInputValue("map");
        Object key = context.getInputValue("key");
        Object value = context.getInputValue("value");
        map.put(key, value);
    }

    public static boolean returnTrue(HandlerContext context) {
        return true;
    }

    public static boolean returnFalse(HandlerContext context) {
        return false;
    }

    public static void getClientId(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        context.setOutputValue("clientId", comp.getClientId(context.getFacesContext()));
    }

    public static void getId(HandlerContext context) {
        Object obj = context.getInputValue("object");
        if (obj == null) {
            return;
        }
        String clientId = null;
        String id = null;
        if (obj instanceof UIComponent) {
            clientId = ((UIComponent)obj).getClientId(context.getFacesContext());
            id = ((UIComponent)obj).getId();
        } else {
            clientId = obj.toString();
            id = clientId.substring(clientId.lastIndexOf(58) + 1);
        }
        context.setOutputValue("id", id);
        context.setOutputValue("clientId", clientId);
    }

    public static void printStackTrace(HandlerContext context) {
        String msg = (String)context.getInputValue("msg");
        if (msg == null) {
            msg = "";
        }
        StringWriter strWriter = new StringWriter();
        new RuntimeException(msg).printStackTrace(new PrintWriter(strWriter));
        String trace = strWriter.toString();
        System.err.println(trace);
        context.setOutputValue("stackTrace", trace);
    }

    public static void dumpAttributeMap(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        if (comp != null) {
            Map map = comp.getAttributes();
            for (Map.Entry me : map.entrySet()) {
                System.out.println("key=" + me.getKey() + "'" + "value=" + me.getValue());
            }
        } else {
            System.out.println("UIComponent is null");
        }
    }

    public static void setEncoding(HandlerContext context) {
        String value = (String)context.getInputValue("value");
        FacesContext fctxt = context.getFacesContext();
        if (fctxt != null) {
            UIViewRoot root = fctxt.getViewRoot();
            Map<String, Serializable> map = PageSessionResolver.getPageSession(fctxt, root);
            if (map == null) {
                map = PageSessionResolver.createPageSession(fctxt, root);
            }
            map.put("com.sun.jsftemplating.ENCODING", (Serializable)((Object)value));
        }
    }

    public static void urlencode(HandlerContext context) {
        String value = (String)context.getInputValue("value");
        String encoding = (String)context.getInputValue("encoding");
        try {
            value = encoding == null ? URLEncoder.encode(value) : URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
        context.setOutputValue("result", value);
    }

    public static void responseComplete(HandlerContext context) {
        context.getFacesContext().responseComplete();
    }

    public static void renderResponse(HandlerContext context) {
        context.getFacesContext().renderResponse();
    }

    public static void getDate(HandlerContext context) {
        context.setOutputValue("time", new Date().getTime());
    }

    public static void htmlEscape(HandlerContext context) {
        String value = (String)context.getInputValue("value");
        value = Util.htmlEscape(value);
        context.setOutputValue("result", value);
    }
}

