/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.AMXGenericConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.amx.AMXConfigInfo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfiguredHelper {
    private final Class<? extends ConfigBeanProxy> mIntf;
    private final Configured mConfigured;
    private final AMXConfigInfo mAMXConfigInfo;
    private final Map<String, AttributeInfo> mAttributes = new HashMap<String, AttributeInfo>();
    private final Map<String, ElementInfo> mElements = new HashMap<String, ElementInfo>();
    private final Map<String, Method> mDuckTypedMethods = new HashMap<String, Method>();
    private final NameHint mNameHint;
    private final ConcurrentMap<String, String> mNameCache = new ConcurrentHashMap<String, String>();
    private static final String DEFAULT_NAME_HINT = "name";

    private static void debug(String s) {
        System.out.println(s);
    }

    public ConfiguredHelper(Class<? extends ConfigBeanProxy> intf) {
        this.mIntf = intf;
        this.mConfigured = intf.getAnnotation(Configured.class);
        if (this.mConfigured == null) {
            throw new IllegalArgumentException("ConfigBeanProxy is not an @Configured");
        }
        this.mAMXConfigInfo = intf.getAnnotation(AMXConfigInfo.class);
        this.findStuff();
        this.mNameHint = this.findNameHint();
    }

    public Info getInfo(String anyName) {
        Info info = null;
        String xmlName = this.findXMLName(anyName);
        if (xmlName != null && (info = (Info)this.mAttributes.get(xmlName)) == null) {
            info = this.mElements.get(xmlName);
        }
        return info;
    }

    public Class<? extends ConfigBeanProxy> getIntf() {
        return this.mIntf;
    }

    public String findXMLName(String anyName) {
        String temp;
        String xmlName = (String)this.mNameCache.get(anyName);
        if (xmlName != null) {
            return xmlName;
        }
        String canonical = anyName.toLowerCase().replace("-", "");
        for (AttributeInfo attributeInfo : this.mAttributes.values()) {
            if (attributeInfo.getName().equalsIgnoreCase(canonical)) {
                xmlName = attributeInfo.getXMLName();
                break;
            }
            temp = attributeInfo.getXMLName().replace("-", "");
            if (!canonical.equalsIgnoreCase(temp)) continue;
            xmlName = attributeInfo.getXMLName();
            break;
        }
        if (xmlName == null) {
            for (ElementInfo elementInfo : this.mElements.values()) {
                if (elementInfo.getName().equalsIgnoreCase(canonical)) {
                    xmlName = elementInfo.getXMLName();
                    break;
                }
                temp = elementInfo.getXMLName().replace("-", "");
                if (!canonical.equalsIgnoreCase(temp)) continue;
                xmlName = elementInfo.getXMLName();
                break;
            }
        }
        this.mNameCache.put(anyName, xmlName);
        return xmlName;
    }

    final Map<String, String> getDefaultValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (AttributeInfo info : this.mAttributes.values()) {
            String value = info.getAttribute().defaultValue();
            boolean isEmptyDefault = value.equals("\u0000");
            if (isEmptyDefault) continue;
            result.put(info.getXMLName(), "" + value);
        }
        return result;
    }

    public String getNameHint() {
        return this.mNameHint.mHint;
    }

    public boolean nameHintIsElement() {
        return this.mNameHint.mIsElement;
    }

    public AMXConfigInfo getAMXConfigInfo() {
        return this.mAMXConfigInfo;
    }

    public Class<? extends AMXConfig> getAMXInterface() {
        Class<? extends AMXConfig> amxIntf = null;
        AMXConfigInfo amxConfigInfo = this.getAMXConfigInfo();
        if (amxConfigInfo != null) {
            AMXConfigInfoResolver resolver = new AMXConfigInfoResolver(amxConfigInfo);
            try {
                amxIntf = resolver.amxInterface();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return amxIntf == null ? AMXGenericConfig.class : amxIntf;
    }

    public Set<String> getImpliedAMXNames() {
        return this.getNames();
    }

    public Set<String> getXMLNames() {
        HashSet<String> names = new HashSet<String>(this.mAttributes.keySet());
        names.addAll(this.mElements.keySet());
        return names;
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        for (AttributeInfo attributeInfo : this.mAttributes.values()) {
            names.add(attributeInfo.getName());
        }
        for (ElementInfo elementInfo : this.mElements.values()) {
            names.add(elementInfo.getName());
        }
        return names;
    }

    public Map<String, Method> getDuckTypedMethods() {
        return this.mDuckTypedMethods;
    }

    private void findStuff() {
        Method[] methods;
        for (Method m : methods = this.mIntf.getMethods()) {
            Info info;
            Element e = null;
            DuckTyped dt = null;
            Attribute a = m.getAnnotation(Attribute.class);
            if (a != null) {
                if (!JMXUtil.isIsOrGetter((Method)m)) continue;
                info = new AttributeInfo(JMXUtil.getAttributeName((Method)m), a);
                this.mAttributes.put(info.getXMLName(), (AttributeInfo)info);
                continue;
            }
            e = m.getAnnotation(Element.class);
            if (e != null) {
                if (!JMXUtil.isIsOrGetter((Method)m)) continue;
                info = new ElementInfo(JMXUtil.getAttributeName((Method)m), e, m.getReturnType());
                this.mElements.put(info.getXMLName(), (ElementInfo)info);
                continue;
            }
            dt = m.getAnnotation(DuckTyped.class);
            if (dt == null) continue;
            this.mDuckTypedMethods.put(m.getName(), m);
        }
    }

    private static String toXMLName(String name) {
        return name == null ? name : Dom.convertName((String)name);
    }

    private NameHint findNameHint() {
        String[] result = new String[]{null, null};
        if (this.mAMXConfigInfo != null && this.mAMXConfigInfo.singleton()) {
            return NameHint.NONE;
        }
        for (AttributeInfo attributeInfo : this.mAttributes.values()) {
            if (!attributeInfo.getAttribute().key()) continue;
            return new NameHint(attributeInfo.getName());
        }
        if (Named.class.isAssignableFrom(this.mIntf)) {
            return NameHint.NAME;
        }
        for (ElementInfo elementInfo : this.mElements.values()) {
            if (!elementInfo.getElement().key()) continue;
            return new NameHint(elementInfo.getName(), true);
        }
        if (this.mAttributes.get(DEFAULT_NAME_HINT) == null && this.mElements.get(DEFAULT_NAME_HINT) == null) {
            throw new IllegalArgumentException("No key value found and no Attribute or Element named 'name' for " + this.mIntf.getName());
        }
        return NameHint.NAME;
    }

    private static final class NameHint {
        public static final NameHint NAME = new NameHint("name");
        public static final NameHint NONE = new NameHint(null);
        private final String mHint;
        private final boolean mIsElement;

        public NameHint(String hint, boolean isElement) {
            this.mHint = ConfiguredHelper.toXMLName(hint);
            this.mIsElement = isElement;
        }

        public NameHint(String hint) {
            this(hint, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ElementInfo
    extends Info {
        private final Element elem;

        public ElementInfo(String getterName, Element e, Class<?> returnType) {
            super(getterName, e.value().length() != 0 ? e.value() : ConfiguredHelper.toXMLName(getterName), returnType);
            this.elem = e;
        }

        public Element getElement() {
            return this.elem;
        }
    }

    public static final class AttributeInfo
    extends Info {
        private final Attribute attr;

        public AttributeInfo(String getterName, Attribute a) {
            super(getterName, a.value().length() != 0 ? a.value() : ConfiguredHelper.toXMLName(getterName));
            this.attr = a;
        }

        public Attribute getAttribute() {
            return this.attr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info {
        private final String name;
        private final String xmlName;
        private final Class<?> returnType;

        public Info(String name, String xmlName) {
            this(name, xmlName, String.class);
        }

        public Info(String name, String xmlName, Class<?> returnType) {
            this.name = name;
            this.xmlName = xmlName;
            this.returnType = returnType;
        }

        public String getXMLName() {
            return this.xmlName;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public boolean isString() {
            return String.class == this.returnType;
        }
    }
}

