/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core.proxy;

import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class AMXBooter {
    public static final ObjectName AMX_BOOTER_OBJECT_NAME = JMXUtil.newObjectName("v3-support:name=booter-new");
    public static final String BOOT_AMX_OPERATION_NAME = "bootAMX";

    private AMXBooter() {
    }

    public static ObjectName bootAMX(MBeanServerConnection conn) {
        ObjectName domainRootObjectName = AMXBooter.findDomainRoot(conn);
        if (domainRootObjectName == null) {
            try {
                domainRootObjectName = (ObjectName)conn.invoke(AMX_BOOTER_OBJECT_NAME, BOOT_AMX_OPERATION_NAME, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return domainRootObjectName;
    }

    public static ObjectName findDomainRoot(MBeanServerConnection conn) {
        ObjectName objectName = null;
        ObjectName pattern = JMXUtil.newObjectName("v3:type=" + Util.deduceType(DomainRoot.class) + ",*");
        try {
            Set<ObjectName> objectNames = JMXUtil.queryNames(conn, pattern, null);
            if (objectNames.size() > 1) {
                throw new IllegalStateException("Found more than one DomainRoot using " + pattern);
            }
            if (objectNames.size() == 1) {
                objectName = SetUtil.getSingleton(objectNames);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }
}

