/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.admin.amx.util.DebugOutImpl;
import org.glassfish.admin.amx.util.FileOutput;
import org.glassfish.admin.amx.util.Output;
import org.glassfish.admin.amx.util.OutputIgnore;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;

public final class AMXDebug {
    private final ConcurrentMap<String, WrapOutput> mOutputs;
    private static final AMXDebug INSTANCE = new AMXDebug();
    private final File mDir;
    private boolean mMadeDebugDir;
    private boolean mDefaultDebug;
    private final boolean mAppend;
    public static final String AMX_DEBUG_ENABLED_SPROP = "AMX-DEBUG.enabled";
    public static final String AMX_DEBUG_APPEND_SPROP = "AMX-DEBUG.append";
    public static final String AMX_DEBUG_DIR_SPROP = "AMX-DEBUG.dir";
    public static final String AMX_DEBUG_SUBDIR = "AMX-DEBUG";
    public static final String AMX_DEBUG_SUFFIX = ".debug";
    private final WrapOutput mDebug;
    private final String NEWLINE;
    private final Set<Character> ILLEGAL_CHARS;
    private final char[] ILLEGAL_CHARS_ARRAY = new char[]{'\u0000', '?', '*', '|', '\'', '|', '\\', '/', ':'};
    private static final String DASHES = "----------";

    private AMXDebug() {
        this.ILLEGAL_CHARS = new HashSet<Character>();
        for (char c : this.ILLEGAL_CHARS_ARRAY) {
            this.ILLEGAL_CHARS.add(Character.valueOf(c));
        }
        this.NEWLINE = System.getProperty("line.separator");
        assert (this.NEWLINE != null);
        String value = System.getProperty(AMX_DEBUG_ENABLED_SPROP);
        if (value == null && (value = System.getProperty(AMX_DEBUG_SUBDIR)) != null && value.equals("")) {
            value = "true";
        }
        this.mDefaultDebug = value != null && Boolean.parseBoolean(value);
        value = System.getProperty(AMX_DEBUG_APPEND_SPROP);
        this.mAppend = value != null && Boolean.parseBoolean(value);
        this.mOutputs = new ConcurrentHashMap<String, WrapOutput>();
        this.mDir = this.getDir();
        this.mMadeDebugDir = false;
        if (this.mDefaultDebug) {
            this.makeDebugDir();
        }
        this.mDebug = this._getOutput(this.getClass().getName());
        this.mark(this.mDebug, this.getStdMarker("AMXDebug started "));
        this.mDebug.println("*** System Properties ***");
        this.dumpSystemProps(this.mDebug);
        this.mark(this.mDebug, this.getStdMarker("AMXDebug initialization done"));
    }

    private void dumpSystemProps(Output output) {
        Properties props = System.getProperties();
        Object[] keys = props.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            this.debug((String)key + "=" + props.getProperty((String)key));
        }
    }

    private void makeDebugDir() {
        if (!this.mMadeDebugDir) {
            this.mDir.mkdirs();
            this.mMadeDebugDir = true;
        }
    }

    private void debug(String s) {
        if (this.mDefaultDebug && this.mDebug != null) {
            this.mDebug.println("" + s);
        }
    }

    private static String parens(String s) {
        return "(" + s + ")";
    }

    private File getDir() {
        String value = System.getProperty(AMX_DEBUG_DIR_SPROP);
        File debugDir = null;
        if (value == null) {
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            File parentDir = null;
            parentDir = instanceRoot != null ? new File(instanceRoot) : new File(System.getProperty("user.home"));
            debugDir = new File(parentDir, AMX_DEBUG_SUBDIR);
        } else {
            debugDir = new File(value);
        }
        return debugDir;
    }

    public String[] getOutputIDs() {
        return SetUtil.toStringArray(this.mOutputs.keySet());
    }

    public boolean getDefaultDebug() {
        return this.mDefaultDebug;
    }

    public void setDefaultDebug(boolean debug) {
        this.mDefaultDebug = debug;
        if (this.mDefaultDebug) {
            this.makeDebugDir();
        }
        this.mDebug.setDebug(debug);
        this.debug("setDefaultDebug" + AMXDebug.parens("" + debug));
    }

    public boolean getDebug(String id) {
        return this._getOutput(id).getDebug();
    }

    public void setDebug(String id, boolean debug) {
        if (debug) {
            this.makeDebugDir();
        }
        this._getOutput(id).setDebug(debug);
        this.debug("setDebug" + AMXDebug.parens(id + ", " + debug));
    }

    public void setAll(boolean debug) {
        this.debug("setAll" + AMXDebug.parens("" + debug));
        this.setDefaultDebug(debug);
        for (WrapOutput w : this.mOutputs.values()) {
            w.setDebug(debug);
        }
    }

    public void cleanup() {
        this.debug("cleanup()");
        this.setDefaultDebug(false);
        this.setAll(false);
    }

    public void reset(String id) {
        this.debug("reset" + AMXDebug.parens(id));
        this._getOutput(id).reset();
    }

    public String getStdMarker() {
        return this.getStdMarker("");
    }

    public String getStdMarker(String msg) {
        return this.NEWLINE + this.NEWLINE + DASHES + " " + new Date() + " " + msg + DASHES + this.NEWLINE;
    }

    public void mark(Output output, String marker) {
        output.println(marker == null ? this.getStdMarker() : marker);
    }

    public void mark(String id, String marker) {
        this.mark(this.getOutput(id), marker);
    }

    public void mark(String id) {
        this.mark(id, null);
    }

    public void markAll(String marker) {
        for (WrapOutput w : this.mOutputs.values()) {
            if (!w.getDebug()) continue;
            this.mark(w, marker);
        }
    }

    public void markAll() {
        this.markAll(null);
    }

    public static AMXDebug getInstance() {
        return INSTANCE;
    }

    public File getOutputFile(String id) {
        String filename = this.makeSafeForFile(id) + AMX_DEBUG_SUFFIX;
        return new File(this.mDir, filename);
    }

    private WrapOutput _getOutput(String id) {
        WrapOutput output = (WrapOutput)this.mOutputs.get(id);
        if (output == null) {
            output = new WrapOutput(this.getOutputFile(id), this.mDefaultDebug);
            WrapOutput prev = this.mOutputs.putIfAbsent(id, output);
            if (prev != null) {
                output = prev;
            } else {
                this.debug("AMXDebug: Created output for " + StringUtil.quote(id));
            }
        }
        return output;
    }

    public Output getShared() {
        return this.getOutput("AMXDebug-Shared");
    }

    public Output getOutput(String id) {
        return this._getOutput(id);
    }

    private String makeSafeForFile(String id) {
        char[] chars;
        if (id == null) {
            throw new IllegalArgumentException(id);
        }
        StringBuilder s = new StringBuilder();
        for (char c : chars = id.toCharArray()) {
            if (this.ILLEGAL_CHARS.contains(Character.valueOf(c))) {
                s.append("_");
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    public static String methodString(String name, Object ... args) {
        return DebugOutImpl.methodString(name, args);
    }

    public final class WrapOutput
    implements Output {
        private volatile Output mWrapped;
        private final File mFile;
        private Output mFileOutput;
        private volatile boolean mDebug;

        private WrapOutput(File file, boolean debug) {
            this.mDebug = debug;
            this.mWrapped = OutputIgnore.INSTANCE;
            this.mFile = file;
            this.mFileOutput = new FileOutput(file, AMXDebug.this.mAppend);
            this.checkStatus();
        }

        public boolean getDebug() {
            return this.mDebug;
        }

        public void setDebug(boolean debug) {
            this.mDebug = debug;
            this.checkStatus();
        }

        public void print(Object o) {
            this.mWrapped.print(o);
        }

        public void println(Object o) {
            this.mWrapped.println(o);
        }

        public void printError(Object o) {
            this.mWrapped.printError(o);
        }

        public void printDebug(Object o) {
            this.mWrapped.printDebug(o);
        }

        public synchronized void reset() {
            this.mWrapped = OutputIgnore.INSTANCE;
            this.mFileOutput.close();
            this.mFileOutput = new FileOutput(this.mFile);
            this.checkStatus();
        }

        public void close() {
            this.reset();
        }

        private synchronized void checkStatus() {
            if (this.getDebug()) {
                this.mWrapped = this.mFileOutput;
            } else {
                this.mWrapped.println("turning DEBUG OFF");
                this.mWrapped = OutputIgnore.INSTANCE;
            }
        }
    }
}

