/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Context;
import com.sun.grizzly.arp.AsyncProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncOutputBuffer;
import com.sun.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncStream;
import com.sun.grizzly.ssl.SSLProcessorTask;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.SSLSupport;
import java.io.InputStream;

public class SSLAsyncProtocolFilter
extends AsyncProtocolFilter {
    protected SSLImplementation sslImplementation;

    public SSLAsyncProtocolFilter(Class algorithmClass, int port, SSLImplementation sslImplementation) {
        super(algorithmClass, port);
        this.sslImplementation = sslImplementation;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, Interceptor handler, InputStream inputStream) {
        super.configureProcessorTask(processorTask, context, handler, inputStream);
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        SSLSupport sslSupport = this.sslImplementation.getSSLSupport(workerThread.getSSLEngine());
        ((SSLProcessorTask)processorTask).setSSLSupport(sslSupport);
        SSLAsyncOutputBuffer outputBuffer = ((SSLAsyncProcessorTask)processorTask).getSSLAsyncOutputBuffer();
        outputBuffer.setSSLEngine(workerThread.getSSLEngine());
        outputBuffer.setOutputBB(workerThread.getOutputBB());
    }

    protected InputReader createInputReader() {
        return new SSLAsyncStream(ByteBufferFactory.allocateView((int)this.bbSize, (boolean)false));
    }

    protected void configureInputBuffer(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        ((SSLAsyncStream)inputStream).setSslEngine(workerThread.getSSLEngine());
        ((SSLAsyncStream)inputStream).setInputBB(workerThread.getInputBB());
        inputStream.setSelectionKey(context.getSelectionKey());
    }

    protected boolean isSecure() {
        return true;
    }
}

