/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-sub-components")
@I18n(value="list.sub.components")
@Scoped(value=PerLookup.class)
public class ListSubComponentsCommand
implements AdminCommand {
    @Param(primary=true)
    private String appName = null;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    public Deployment deployment;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSubComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        if (!this.deployment.isRegistered(this.appName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Named module = ConfigBeansUtilities.getModule((String)this.appName);
        com.sun.enterprise.config.serverbeans.Application application = null;
        if (module instanceof com.sun.enterprise.config.serverbeans.Application) {
            application = (com.sun.enterprise.config.serverbeans.Application)module;
        }
        ApplicationInfo appInfo = this.appRegistry.get(this.appName);
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (Boolean.valueOf(application.getDeployProperties().getProperty("isComposite")).booleanValue()) {
            for (String modInfo : this.getSubModulesForEar(app)) {
                ActionReport.MessagePart childPart = part.addChild();
                childPart.setMessage(modInfo);
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List<String> getSubModulesForEar(Application application) {
        ArrayList<String> moduleInfoList = new ArrayList<String>();
        for (ModuleDescriptor moduleDesc : application.getModules()) {
            String moduleInfo = moduleDesc.getArchiveUri() + ":" + moduleDesc.getModuleType();
            if (moduleDesc.getModuleType().equals((Object)XModuleType.WAR)) {
                moduleInfo = moduleInfo + ":" + moduleDesc.getContextRoot();
            }
            moduleInfoList.add(moduleInfo);
        }
        return moduleInfoList;
    }
}

