/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;

public abstract class GenericHandler
implements ArchiveHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            BufferedInputStream is = new BufferedInputStream(source.getEntry(entryName));
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    public String getDefaultApplicationName(ReadableArchive archive) {
        String appName = archive.getName();
        int lastDot = appName.lastIndexOf(46);
        if (lastDot != -1 && appName.substring(lastDot).equalsIgnoreCase("." + this.getArchiveType())) {
            appName = appName.substring(0, lastDot);
        }
        return appName;
    }

    public Manifest getManifest(ReadableArchive archive) throws IOException {
        return archive.getManifest();
    }
}

