/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.AsadminMain;
import com.sun.enterprise.admin.cli.optional.S1ASCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class StreamCommandRunner
extends S1ASCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        super.validateOptions();
        String fname = super.getOption("file");
        BufferedReader reader = null;
        try {
            if (fname == null) {
                if (System.console() == null) {
                    throw new CommandException("To use this command, either provide correct file name, or be connected to terminal");
                }
                System.out.println("Enter commands one per \"line\", ^D to quit");
                reader = new BufferedReader(new InputStreamReader(System.in));
            } else {
                File file = new File(fname);
                if (!file.canRead()) {
                    throw new CommandException("File: " + fname + " can not be read");
                }
                reader = new BufferedReader(new FileReader(file));
            }
            this.executeCommands(reader);
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    private void executeCommands(BufferedReader reader) throws CommandException, IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] args = this.getArgs(line);
            this.execute(args);
        }
    }

    private String[] getArgs(String line) {
        String regex = "\\s";
        String[] parts = line.split(regex);
        return parts;
    }

    private void execute(String[] args) throws CommandException {
        AsadminMain main = new AsadminMain();
        try {
            int code = main.local(args);
            System.out.println("Ran: " + Arrays.toString(args) + " locally");
        }
        catch (Exception e) {
            try {
                int code = main.remote(args);
                System.out.println("Ran: " + Arrays.toString(args) + " remotely");
            }
            catch (Exception ee) {
                System.out.println("Error executing command: " + Arrays.toString(args) + " " + ee.getMessage());
            }
        }
    }
}

