/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.GuiUtil;

public class VirtualServerHandlers {
    private static final String PROP_IS_COMPOSITE = "isComposite";
    private static List vsSkipPropsList = new ArrayList();

    public static void getVirtualServerList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ArrayList result = new ArrayList();
        try {
            boolean hasOrig;
            if (config == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            Iterator iter = null;
            iter = config.getHTTPServiceConfig().getVirtualServerConfigMap().values().iterator();
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean bl = hasOrig = selectedList != null && selectedList.size() != 0;
            if (iter != null) {
                while (iter.hasNext()) {
                    ConfigElement configE = (ConfigElement)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String name = configE.getName();
                    oneRow.put("name", name);
                    oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, (List)selectedList) : false);
                    String state = ((VirtualServerConfig)configE).getState();
                    String host = ((VirtualServerConfig)configE).getHosts();
                    oneRow.put("state", state == null ? " " : state);
                    oneRow.put("host", host == null ? " " : host);
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getVirtualServerSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                VirtualServerHandlers.getDefaultVirtualServerAttributes(handlerCtx, config);
                return;
            }
            Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
            VirtualServerConfig vs = (VirtualServerConfig)vservers.get((String)handlerCtx.getInputValue("Name"));
            handlerCtx.setOutputValue("Hosts", (Object)vs.getHosts());
            handlerCtx.setOutputValue("StateOption", (Object)vs.getState());
            handlerCtx.setOutputValue("Http", (Object)vs.getHTTPListeners());
            handlerCtx.setOutputValue("Web", (Object)vs.getDefaultWebModule());
            handlerCtx.setOutputValue("LogFile", (Object)vs.getLogFile());
            Map aMap = AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)vs, (List)vsSkipPropsList);
            handlerCtx.setOutputValue("Properties", (Object)aMap);
            handlerCtx.setOutputValue("accessLogBufferSize", (Object)AMXUtil.getPropertyValue((PropertiesAccess)vs, (String)"accessLogBufferSize"));
            handlerCtx.setOutputValue("accessLogWriteInterval", (Object)AMXUtil.getPropertyValue((PropertiesAccess)vs, (String)"accessLogWriteInterval"));
            handlerCtx.setOutputValue("accesslog", (Object)AMXUtil.getPropertyValue((PropertiesAccess)vs, (String)"accesslog"));
            handlerCtx.setOutputValue("docroot", (Object)AMXUtil.getPropertyValue((PropertiesAccess)vs, (String)"docroot"));
            String sso = vs.getSsoEnabled();
            Boolean ssoFlag = false;
            ssoFlag = GuiUtil.isEmpty((String)sso) ? Boolean.valueOf(false) : Boolean.valueOf(sso.equals("true"));
            handlerCtx.setOutputValue("sso", (Object)ssoFlag);
            String accessLoggingFlag = AMXUtil.getPropertyValue((PropertiesAccess)vs, (String)"accessLoggingEnabled");
            if (GuiUtil.isEmpty((String)accessLoggingFlag)) {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"off");
            } else if ("true".equals(accessLoggingFlag)) {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"true");
            } else {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"false");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static void getDefaultVirtualServerAttributes(HandlerContext handlerCtx, ConfigConfig config) {
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-VirtualServerConfig", true);
        handlerCtx.setOutputValue("Hosts", defaultMap.get("Hosts"));
        handlerCtx.setOutputValue("StateOption", defaultMap.get("State"));
        handlerCtx.setOutputValue("LogFile", defaultMap.get("LogFile"));
        handlerCtx.setOutputValue("sso", (Object)Boolean.FALSE);
        handlerCtx.setOutputValue("docroot", defaultMap.get("DocRoot"));
        handlerCtx.setOutputValue("accesslog", (Object)"${com.sun.aas.instanceRoot}/logs/access");
        handlerCtx.setOutputValue("sso", (Object)Boolean.FALSE);
        handlerCtx.setOutputValue("accessLoggingFlag", (Object)"off");
        handlerCtx.setOutputValue("Properties", new HashMap());
    }

    public static void saveVirtualServerSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map convertedMap = AMXUtil.convertToPropertiesOptionMap((Map)newProps, null);
                AMXUtil.putOptionalValue((String)((String)handlerCtx.getInputValue("accessLogBufferSize")), (Map)convertedMap, (String)"accessLogBufferSize");
                AMXUtil.putOptionalValue((String)((String)handlerCtx.getInputValue("accessLogWriteInterval")), (Map)convertedMap, (String)"accessLogWriteInterval");
                convertedMap.put("http-listeners", handlerCtx.getInputValue("Http"));
                convertedMap.put("default-web-module", handlerCtx.getInputValue("Web"));
                convertedMap.put("log-file", handlerCtx.getInputValue("LogFile"));
                convertedMap.put("State", handlerCtx.getInputValue("StateOption"));
                Boolean sso = (Boolean)handlerCtx.getInputValue("sso");
                convertedMap.put("sso-enabled", sso == null ? "false" : sso.toString());
                VirtualServerConfig server = config.getHTTPServiceConfig().createVirtualServerConfig((String)handlerCtx.getInputValue("Name"), (String)handlerCtx.getInputValue("Hosts"), convertedMap);
            }
            Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
            VirtualServerConfig vs = (VirtualServerConfig)vservers.get((String)handlerCtx.getInputValue("Name"));
            AMXUtil.updateProperties((PropertiesAccess)vs, (Map)newProps, (List)vsSkipPropsList);
            vs.setHosts((String)handlerCtx.getInputValue("Hosts"));
            vs.setState((String)handlerCtx.getInputValue("StateOption"));
            vs.setHTTPListeners((String)handlerCtx.getInputValue("Http"));
            vs.setDefaultWebModule((String)handlerCtx.getInputValue("Web"));
            vs.setLogFile((String)handlerCtx.getInputValue("LogFile"));
            Boolean sso = (Boolean)handlerCtx.getInputValue("sso");
            vs.setSsoEnabled(sso == null ? "false" : sso.toString());
            AMXUtil.setPropertyValue((PropertiesAccess)vs, (String)"accesslog", (String)((String)handlerCtx.getInputValue("accesslog")));
            AMXUtil.setPropertyValue((PropertiesAccess)vs, (String)"accessLogBufferSize", (String)((String)handlerCtx.getInputValue("accessLogBufferSize")));
            AMXUtil.setPropertyValue((PropertiesAccess)vs, (String)"accessLogWriteInterval", (String)((String)handlerCtx.getInputValue("accessLogWriteInterval")));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void deleteConfig(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String type = (String)handlerCtx.getInputValue("Type");
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String[] types;
                Object[] params;
                String name = (String)oneRow.get("name");
                if ("virtualServer".equals(type)) {
                    config.getHTTPServiceConfig().removeVirtualServerConfig(name);
                    continue;
                }
                if ("jmsHost".equals(type)) {
                    params = new Object[]{name, configName};
                    types = new String[]{"java.lang.String", "java.lang.String"};
                    continue;
                }
                if ("realm".equals(type)) {
                    config.getSecurityServiceConfig().removeAuthRealmConfig(name);
                    continue;
                }
                if ("jacc".equals(type)) {
                    config.getSecurityServiceConfig().removeJACCProviderConfig(name);
                    continue;
                }
                if ("audit".equals(type)) {
                    config.getSecurityServiceConfig().removeAuditModuleConfig(name);
                    continue;
                }
                if (!"jmsPhysicalDestination".equals(type)) continue;
                params = new Object[]{name, (String)oneRow.get("type"), (String)handlerCtx.getInputValue("ConfigName")};
                types = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getModulesByType(HandlerContext handlerCtx) {
        Map appsConfig = AMXRoot.getInstance().getApplicationsConfig().getApplicationConfigMap();
        String type = (String)handlerCtx.getInputValue("type");
        ArrayList<String> result = new ArrayList<String>();
        result.add("");
        List webModules = AppUtil.getAllModules((String)type, result);
        handlerCtx.setOutputValue("modules", (Object)webModules);
    }

    static {
        vsSkipPropsList.add("accessLogBufferSize");
        vsSkipPropsList.add("accessLogWriteInterval");
        vsSkipPropsList.add("accessLoggingEnabled");
    }
}

