/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public abstract class FieldsLockingPolicy
implements OptimisticLockingPolicy {
    protected ClassDescriptor descriptor;
    protected Vector allNonPrimaryKeyFields;

    public void addLockFieldsToUpdateRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
    }

    public abstract void addLockValuesToTranslationRow(ObjectLevelModifyQuery var1);

    protected Vector buildAllNonPrimaryKeyFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        Enumeration<DatabaseField> enumeration = this.descriptor.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (this.isPrimaryKey(databaseField)) continue;
            if (this.descriptor.hasInheritance()) {
                DatabaseField databaseField2 = this.descriptor.getInheritancePolicy().getClassIndicatorField();
                if (databaseField2 == null || databaseField.equals(databaseField2)) continue;
                vector.addElement(databaseField);
                continue;
            }
            vector.addElement(databaseField);
        }
        return vector;
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, Expression expression, AbstractRecord abstractRecord) {
        return expression.and(this.buildExpression(databaseTable, abstractRecord, null, expression.getBuilder()));
    }

    protected Expression buildExpression(DatabaseTable databaseTable, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, ExpressionBuilder expressionBuilder) {
        DatabaseField databaseField;
        Expression expression = null;
        Enumeration enumeration = this.getFieldsToCompare(databaseTable, abstractRecord, abstractRecord2).elements();
        if (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            expression = expressionBuilder.getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
        }
        while (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            expression = expression.and(expressionBuilder.getField(databaseField).equal(expressionBuilder.getParameter(databaseField)));
        }
        return expression;
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, Expression expression, AbstractRecord abstractRecord, AbstractRecord abstractRecord2) {
        return expression.and(this.buildExpression(databaseTable, abstractRecord, abstractRecord2, expression.getBuilder()));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean supportsWriteLockValuesComparison() {
        return false;
    }

    public int compareWriteLockValues(Object object, Object object2) {
        return -1;
    }

    protected Vector getAllNonPrimaryKeyFields() {
        if (this.allNonPrimaryKeyFields == null) {
            this.allNonPrimaryKeyFields = this.buildAllNonPrimaryKeyFields();
        }
        return this.allNonPrimaryKeyFields;
    }

    protected Vector getAllNonPrimaryKeyFields(DatabaseTable databaseTable) {
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        Enumeration enumeration = this.getAllNonPrimaryKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseTable.getName())) continue;
            vector.addElement(databaseField);
        }
        return vector;
    }

    public Object getBaseValue() {
        return null;
    }

    protected abstract Vector getFieldsToCompare(DatabaseTable var1, AbstractRecord var2, AbstractRecord var3);

    public DatabaseField getWriteLockField() {
        return null;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder, AbstractSession abstractSession) {
        return null;
    }

    public Object getValueToPutInCache(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        return -1;
    }

    public Object getWriteLockValue(Object object, Vector vector, AbstractSession abstractSession) {
        return null;
    }

    public void initialize(AbstractSession abstractSession) {
    }

    public void initializeProperties() {
    }

    public boolean isStoredInCache() {
        return false;
    }

    public boolean isCascaded() {
        return false;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession abstractSession, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        return true;
    }

    public boolean isNewerVersion(AbstractRecord abstractRecord, Object object, Vector vector, AbstractSession abstractSession) {
        return true;
    }

    protected boolean isPrimaryKey(DatabaseField databaseField) {
        if (this.descriptor.getPrimaryKeyFields().contains(databaseField)) {
            return true;
        }
        if (this.descriptor.isMultipleTableDescriptor()) {
            Iterator<Map<DatabaseField, DatabaseField>> iterator = this.descriptor.getAdditionalTablePrimaryKeyFields().values().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().containsKey(databaseField)) continue;
                return true;
            }
        }
        return false;
    }

    public void mergeIntoParentCache(UnitOfWorkImpl unitOfWorkImpl, Vector vector, Object object) {
    }

    protected void setAllNonPrimaryKeyFields(Vector vector) {
        this.allNonPrimaryKeyFields = vector;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
    }

    public void validateDelete(int n, Object object, DeleteObjectQuery deleteObjectQuery) {
        if (n <= 0) {
            deleteObjectQuery.getSession().getParentIdentityMapSession(deleteObjectQuery, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, deleteObjectQuery);
        }
    }

    public void validateUpdate(int n, Object object, WriteObjectQuery writeObjectQuery) {
        if (n <= 0) {
            writeObjectQuery.getSession().getParentIdentityMapSession(writeObjectQuery, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, writeObjectQuery);
        }
    }

    protected void verifyUsage(AbstractSession abstractSession) {
        if (!abstractSession.isUnitOfWork()) {
            throw ValidationException.fieldLevelLockingNotSupportedWithoutUnitOfWork();
        }
    }
}

