/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class ReturningPolicy
implements Serializable,
Cloneable {
    protected static final int INSERT = 0;
    protected static final int UPDATE = 1;
    protected static final int NUM_OPERATIONS = 2;
    protected static final int RETURN_ONLY = 0;
    protected static final int WRITE_RETURN = 1;
    protected static final int MAPPED = 2;
    protected static final int UNMAPPED = 3;
    protected static final int ALL = 4;
    protected static final int MAIN_SIZE = 5;
    protected ClassDescriptor descriptor;
    protected Vector infos = NonSynchronizedVector.newInstance();
    protected Collection[][] main;
    protected HashMap[] tableToVectorOfFieldsForGenerationMap;
    protected boolean isUsedToSetPrimaryKey;
    protected Map fieldsNotFromDescriptor_DefaultTable;
    protected Map fieldsNotFromDescriptor_OtherTables;

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void fieldIsNotFromDescriptor(DatabaseField databaseField) {
        if (databaseField.getTable().equals(this.getDescriptor().getDefaultTable())) {
            if (this.fieldsNotFromDescriptor_DefaultTable == null) {
                this.fieldsNotFromDescriptor_DefaultTable = new HashMap();
            }
            this.fieldsNotFromDescriptor_DefaultTable.put(databaseField, databaseField);
        } else {
            if (this.fieldsNotFromDescriptor_OtherTables == null) {
                this.fieldsNotFromDescriptor_OtherTables = new HashMap();
            }
            this.fieldsNotFromDescriptor_OtherTables.put(databaseField, databaseField);
        }
    }

    public Vector getFieldsToGenerateInsert(DatabaseTable databaseTable) {
        return this.getVectorOfFieldsToGenerate(0, databaseTable);
    }

    public Vector getFieldsToGenerateUpdate(DatabaseTable databaseTable) {
        return this.getVectorOfFieldsToGenerate(1, databaseTable);
    }

    public Vector getFieldInfos() {
        return this.infos;
    }

    public void setFieldInfos(Vector vector) {
        this.infos = vector;
    }

    public boolean hasEqualFieldInfos(ReturningPolicy returningPolicy) {
        return this.hasEqualFieldInfos(returningPolicy.getFieldInfos());
    }

    public boolean hasEqualFieldInfos(Vector vector) {
        return ReturningPolicy.areCollectionsEqualAsSets(this.getFieldInfos(), vector);
    }

    public static boolean areCollectionsEqualAsSets(Collection collection, Collection collection2) {
        if (collection == collection2) {
            return true;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(collection);
        ArrayList arrayList2 = new ArrayList(collection2);
        for (Object e : arrayList) {
            arrayList2.remove(e);
        }
        return arrayList2.isEmpty();
    }

    protected Vector getVectorOfFieldsToGenerate(int n, DatabaseTable databaseTable) {
        Vector<DatabaseField> vector;
        if (this.main[n][4] == null) {
            return null;
        }
        if (this.tableToVectorOfFieldsForGenerationMap == null) {
            this.tableToVectorOfFieldsForGenerationMap = new HashMap[2];
        }
        if (this.tableToVectorOfFieldsForGenerationMap[n] == null) {
            this.tableToVectorOfFieldsForGenerationMap[n] = new HashMap();
        }
        if ((vector = (Vector<DatabaseField>)this.tableToVectorOfFieldsForGenerationMap[n].get(databaseTable)) == null) {
            vector = new Vector<DatabaseField>();
            for (DatabaseField databaseField : this.main[n][4]) {
                if (!databaseField.getTable().equals(databaseTable)) continue;
                vector.add(databaseField);
            }
            this.tableToVectorOfFieldsForGenerationMap[n].put(databaseTable, vector);
        }
        return vector;
    }

    public Collection getFieldsToMergeInsert() {
        return this.main[0][2];
    }

    public Collection getFieldsToMergeUpdate() {
        return this.main[1][2];
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void addFieldForInsert(String string) {
        this.addFieldForInsert(string, null);
    }

    public void addFieldForInsert(String string, Class clazz) {
        this.addFieldForInsert(this.createField(string, clazz));
    }

    public void addFieldForInsert(DatabaseField databaseField) {
        this.addField(databaseField, true, false, false);
    }

    public void addFieldForInsertReturnOnly(String string) {
        this.addFieldForInsertReturnOnly(string, null);
    }

    public void addFieldForInsertReturnOnly(String string, Class clazz) {
        this.addFieldForInsertReturnOnly(this.createField(string, clazz));
    }

    public void addFieldForInsertReturnOnly(DatabaseField databaseField) {
        this.addField(databaseField, true, true, false);
    }

    public void addFieldForUpdate(String string) {
        this.addFieldForUpdate(string, null);
    }

    public void addFieldForUpdate(String string, Class clazz) {
        this.addFieldForUpdate(this.createField(string, clazz));
    }

    public void addFieldForUpdate(DatabaseField databaseField) {
        this.addField(databaseField, false, false, true);
    }

    protected void addField(DatabaseField databaseField, boolean bl, boolean bl2, boolean bl3) {
        this.getFieldInfos().addElement(new Info(databaseField, bl, bl2, bl3));
    }

    static Info mergeInfos(Info info, Info info2, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        boolean bl = true;
        DatabaseField databaseField = info.getField();
        if (info2.getField().getType() != null) {
            if (info.getField().getType() == null) {
                databaseField = info2.field;
            } else if (!info.getField().getType().equals(info2.getField().getType())) {
                abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldTypeConflict(info.getField().getName(), info.getField().getType().getName(), info2.getField().getType().getName(), classDescriptor));
                bl = false;
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (info.isInsert() && !info2.isInsert()) {
            bl2 = true;
            bl3 = info.isInsertModeReturnOnly();
        } else if (!info.isInsert() && info2.isInsert()) {
            bl2 = true;
            bl3 = info2.isInsertModeReturnOnly();
        } else if (info.isInsert() && info2.isInsert()) {
            bl2 = true;
            bl3 = info.isInsertModeReturnOnly();
            if (info.isInsertModeReturnOnly() != info2.isInsertModeReturnOnly()) {
                abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldInsertConflict(info.getField().getName(), classDescriptor));
                bl = false;
            }
        }
        if (bl) {
            boolean bl4 = info.isUpdate() || info2.isUpdate();
            return new Info(databaseField, bl2, bl3, bl4);
        }
        return null;
    }

    protected static boolean isThereATypeConflict(DatabaseField databaseField, DatabaseField databaseField2) {
        return databaseField.getType() != null && databaseField2.getType() != null && !databaseField.getType().equals(databaseField2.getType());
    }

    protected DatabaseField createField(String string, Class clazz) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(clazz);
        return databaseField;
    }

    protected Collection createCollection() {
        return new HashSet();
    }

    protected void addFieldToMain(int n, int n2, DatabaseField databaseField) {
        if (this.main[n][n2] == null) {
            this.main[n][n2] = this.createCollection();
        }
        this.main[n][n2].add(databaseField);
    }

    protected void addCollectionToMain(int n, int n2, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.main[n][n2] == null) {
            this.main[n][n2] = this.createCollection();
        }
        this.main[n][n2].addAll(collection);
    }

    protected void addMappedFieldToMain(DatabaseField databaseField, Info info) {
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                if (!info.is(i, j)) continue;
                this.addFieldToMain(i, j, databaseField);
                this.addFieldToMain(i, 2, databaseField);
                this.addFieldToMain(i, 4, databaseField);
            }
        }
    }

    protected void addUnmappedFieldToMain(DatabaseField databaseField, Info info) {
        for (int i = 0; i <= 1; ++i) {
            if (!info.is(i)) continue;
            this.addFieldToMain(i, 3, databaseField);
            this.addFieldToMain(i, 4, databaseField);
        }
    }

    protected Hashtable removeDuplicateAndValidateInfos(AbstractSession abstractSession) {
        Hashtable<DatabaseField, Info> hashtable = new Hashtable<DatabaseField, Info>();
        for (int i = 0; i < this.infos.size(); ++i) {
            Info info = (Info)this.infos.elementAt(i);
            info = (Info)info.clone();
            DatabaseField databaseField = this.getDescriptor().buildField(info.getField());
            if (info.getField().getType() == null) {
                info.setField(databaseField);
            } else {
                info.getField().setName(databaseField.getName());
                info.getField().setTableName(this.getDescriptor().getDefaultTable().getQualifiedName());
            }
            Info info2 = (Info)hashtable.get(info.getField());
            if (info2 == null) {
                hashtable.put(info.getField(), info);
                continue;
            }
            Info info3 = ReturningPolicy.mergeInfos(info, info2, abstractSession, this.getDescriptor());
            if (info3 != null) {
                hashtable.put(info3.getField(), info3);
                continue;
            }
            hashtable.put(info.getField(), info);
        }
        return hashtable;
    }

    public void initialize(AbstractSession abstractSession) {
        Cloneable cloneable;
        this.clearInitialization();
        this.main = new Collection[2][5];
        if (this.getDescriptor().isChildDescriptor() && ((ClassDescriptor)(cloneable = this.getDescriptor().getInheritancePolicy().getParentDescriptor())).hasReturningPolicy()) {
            this.copyMainFrom(((ClassDescriptor)cloneable).getReturningPolicy());
        }
        if (!this.infos.isEmpty()) {
            Info info;
            DatabaseField databaseField;
            cloneable = this.removeDuplicateAndValidateInfos(abstractSession);
            Hashtable hashtable = (Hashtable)((Hashtable)cloneable).clone();
            Enumeration<DatabaseField> enumeration = this.getDescriptor().getFields().elements();
            while (enumeration.hasMoreElements()) {
                databaseField = enumeration.nextElement();
                info = (Info)hashtable.get(databaseField);
                if (info == null) continue;
                hashtable.remove(databaseField);
                if (!this.verifyFieldAndMapping(abstractSession, databaseField)) continue;
                if (info.getField().getType() == null) {
                    this.addMappedFieldToMain(databaseField, info);
                    continue;
                }
                this.addMappedFieldToMain(info.getField(), info);
                this.fieldIsNotFromDescriptor(info.getField());
            }
            if (!hashtable.isEmpty()) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    databaseField = enumeration.nextElement();
                    info = (Info)hashtable.get(databaseField);
                    if (!ReturningPolicy.verifyField(abstractSession, databaseField, this.getDescriptor())) continue;
                    if (databaseField.getType() != null) {
                        this.addUnmappedFieldToMain(databaseField, info);
                        this.fieldIsNotFromDescriptor(databaseField);
                        abstractSession.log(1, "query", "added_unmapped_field_to_returning_policy", info.toString(), this.getDescriptor().getJavaClassName());
                        continue;
                    }
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyUnmappedFieldTypeNotSet(databaseField.getName(), this.getDescriptor()));
                }
            }
        }
        this.initializeIsUsedToSetPrimaryKey();
    }

    protected void copyMainFrom(ReturningPolicy returningPolicy) {
        Collection[][] collectionArray = returningPolicy.main;
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.addCollectionToMain(i, j, collectionArray[i][j]);
            }
        }
    }

    public boolean hasEqualMains(ReturningPolicy returningPolicy) {
        int n;
        Collection[][] collectionArray = returningPolicy.main;
        if (this.main == collectionArray) {
            return true;
        }
        for (int i = 0; i <= 1; ++i) {
            for (n = 0; n < 5; ++n) {
                if (this.main[i][n] == null && collectionArray[i][n] != null) {
                    return false;
                }
                if (this.main[i][n] != null && collectionArray[i][n] == null) {
                    return false;
                }
                if (((Object)this.main[i][n]).equals(collectionArray[i][n])) continue;
                return false;
            }
        }
        Hashtable<DatabaseField, DatabaseField> hashtable = new Hashtable<DatabaseField, DatabaseField>();
        for (n = 0; n <= 1; ++n) {
            if (this.main[n][4] == null) continue;
            for (DatabaseField databaseField : this.main[n][4]) {
                hashtable.put(databaseField, databaseField);
            }
        }
        for (n = 0; n <= 1; ++n) {
            if (collectionArray[n][4] == null) continue;
            for (DatabaseField databaseField : collectionArray[n][4]) {
                DatabaseField databaseField2 = (DatabaseField)hashtable.get(databaseField);
                if (databaseField2.getType().equals(databaseField.getType())) continue;
                return false;
            }
        }
        return true;
    }

    public void trimModifyRowForInsert(AbstractRecord abstractRecord) {
        this.trimModifyRow(abstractRecord, 0);
    }

    protected void trimModifyRow(AbstractRecord abstractRecord, int n) {
        if (abstractRecord == null || abstractRecord.isEmpty()) {
            return;
        }
        Collection collection = this.main[n][0];
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (int i = abstractRecord.size() - 1; i >= 0; --i) {
            DatabaseField databaseField = (DatabaseField)abstractRecord.getFields().elementAt(i);
            if (!collection.contains(databaseField)) continue;
            abstractRecord.remove(databaseField);
        }
    }

    public boolean isUsedToSetPrimaryKey() {
        return this.isUsedToSetPrimaryKey;
    }

    protected void clearInitialization() {
        this.main = null;
        this.tableToVectorOfFieldsForGenerationMap = null;
        this.fieldsNotFromDescriptor_DefaultTable = null;
        this.fieldsNotFromDescriptor_OtherTables = null;
    }

    protected void initializeIsUsedToSetPrimaryKey() {
        this.isUsedToSetPrimaryKey = false;
        if (this.main[0][2] == null || this.main[0][2].isEmpty()) {
            return;
        }
        List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size() && !this.isUsedToSetPrimaryKey; ++i) {
            this.isUsedToSetPrimaryKey = this.main[0][2].contains(list.get(i));
        }
    }

    protected boolean verifyFieldAndMapping(AbstractSession abstractSession, DatabaseField databaseField) {
        DatabaseMapping databaseMapping;
        boolean bl = true;
        ReturningPolicy.verifyField(abstractSession, databaseField, this.getDescriptor());
        List<DatabaseMapping> list = this.getDescriptor().getObjectBuilder().getReadOnlyMappingsForField(databaseField);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                databaseMapping = list.get(i);
                bl &= ReturningPolicy.verifyFieldAndMapping(abstractSession, databaseField, this.getDescriptor(), databaseMapping);
            }
        }
        if ((databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField)) != null) {
            bl &= ReturningPolicy.verifyFieldAndMapping(abstractSession, databaseField, this.getDescriptor(), databaseMapping);
        }
        return bl;
    }

    protected static boolean verifyFieldAndMapping(AbstractSession abstractSession, DatabaseField databaseField, ClassDescriptor classDescriptor, DatabaseMapping databaseMapping) {
        Object object;
        ReturningPolicy.verifyField(abstractSession, databaseField, classDescriptor);
        while (databaseMapping.isAggregateObjectMapping()) {
            object = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor();
            databaseMapping = ((ClassDescriptor)object).getObjectBuilder().getMappingForField(databaseField);
            ReturningPolicy.verifyFieldAndMapping(abstractSession, databaseField, (ClassDescriptor)object, databaseMapping);
        }
        if (!databaseMapping.isDirectToFieldMapping() && !databaseMapping.isTransformationMapping()) {
            object = Helper.getShortClassName(databaseMapping);
            abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappingNotSupported(databaseField.getName(), (String)object, databaseMapping));
            return false;
        }
        return true;
    }

    protected static boolean verifyField(AbstractSession abstractSession, DatabaseField databaseField, ClassDescriptor classDescriptor) {
        VersionLockingPolicy versionLockingPolicy;
        OptimisticLockingPolicy optimisticLockingPolicy;
        boolean bl = true;
        if (databaseField.equals(classDescriptor.getSequenceNumberField())) {
            bl = false;
            abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(databaseField.getName(), classDescriptor));
        } else if (classDescriptor.hasInheritance() && databaseField.equals(classDescriptor.getInheritancePolicy().getClassIndicatorField())) {
            bl = false;
            abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(databaseField.getName(), classDescriptor));
        } else if (classDescriptor.usesOptimisticLocking() && (optimisticLockingPolicy = classDescriptor.getOptimisticLockingPolicy()) instanceof VersionLockingPolicy && databaseField.equals((versionLockingPolicy = (VersionLockingPolicy)optimisticLockingPolicy).getWriteLockField())) {
            bl = false;
            abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(databaseField.getName(), classDescriptor));
        }
        return bl;
    }

    public void validationAfterDescriptorInitialization(AbstractSession abstractSession) {
        Object object;
        Hashtable<DatabaseField, DatabaseField> hashtable = new Hashtable<DatabaseField, DatabaseField>();
        for (int i = 0; i <= 1; ++i) {
            if (this.main[i][2] == null || this.main[i][2].isEmpty()) continue;
            for (DatabaseField databaseField : this.main[i][2]) {
                hashtable.put(databaseField, databaseField);
            }
        }
        if (!hashtable.isEmpty()) {
            Enumeration<DatabaseField> enumeration = this.getDescriptor().getFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField;
                object = enumeration.nextElement();
                databaseField = (DatabaseField)hashtable.get(object);
                if (databaseField == null) continue;
                if (databaseField.getType() == null) {
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappedFieldTypeNotSet(databaseField.getName(), this.getDescriptor()));
                    continue;
                }
                if (!ReturningPolicy.isThereATypeConflict(databaseField, (DatabaseField)object)) continue;
                abstractSession.getIntegrityChecker().handleError(DescriptorException.returningPolicyAndDescriptorFieldTypeConflict(databaseField.getName(), databaseField.getType().getName(), object.getType().getName(), this.getDescriptor()));
            }
        }
        if (!(abstractSession.getDatasourcePlatform() instanceof DatabasePlatform)) {
            return;
        }
        WriteObjectQuery[] writeObjectQueryArray = new WriteObjectQuery[]{this.getDescriptor().getQueryManager().getInsertQuery(), this.getDescriptor().getQueryManager().getUpdateQuery()};
        object = new String[]{"InsertObjectQuery", "UpdateObjectQuery"};
        for (int i = 0; i <= 1; ++i) {
            if (this.main[i][4] == null || this.main[i][4].isEmpty()) continue;
            if (writeObjectQueryArray[i] == null || writeObjectQueryArray[i].getDatasourceCall() == null) {
                if (abstractSession.getPlatform().canBuildCallWithReturning()) continue;
                abstractSession.getIntegrityChecker().handleError(DescriptorException.noCustomQueryForReturningPolicy(object[i], Helper.getShortClassName(abstractSession.getPlatform()), this.getDescriptor()));
                continue;
            }
            if (!(writeObjectQueryArray[i].getDatasourceCall() instanceof StoredProcedureCall)) continue;
            DatabaseCall databaseCall = (DatabaseCall)writeObjectQueryArray[i].getDatasourceCall();
            Enumeration enumeration = databaseCall.getOutputRowFields().elements();
            Collection collection = this.createCollection();
            collection.addAll(this.main[i][4]);
            while (enumeration.hasMoreElements()) {
                collection.remove(enumeration.nextElement());
            }
            if (collection.isEmpty()) continue;
            for (DatabaseField databaseField : collection) {
                abstractSession.getIntegrityChecker().handleError(DescriptorException.customQueryAndReturningPolicyFieldConflict(databaseField.getName(), object[i], this.getDescriptor()));
            }
        }
    }

    public DatabaseField getField(DatabaseField databaseField) {
        DatabaseField databaseField2 = null;
        if (this.fieldsNotFromDescriptor_DefaultTable != null) {
            databaseField2 = (DatabaseField)this.fieldsNotFromDescriptor_DefaultTable.get(databaseField);
        }
        if (databaseField2 == null && this.fieldsNotFromDescriptor_OtherTables != null) {
            databaseField2 = (DatabaseField)this.fieldsNotFromDescriptor_OtherTables.get(databaseField);
        }
        return databaseField2;
    }

    public static class Info
    implements Cloneable {
        private DatabaseField field;
        private boolean isInsert;
        private boolean isInsertModeReturnOnly;
        private boolean isUpdate;
        private Class referenceClass;
        private String referenceClassName;

        Info() {
        }

        Info(DatabaseField databaseField, boolean bl, boolean bl2, boolean bl3) {
            this.field = databaseField;
            if (databaseField != null && databaseField.getType() != null) {
                this.setReferenceClass(databaseField.getType());
            }
            this.isInsert = bl;
            this.isInsertModeReturnOnly = bl2;
            this.isUpdate = bl3;
        }

        public DatabaseField getField() {
            return this.field;
        }

        public void setField(DatabaseField databaseField) {
            this.field = databaseField;
            if (databaseField.getType() == null && this.referenceClass != null) {
                databaseField.setType(this.referenceClass);
            }
        }

        public boolean isInsert() {
            return this.isInsert;
        }

        public void setIsInsert(boolean bl) {
            this.isInsert = bl;
        }

        public boolean isInsertModeReturnOnly() {
            return this.isInsertModeReturnOnly;
        }

        public void setIsInsertModeReturnOnly(boolean bl) {
            this.isInsertModeReturnOnly = bl;
        }

        public boolean isUpdate() {
            return this.isUpdate;
        }

        public void setIsUpdate(boolean bl) {
            this.isUpdate = bl;
        }

        public Class getReferenceClass() {
            return this.referenceClass;
        }

        public void setReferenceClass(Class clazz) {
            this.referenceClass = clazz;
            if (clazz != null) {
                this.referenceClassName = clazz.getName();
            }
        }

        public String getReferenceClassName() {
            return this.referenceClassName;
        }

        public void setReferenceClassName(String string) {
            this.referenceClassName = string;
        }

        boolean is(int n, int n2) {
            if (n == 0) {
                if (this.isInsert) {
                    if (n2 == 0) {
                        return this.isInsertModeReturnOnly;
                    }
                    return !this.isInsertModeReturnOnly;
                }
            } else if (this.isUpdate) {
                return n2 == 1;
            }
            return false;
        }

        boolean is(int n) {
            if (n == 0) {
                return this.isInsert;
            }
            return this.isUpdate;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                throw new InternalError("clone failed");
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Info) {
                return this.equals((Info)object);
            }
            return false;
        }

        boolean equals(Info info) {
            if (this == info) {
                return true;
            }
            if (!this.getField().equals(info.getField())) {
                return false;
            }
            if (this.getField().getType() == null && info.getField().getType() != null) {
                return false;
            }
            if (this.getField().getType() != null && !this.getField().getType().equals(info.getField().getType())) {
                return false;
            }
            if (this.isInsert() != info.isInsert()) {
                return false;
            }
            if (this.isInsertModeReturnOnly() != info.isInsertModeReturnOnly()) {
                return false;
            }
            return this.isUpdate() == info.isUpdate();
        }
    }
}

