/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;

public class EISAccessor
extends DatasourceAccessor {
    protected Connection cciConnection;
    protected RecordFactory recordFactory;

    protected void basicBeginTransaction(AbstractSession abstractSession) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().begin();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, abstractSession);
        }
    }

    protected void closeDatasourceConnection() {
        try {
            this.getCCIConnection().close();
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, null);
        }
    }

    protected void basicCommitTransaction(AbstractSession abstractSession) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().commit();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, abstractSession);
        }
    }

    protected void buildConnectLog(AbstractSession abstractSession) {
        try {
            if (abstractSession.shouldLog(4, "connection")) {
                ConnectionMetaData connectionMetaData = this.getCCIConnection().getMetaData();
                Object[] objectArray = new Object[]{connectionMetaData.getUserName(), connectionMetaData.getEISProductName(), connectionMetaData.getEISProductVersion(), Helper.cr(), "\t"};
                abstractSession.log(4, "connection", "connected_user_database", objectArray, this);
            }
        }
        catch (ResourceException resourceException) {
            abstractSession.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public Object executeCall(Call call, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        return this.basicExecuteCall(call, abstractRecord, abstractSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object basicExecuteCall(Call call, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        boolean bl;
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        Interaction interaction = null;
        Serializable serializable = null;
        EISInteraction eISInteraction = null;
        try {
            eISInteraction = (EISInteraction)call;
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseCall(call);
        }
        boolean bl2 = bl = !this.isInTransaction() && this.getEISPlatform().requiresAutoCommit();
        if (bl) {
            this.beginTransaction(abstractSession);
        }
        try {
            if (abstractSession.shouldLog(3, "sql")) {
                abstractSession.log(3, "sql", call.getLogString(this), null, this, false);
            }
            this.incrementCallCount(abstractSession);
            abstractSession.startOperationProfile("sql prepare", eISInteraction.getQuery(), Integer.MAX_VALUE);
            Record record = null;
            Record record2 = null;
            try {
                interaction = this.getCCIConnection().createInteraction();
                record = this.getEISPlatform().createInputRecord(eISInteraction, this);
                record2 = this.getEISPlatform().createOutputRecord(eISInteraction, this);
            }
            finally {
                abstractSession.endOperationProfile("sql prepare", eISInteraction.getQuery(), Integer.MAX_VALUE);
            }
            abstractSession.startOperationProfile("sql execute", eISInteraction.getQuery(), Integer.MAX_VALUE);
            try {
                InteractionSpec interactionSpec = this.getEISPlatform().buildInteractionSpec(eISInteraction);
                if (record2 == null) {
                    record2 = interaction.execute(interactionSpec, record);
                } else {
                    interaction.execute(interactionSpec, record, record2);
                }
                abstractSession.log(1, "query", "adapter_result", record2);
                if (eISInteraction.isNothingReturned()) {
                    AbstractRecord abstractRecord2;
                    serializable = new Integer(1);
                    if (record2 != null && (abstractRecord2 = this.getEISPlatform().buildRow(record2, eISInteraction, this)) != null) {
                        eISInteraction.getQuery().setProperty("output", abstractRecord2);
                        abstractSession.getEventManager().outputParametersDetected(abstractRecord2, eISInteraction);
                    }
                } else {
                    serializable = eISInteraction.isOneRowReturned() ? this.getEISPlatform().buildRow(record2, eISInteraction, this) : this.getEISPlatform().buildRows(record2, eISInteraction, this);
                }
                abstractSession.log(1, "query", "data_access_result", record2);
            }
            finally {
                abstractSession.endOperationProfile("sql execute", eISInteraction.getQuery(), Integer.MAX_VALUE);
            }
        }
        catch (ResourceException resourceException) {
            try {
                interaction.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.decrementCallCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bl) {
                    this.commitTransaction(abstractSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw EISException.resourceException(resourceException, call, this, abstractSession);
        }
        catch (RuntimeException runtimeException) {
            try {
                try {
                    interaction.close();
                }
                finally {
                    if (bl) {
                        this.commitTransaction(abstractSession);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            interaction.close();
            if (bl) {
                this.commitTransaction(abstractSession);
            }
            bl3 = true;
            this.decrementCallCount();
            bl4 = true;
        }
        catch (ResourceException resourceException) {
            try {
                if (!bl3 && bl) {
                    this.commitTransaction(abstractSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!bl4) {
                    this.decrementCallCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw EISException.resourceException(resourceException, this, abstractSession);
        }
        return serializable;
    }

    public Connection getCCIConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public EISPlatform getEISPlatform() {
        return (EISPlatform)this.getDatasourcePlatform();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    public void basicRollbackTransaction(AbstractSession abstractSession) throws DatabaseException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().rollback();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, abstractSession);
        }
    }

    protected boolean isDatasourceConnected() {
        return this.isConnected;
    }
}

