/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class IntegrityChecker
implements Serializable {
    protected Vector caughtExceptions = null;
    protected Vector tables = null;
    protected boolean shouldCatchExceptions = true;
    protected boolean shouldCheckDatabase = false;
    protected boolean shouldCheckInstantiationPolicy = true;

    public void catchExceptions() {
        this.setShouldCatchExceptions(true);
    }

    public void checkDatabase() {
        this.setShouldCheckDatabase(true);
    }

    public void checkInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(true);
    }

    public boolean checkTable(DatabaseTable databaseTable, AbstractSession abstractSession) {
        boolean bl;
        if (this.getTables().size() == 0) {
            this.initializeTables(abstractSession);
        }
        if (!(bl = this.getTables().contains(databaseTable.getName())) && abstractSession.getPlatform().isMySQL()) {
            return this.getTables().contains(databaseTable.getName().toLowerCase());
        }
        return bl;
    }

    public void dontCatchExceptions() {
        this.setShouldCatchExceptions(false);
    }

    public void dontCheckDatabase() {
        this.setShouldCheckDatabase(false);
    }

    public void dontCheckInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(false);
    }

    public Vector getCaughtExceptions() {
        if (this.caughtExceptions == null) {
            this.caughtExceptions = new Vector();
        }
        return this.caughtExceptions;
    }

    public Vector getTables() {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        return this.tables;
    }

    public void handleError(RuntimeException runtimeException) {
        if (!this.shouldCatchExceptions()) {
            throw runtimeException;
        }
        this.getCaughtExceptions().addElement(runtimeException);
    }

    public boolean hasErrors() {
        return this.caughtExceptions != null && this.caughtExceptions.size() > 0;
    }

    public boolean hasRuntimeExceptions() {
        if (this.hasErrors()) {
            Enumeration enumeration = this.getCaughtExceptions().elements();
            while (enumeration.hasMoreElements()) {
                if (!(enumeration.nextElement() instanceof RuntimeException)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeTables(AbstractSession abstractSession) {
        Vector vector = abstractSession.getAccessor().getTableInfo(null, null, null, null, abstractSession);
        for (AbstractRecord abstractRecord : vector) {
            if (abstractSession.getPlatform().shouldForceFieldNamesToUpperCase()) {
                this.tables.add(((String)abstractRecord.get("TABLE_NAME")).toUpperCase());
                continue;
            }
            this.tables.add(abstractRecord.get("TABLE_NAME"));
        }
    }

    public void setCaughtExceptions(Vector vector) {
        this.caughtExceptions = vector;
    }

    public void setShouldCatchExceptions(boolean bl) {
        this.shouldCatchExceptions = bl;
    }

    public void setShouldCheckDatabase(boolean bl) {
        this.shouldCheckDatabase = bl;
    }

    public void setShouldCheckInstantiationPolicy(boolean bl) {
        this.shouldCheckInstantiationPolicy = bl;
    }

    public boolean shouldCatchExceptions() {
        return this.shouldCatchExceptions;
    }

    public boolean shouldCheckDatabase() {
        return this.shouldCheckDatabase;
    }

    public boolean shouldCheckInstantiationPolicy() {
        return this.shouldCheckInstantiationPolicy;
    }
}

