/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class InstanceVariableAttributeAccessor
extends AttributeAccessor {
    protected transient Field attributeField;

    public Class getAttributeClass() {
        if (this.getAttributeField() == null) {
            return null;
        }
        return this.getAttributeType();
    }

    protected Field getAttributeField() {
        return this.attributeField;
    }

    public Class getAttributeType() {
        return this.attributeField.getType();
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.attributeField, object));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), object.getClass().getName(), privilegedActionException.getException());
                }
            }
            return this.attributeField.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), object.getClass().getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), object.getClass().getName(), illegalAccessException);
        }
        catch (NullPointerException nullPointerException) {
            String string = null;
            if (object != null) {
                string = object.getClass().getName();
            }
            throw DescriptorException.nullPointerWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), string, nullPointerException);
        }
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setAttributeField(Helper.getField(clazz, this.getAttributeName()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw DescriptorException.noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), clazz.getName(), noSuchFieldException);
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), clazz.getName(), securityException);
        }
    }

    public boolean isInitialized() {
        return this.attributeField != null;
    }

    protected void setAttributeField(Field field) {
        this.attributeField = field;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        block30: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, object, object2));
                        break block30;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, privilegedActionException.getException());
                    }
                }
                this.attributeField.set(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    if (object2 == null) {
                        Class clazz = this.getAttributeClass();
                        if (Helper.isPrimitiveWrapper(clazz)) {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz)));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, privilegedActionException.getException());
                                }
                            } else {
                                PrivilegedAccessHelper.setValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz));
                            }
                        }
                        return;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, illegalArgumentException);
                }
                try {
                    if (object2 instanceof String) {
                        Object object3 = ConversionManager.getDefaultManager().convertObject(object2, this.getAttributeClass());
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, object, object3));
                            }
                            catch (PrivilegedActionException privilegedActionException) {}
                        } else {
                            PrivilegedAccessHelper.setValueInField(this.attributeField, object, object3);
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw DescriptorException.illegalArgumentWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), object2, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (object2 == null) {
                    return;
                }
                throw DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object.getClass().getName(), object2, illegalAccessException);
            }
            catch (NullPointerException nullPointerException) {
                try {
                    if (object != null) {
                        Class clazz = this.getAttributeClass();
                        if (Helper.isPrimitiveWrapper(clazz) && object2 == null) {
                            if (!Helper.isPrimitiveWrapper(clazz)) break block30;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz)));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, privilegedActionException.getException());
                                }
                            }
                            PrivilegedAccessHelper.setValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz));
                        }
                        throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                    }
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
            }
        }
    }
}

