/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class FunctionExpression
extends BaseExpression {
    protected Vector children = NonSynchronizedVector.newInstance(2);
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Class resultType = null;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FunctionExpression functionExpression = (FunctionExpression)object;
        if (!(this.getOperator() == functionExpression.getOperator() || this.getOperator() != null && this.getOperator().equals(functionExpression.getOperator()))) {
            return false;
        }
        Vector vector = this.getChildren();
        Vector vector2 = functionExpression.getChildren();
        int n = vector.size();
        if (n != vector2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (vector.get(i).equals(vector2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getOperator() != null) {
            n += this.getOperator().hashCode();
        }
        Vector vector = this.getChildren();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            n += vector.get(i).hashCode();
        }
        return n;
    }

    public void addChild(Expression expression) {
        this.getChildren().addElement(expression);
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        return this.getBaseExpression().aliasForTable(databaseTable);
    }

    public Expression asOf(AsOfClause asOfClause) {
        final AsOfClause asOfClause2 = asOfClause;
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isDataExpression()) {
                    expression.asOf(asOfClause2);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expressionIterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression expression, Object object, ExpressionOperator expressionOperator) {
        this.baseExpression = expression;
        this.addChild(expression);
        Expression expression2 = Expression.from(object, expression);
        this.addChild(expression2);
        this.setOperator(expressionOperator);
        return this;
    }

    public Expression createWithBaseLast(Expression expression, Object object, ExpressionOperator expressionOperator) {
        this.baseExpression = expression;
        Expression expression2 = Expression.from(object, expression);
        this.addChild(expression2);
        this.addChild(expression);
        this.setOperator(expressionOperator);
        return this;
    }

    public Expression create(Expression expression, Vector vector, ExpressionOperator expressionOperator) {
        this.baseExpression = expression;
        this.addChild(expression);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression2 = Expression.from(enumeration.nextElement(), expression);
            this.addChild(expression2);
        }
        this.setOperator(expressionOperator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Function";
    }

    public boolean doesConform(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        if (this.getOperator().getSelector() == 3) {
            return !this.getBaseExpression().doesConform(object, abstractSession, abstractRecord, n, bl);
        }
        if (this.getOperator().getSelector() == 15 || this.getOperator().getSelector() == 16 || this.getOperator().getSelector() == 13 || this.getOperator().getSelector() == 14) {
            Object object2;
            Object object3 = this.getBaseExpression().valueFromObject(object, abstractSession, abstractRecord, n, bl);
            Vector vector = new Vector(this.getChildren().size());
            for (int i = 1; i < this.getChildren().size(); ++i) {
                object2 = this.getChildren().elementAt(i) instanceof Expression ? ((Expression)this.getChildren().elementAt(i)).valueFromObject(object, abstractSession, abstractRecord, n, bl) : this.getChildren().elementAt(i);
                if (object2 instanceof Vector) {
                    vector = (Vector)object2;
                    continue;
                }
                vector.addElement(object2);
            }
            if (object3 instanceof Vector) {
                Enumeration enumeration = ((Vector)object3).elements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!this.getOperator().doesRelationConform(object2, vector)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(object3, vector);
        }
        if (this.getOperator().getSelector() == 17 || this.getOperator().getSelector() == 18) {
            Object object4 = this.getBaseExpression().valueFromObject(object, abstractSession, abstractRecord, n, bl);
            if (object4 instanceof Vector) {
                Enumeration enumeration = ((Vector)object4).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!this.getOperator().doesRelationConform(e, null)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(object4, null);
        }
        throw QueryException.cannotConformExpression();
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getFields() {
        return this.getBaseExpression().getFields();
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform databasePlatform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(databasePlatform);
        }
        return this.platformOperator;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public boolean hasResultType() {
        return this.resultType != null;
    }

    public void initializePlatformOperator(DatabasePlatform databasePlatform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = databasePlatform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isFunctionExpression() {
        return true;
    }

    protected boolean isObjectComparison() {
        if (this.getChildren().size() != 1) {
            return false;
        }
        int n = this.getOperator().getSelector();
        if (n != 17 && n != 18) {
            return false;
        }
        Expression expression = this.getBaseExpression();
        return expression.isObjectExpression() && !((ObjectExpression)expression).isAttribute();
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            expression.iterateOn(expressionIterator);
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        if (this.getChildren().isEmpty()) {
            return this;
        }
        if (!this.isObjectComparison()) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                this.getChildren().setElementAt(((Expression)this.getChildren().elementAt(i)).normalize(expressionNormalizer), i);
            }
            return this;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            ((Expression)this.getChildren().elementAt(i)).validateNode();
        }
        ObjectExpression objectExpression = (ObjectExpression)this.getBaseExpression();
        objectExpression.getBaseExpression().normalize(expressionNormalizer);
        Expression expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, (Object)null, this.getSession());
        if (this.getOperator().getSelector() == 18) {
            expression = expression.not();
        }
        return expression;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        Vector vector = this.children;
        this.children = NonSynchronizedVector.newInstance();
        for (int i = 0; i < vector.size(); ++i) {
            this.addChild(((Expression)vector.elementAt(i)).copiedVersionFrom(map));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionOperator.printCollection(this.getChildren(), expressionSQLPrinter);
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        expressionOperator.printJavaCollection(this.getChildren(), expressionJavaPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Vector)nonSynchronizedVector).addElement(((Expression)this.children.elementAt(i)).rebuildOn(expression));
        }
        expression2.setSelectIfOrderedBy(this.getBaseExpression().selectIfOrderedBy());
        FunctionExpression functionExpression = (FunctionExpression)expression2.performOperator(this.getOperator(), nonSynchronizedVector);
        functionExpression.setResultType(this.getResultType());
        return functionExpression;
    }

    public void setLocalBase(Expression expression) {
        this.getBaseExpression().setLocalBase(expression);
    }

    public void setOperator(ExpressionOperator expressionOperator) {
        this.operator = expressionOperator;
    }

    public void setResultType(Class clazz) {
        this.resultType = clazz;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        if (this.getChildren().isEmpty()) {
            return (Expression)this.clone();
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Vector)nonSynchronizedVector).addElement(((Expression)this.children.elementAt(i)).twistedForBaseAndContext(expression, expression2));
        }
        Expression expression3 = (Expression)this.getChildren().elementAt(0);
        return expression3.twistedForBaseAndContext(expression, expression2).performOperator(this.getOperator(), nonSynchronizedVector);
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        Object object2 = this.getBaseExpression().valueFromObject(object, abstractSession, abstractRecord, n, bl);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            if (this.getChildren().elementAt(i) instanceof Expression) {
                ((Vector)nonSynchronizedVector).addElement(((Expression)this.getChildren().elementAt(i)).valueFromObject(object, abstractSession, abstractRecord, n, bl));
                continue;
            }
            ((Vector)nonSynchronizedVector).addElement(this.getChildren().elementAt(i));
        }
        if (object2 instanceof Vector) {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    vector.addElement(e);
                    continue;
                }
                vector.addElement(this.getOperator().applyFunction(e, nonSynchronizedVector));
            }
            return vector;
        }
        if (object2 == null) {
            return null;
        }
        return this.getOperator().applyFunction(object2, nonSynchronizedVector);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.operator.toString());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        if (this.getBaseExpression().isDataExpression()) {
            DatabaseField databaseField = ((DataExpression)this.getBaseExpression()).getField();
            databaseField = databaseField == null ? new DatabaseField("*") : (DatabaseField)databaseField.clone();
            if (this.hasResultType()) {
                databaseField.setType(this.getResultType());
            } else {
                int n = this.getOperator().getSelector();
                if (n != 22 && n != 23) {
                    databaseField.setType(null);
                }
            }
            vector.addElement(databaseField);
        } else {
            DatabaseField databaseField = new DatabaseField("*");
            databaseField.setType(this.getResultType());
            vector.addElement(databaseField);
        }
        this.printSQL(expressionSQLPrinter);
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(bufferedWriter, n);
        }
    }
}

