/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.FunctionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DateFunctionNode
extends FunctionalExpressionNode {
    private Class type;

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            reportQuery.addAttribute("date", this.generateExpression(generationContext), this.type);
        }
    }

    public void validate(ParseTreeContext parseTreeContext) {
        this.setType(this.type);
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = generationContext.getBaseExpression();
        if (expression == null) {
            expression = new ExpressionBuilder();
        }
        Expression expression2 = null;
        if (this.type == Date.class) {
            expression2 = expression.currentDateDate();
        } else if (this.type == Time.class) {
            expression2 = expression.currentTime();
        } else if (this.type == Timestamp.class) {
            expression2 = expression.currentDate();
        }
        return expression2;
    }

    public void useCurrentDate() {
        this.type = Date.class;
    }

    public void useCurrentTime() {
        this.type = Time.class;
    }

    public void useCurrentTimestamp() {
        this.type = Timestamp.class;
    }
}

