/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTree;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

public class JPQLParseTree
extends ParseTree {
    public GenerationContext buildContext(ReadQuery readQuery, AbstractSession abstractSession) {
        GenerationContext generationContext = super.buildContext(readQuery, abstractSession);
        generationContext.setBaseQueryClass(readQuery.getReferenceClass());
        return generationContext;
    }

    private GenerationContext buildSubqueryContext(ReadQuery readQuery, GenerationContext generationContext) {
        SelectGenerationContext selectGenerationContext = new SelectGenerationContext(generationContext, this);
        selectGenerationContext.setBaseQueryClass(readQuery.getReferenceClass());
        return selectGenerationContext;
    }

    public GenerationContext populateSubquery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        GenerationContext generationContext2 = this.buildSubqueryContext(objectLevelReadQuery, generationContext);
        this.populateReadQueryInternal(objectLevelReadQuery, generationContext2);
        return generationContext2;
    }

    public void populateQuery(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (databaseQuery.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
            GenerationContext generationContext = this.buildContext(objectLevelReadQuery, abstractSession);
            this.populateReadQueryInternal(objectLevelReadQuery, generationContext);
        } else if (databaseQuery.isUpdateAllQuery()) {
            UpdateAllQuery updateAllQuery = (UpdateAllQuery)databaseQuery;
            GenerationContext generationContext = this.buildContext(updateAllQuery, abstractSession);
            this.populateModifyQueryInternal(updateAllQuery, generationContext);
            this.addUpdatesToQuery(updateAllQuery, generationContext);
        } else if (databaseQuery.isDeleteAllQuery()) {
            DeleteAllQuery deleteAllQuery = (DeleteAllQuery)databaseQuery;
            GenerationContext generationContext = this.buildContext(deleteAllQuery, abstractSession);
            this.populateModifyQueryInternal(deleteAllQuery, generationContext);
        }
    }

    private void populateReadQueryInternal(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.getReferenceClass() == null) {
            this.adjustReferenceClassForQuery(objectLevelReadQuery, generationContext);
        }
        this.initBaseExpression(objectLevelReadQuery, generationContext);
        this.validate(generationContext.getSession(), this.getClassLoader());
        this.applyQueryNodeToQuery(objectLevelReadQuery, generationContext);
        this.verifySelect(objectLevelReadQuery, generationContext);
        this.setSelectionCriteriaForQuery(objectLevelReadQuery, generationContext);
        this.addOrderingToQuery(objectLevelReadQuery, generationContext);
        this.addGroupingToQuery(objectLevelReadQuery, generationContext);
        this.addHavingToQuery(objectLevelReadQuery, generationContext);
        this.addNonFetchJoinAttributes(objectLevelReadQuery, generationContext);
    }

    private void populateModifyQueryInternal(ModifyAllQuery modifyAllQuery, GenerationContext generationContext) {
        if (modifyAllQuery.getReferenceClass() == null) {
            this.adjustReferenceClassForQuery(modifyAllQuery, generationContext);
        }
        modifyAllQuery.setSession(generationContext.getSession());
        this.initBaseExpression(modifyAllQuery, generationContext);
        this.validate(generationContext.getSession(), this.getClassLoader());
        this.applyQueryNodeToQuery(modifyAllQuery, generationContext);
        this.setSelectionCriteriaForQuery(modifyAllQuery, generationContext);
    }
}

