/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class MultiplyNode
extends BinaryOperatorNode {
    public void validate(ParseTreeContext parseTreeContext) {
        super.validate(parseTreeContext);
        if (this.left != null && this.right != null) {
            TypeHelper typeHelper = parseTreeContext.getTypeHelper();
            this.setType(typeHelper.extendedBinaryNumericPromotion(this.left.getType(), this.right.getType()));
        }
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = ExpressionMath.multiply(expression, this.getRight().generateExpression(generationContext));
        return expression;
    }

    public boolean isMultiplyNode() {
        return true;
    }
}

