/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.StringFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class SubstringNode
extends StringFunctionNode {
    private Node startPosition = null;
    private Node stringLength = null;

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(parseTreeContext);
        }
        if (this.startPosition != null) {
            this.startPosition = this.startPosition.qualifyAttributeAccess(parseTreeContext);
        }
        if (this.stringLength != null) {
            this.stringLength = this.stringLength.qualifyAttributeAccess(parseTreeContext);
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            this.left.validateParameter(parseTreeContext, typeHelper.getStringType());
        }
        if (this.startPosition != null) {
            this.startPosition.validate(parseTreeContext);
            this.startPosition.validateParameter(parseTreeContext, typeHelper.getIntType());
        }
        if (this.stringLength != null) {
            this.stringLength.validate(parseTreeContext);
            this.stringLength.validateParameter(parseTreeContext, typeHelper.getIntType());
        }
        this.setType(typeHelper.getStringType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        Expression expression2 = this.getStartPosition().generateExpression(generationContext);
        Expression expression3 = this.getStringLength().generateExpression(generationContext);
        expression = expression.substring(expression2, expression3);
        return expression;
    }

    private Node getStartPosition() {
        return this.startPosition;
    }

    private Node getStringLength() {
        return this.stringLength;
    }

    public void setStartPosition(Node node) {
        this.startPosition = node;
    }

    public void setStringLength(Node node) {
        this.stringLength = node;
    }
}

