/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine {
    private static XPathEngine instance = null;
    private UnmarshalXPathEngine unmarshalXPathEngine;
    private DocumentPreservationPolicy noDocPresPolicy = new NoDocumentPreservationPolicy();
    private DocumentPreservationPolicy xmlBinderPolicy = new XMLBinderPolicy();

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    private XPathEngine() {
        this.unmarshalXPathEngine = new UnmarshalXPathEngine();
    }

    public Node create(XMLField xMLField, Node node, AbstractSession abstractSession) throws XMLMarshalException {
        return this.create(xMLField, node, this, abstractSession);
    }

    public Node create(XMLField xMLField, Node node, Object object, AbstractSession abstractSession) {
        return this.create(xMLField, node, object, null, this.noDocPresPolicy, abstractSession);
    }

    public Node create(XMLField xMLField, Node node, Object object, XMLField xMLField2, DocumentPreservationPolicy documentPreservationPolicy, AbstractSession abstractSession) throws XMLMarshalException {
        XPathFragment xPathFragment;
        if (null == object) {
            return null;
        }
        if (documentPreservationPolicy == null) {
            documentPreservationPolicy = this.noDocPresPolicy;
        }
        if ((xPathFragment = xMLField.getXPathFragment()).getNextFragment() == null && xPathFragment.nameIsText()) {
            Object object2 = this.getValueToWrite(object, xMLField, abstractSession);
            if (object2 instanceof String) {
                if (xMLField.isTypedTextField()) {
                    XMLNodeList xMLNodeList = new XMLNodeList();
                    xMLNodeList.add(node);
                    this.addTypeAttributes(xMLNodeList, xMLField, object, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xMLField)));
                }
                return this.addText(xMLField, node, (String)object2);
            }
            return null;
        }
        NodeList nodeList = this.createCollection(xMLField, node, object, xMLField2, documentPreservationPolicy, abstractSession);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    private NodeList createCollection(XMLField xMLField, Node node, Object object, XMLField xMLField2, DocumentPreservationPolicy documentPreservationPolicy, AbstractSession abstractSession) throws XMLMarshalException {
        NodeList nodeList;
        XMLNodeList xMLNodeList = new XMLNodeList();
        if (object == null || object instanceof Collection && ((Collection)object).size() == 0) {
            return xMLNodeList;
        }
        Node node2 = node;
        Element element = null;
        if (xMLField2 != null && !xMLField2.getXPathFragment().isAttribute() && !xMLField2.getXPathFragment().nameIsText() && (nodeList = this.unmarshalXPathEngine.selectElementNodes(node, xMLField2.getXPathFragment(), this.getNamespaceResolverForField(xMLField2))).getLength() > 0) {
            element = (Element)nodeList.item(nodeList.getLength() - 1);
        }
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (xPathFragment != null) {
            Object object2;
            boolean bl;
            if (xPathFragment.isAttribute()) {
                this.addAttribute(xPathFragment, xMLField, node2, object, abstractSession);
            } else if (xPathFragment.containsIndex()) {
                boolean bl2 = bl = !xPathFragment.getHasText() && xPathFragment.getNextFragment() != null;
                if (bl) {
                    node2 = this.addIndexedElement(xPathFragment, xMLField, node2, this, !bl, abstractSession);
                } else {
                    object2 = this.getValueToWrite(object, xMLField, abstractSession);
                    node2 = this.addIndexedElement(xPathFragment, xMLField, node2, object2, !bl, abstractSession);
                    xMLNodeList.add(node2);
                }
            } else {
                boolean bl3 = bl = !xPathFragment.getHasText() && xPathFragment.getNextFragment() != null;
                if (bl) {
                    nodeList = this.addElements(xPathFragment, xMLField, node2, this, !bl, element, documentPreservationPolicy, abstractSession);
                } else {
                    object2 = xPathFragment.getNextFragment();
                    if (object2 != null && ((XPathFragment)object2).isAttribute() && !(object instanceof List)) {
                        nodeList = this.addElements(xPathFragment, xMLField, node2, this, bl, element, documentPreservationPolicy, abstractSession);
                    } else {
                        Object object3 = this.getValueToWrite(object, xMLField, abstractSession);
                        nodeList = this.addElements(xPathFragment, xMLField, node2, object3, !bl, element, documentPreservationPolicy, abstractSession);
                        xMLNodeList.addAll(nodeList);
                    }
                }
                node2 = nodeList.item(nodeList.getLength() - 1);
            }
            xPathFragment = xPathFragment.getNextFragment();
            element = null;
            if (xPathFragment == null || !xPathFragment.nameIsText()) continue;
            xPathFragment = null;
        }
        if (xMLField.isTypedTextField()) {
            this.addTypeAttributes(xMLNodeList, xMLField, object, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xMLField)));
        }
        return xMLNodeList;
    }

    private Object getNonNodeValueToWrite(Object object, XMLField xMLField, AbstractSession abstractSession) {
        if (this == object) {
            return this;
        }
        QName qName = null;
        if (xMLField.getLeafElementType() != null) {
            qName = xMLField.getLeafElementType();
        } else {
            if (xMLField.isUnionField()) {
                return this.getValueToWriteForUnion((XMLUnionField)xMLField, object, abstractSession);
            }
            if (xMLField.isTypedTextField()) {
                qName = xMLField.getXMLType(object.getClass());
            } else if (xMLField.getSchemaType() != null) {
                qName = xMLField.getSchemaType();
            }
        }
        if (object instanceof List) {
            if (xMLField.usesSingleNode()) {
                String string = "";
                for (int i = 0; i < ((List)object).size(); ++i) {
                    Object e = ((List)object).get(i);
                    String string2 = (String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(e, ClassConstants.STRING, qName);
                    string = string + string2;
                    if (i >= ((List)object).size() - 1) continue;
                    string = string + " ";
                }
                return string;
            }
            ArrayList arrayList = new ArrayList(((List)object).size());
            for (int i = 0; i < ((List)object).size(); ++i) {
                String string;
                Object e = ((List)object).get(i);
                if (e instanceof Node) {
                    arrayList.add(e);
                    continue;
                }
                if (qName != null && qName.equals(XMLConstants.QNAME_QNAME)) {
                    string = this.getStringForQName((QName)e, this.getNamespaceResolverForField(xMLField));
                    arrayList.add(string);
                    continue;
                }
                string = (String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(e, ClassConstants.STRING, qName);
                arrayList.add(string);
            }
            return arrayList;
        }
        if (qName != null && qName.equals(XMLConstants.QNAME_QNAME)) {
            return this.getStringForQName((QName)object, this.getNamespaceResolverForField(xMLField));
        }
        return ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, ClassConstants.STRING, qName);
    }

    private Object getValueToWrite(Object object, XMLField xMLField, AbstractSession abstractSession) {
        if (object instanceof Node) {
            return object;
        }
        return this.getNonNodeValueToWrite(object, xMLField, abstractSession);
    }

    private String getSingleValueToWriteForUnion(XMLUnionField xMLUnionField, Object object, AbstractSession abstractSession) {
        ArrayList arrayList = xMLUnionField.getSchemaTypes();
        QName qName = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2 = (QName)xMLUnionField.getSchemaTypes().get(i);
            try {
                if (qName2 == null) continue;
                Class clazz = xMLUnionField.getJavaClass(qName2);
                object = ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, clazz, qName2);
                qName = qName2;
                break;
            }
            catch (ConversionException conversionException) {
                if (i != arrayList.size() - 1) continue;
                qName = qName2;
            }
        }
        return (String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, ClassConstants.STRING, qName);
    }

    private Object getValueToWriteForUnion(XMLUnionField xMLUnionField, Object object, AbstractSession abstractSession) {
        if (object instanceof List) {
            if (xMLUnionField.usesSingleNode()) {
                String string = "";
                Object var5_6 = null;
                for (int i = 0; i < ((List)object).size(); ++i) {
                    var5_6 = ((List)object).get(i);
                    string = string + this.getSingleValueToWriteForUnion(xMLUnionField, var5_6, abstractSession);
                    if (i >= ((List)object).size() - 1) continue;
                    string = string + " ";
                }
                return string;
            }
            ArrayList<String> arrayList = new ArrayList<String>(((List)object).size());
            Object var5_7 = null;
            for (int i = 0; i < ((List)object).size(); ++i) {
                var5_7 = ((List)object).get(i);
                arrayList.add(this.getSingleValueToWriteForUnion(xMLUnionField, var5_7, abstractSession));
            }
            return arrayList;
        }
        return this.getSingleValueToWriteForUnion(xMLUnionField, object, abstractSession);
    }

    private Node addIndexedElement(XPathFragment xPathFragment, XMLField xMLField, Node node, Object object, boolean bl, AbstractSession abstractSession) throws XMLMarshalException {
        Node node2;
        Object object2;
        String string = xPathFragment.getShortName();
        int n = xPathFragment.getIndexValue();
        if (n < 0) {
            throw XMLMarshalException.invalidXPathIndexString(xPathFragment.getXPath());
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(xMLField);
        for (int i = 1; i < n; ++i) {
            object2 = new XMLField(string + "[" + i + "]");
            ((XMLField)object2).setNamespaceResolver(namespaceResolver);
            node2 = (Node)this.unmarshalXPathEngine.selectSingleNode(node, (XMLField)object2, (XMLNamespaceResolver)namespaceResolver);
            if (node2 != null) continue;
            this.addElement(new XPathFragment(string), xMLField, node, this, true, abstractSession);
        }
        XMLField xMLField2 = new XMLField(xPathFragment.getXPath());
        xMLField2.setNamespaceResolver(namespaceResolver);
        node2 = (Node)this.unmarshalXPathEngine.selectSingleNode(node, xMLField2, (XMLNamespaceResolver)namespaceResolver);
        if (node2 == null) {
            return this.addElement(new XPathFragment(string), xMLField2, node, object, true, abstractSession);
        }
        if (node2 != null && !bl) {
            return node2;
        }
        object2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element = node.getOwnerDocument().createElementNS((String)object2, string);
        if (object != this && object != null && object instanceof String) {
            this.addText(xMLField, element, (String)object);
        }
        node.replaceChild(element, node2);
        return element;
    }

    private Node addElement(XPathFragment xPathFragment, XMLField xMLField, Node node, Object object, boolean bl, AbstractSession abstractSession) {
        return this.addElement(xPathFragment, xMLField, node, null, object, bl, abstractSession);
    }

    private Node addElement(XPathFragment xPathFragment, XMLField xMLField, Node node, QName qName, Object object, boolean bl, AbstractSession abstractSession) {
        NodeList nodeList = this.addElements(xPathFragment, xMLField, node, object, bl, null, this.noDocPresPolicy, abstractSession);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    private NodeList addElements(XPathFragment xPathFragment, XMLField xMLField, Node node, Object object, boolean bl, Element element, DocumentPreservationPolicy documentPreservationPolicy, AbstractSession abstractSession) {
        NodeList nodeList;
        if (!bl && (nodeList = this.unmarshalXPathEngine.selectElementNodes(node, xPathFragment, this.getNamespaceResolverForField(xMLField))).getLength() > 0) {
            return nodeList;
        }
        nodeList = new XMLNodeList();
        if (object == this) {
            String string = this.resolveNamespacePrefix(xPathFragment, this.getNamespaceResolverForField(xMLField));
            Element element2 = node.getOwnerDocument().createElementNS(string, xPathFragment.getShortName());
            ((XMLNodeList)nodeList).add(element2);
            documentPreservationPolicy.getNodeOrderingPolicy().appendNode(node, element2, element);
        } else if (object == null) {
            ((XMLNodeList)nodeList).add(node);
        } else if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Element element3 = (Element)this.createElement(node, xPathFragment, xMLField, list.get(i), abstractSession);
                documentPreservationPolicy.getNodeOrderingPolicy().appendNode(node, element3, element);
                ((XMLNodeList)nodeList).add(element3);
                element = element3;
            }
        } else {
            Element element4 = (Element)this.createElement(node, xPathFragment, xMLField, object, abstractSession);
            documentPreservationPolicy.getNodeOrderingPolicy().appendNode(node, element4, element);
            ((XMLNodeList)nodeList).add(element4);
        }
        return nodeList;
    }

    private Node createElement(Node node, XPathFragment xPathFragment, XMLField xMLField, Object object, AbstractSession abstractSession) {
        Object object2;
        if (object == null) {
            return node;
        }
        if (object instanceof Node) {
            return this.createElement(node, xPathFragment, this.getNamespaceResolverForField(xMLField), (Node)object);
        }
        Element element = null;
        if (node.getOwnerDocument() == null) {
            element = ((Document)node).getDocumentElement();
        } else {
            object2 = this.resolveNamespacePrefix(xPathFragment, this.getNamespaceResolverForField(xMLField));
            element = node.getOwnerDocument().createElementNS((String)object2, xPathFragment.getXPath());
            if (xPathFragment.isGeneratedPrefix()) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
            }
        }
        object2 = xPathFragment.getNextFragment();
        if (object2 != null && ((XPathFragment)object2).isAttribute()) {
            this.addAttribute((XPathFragment)object2, xMLField, element, object, abstractSession);
        } else if (object instanceof String && !"".equals(object)) {
            this.addText(xMLField, element, (String)object);
        }
        return element;
    }

    public Element createUnownedElement(Node node, XMLField xMLField) {
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (xPathFragment.getNextFragment() != null) {
            xPathFragment = xPathFragment.getNextFragment();
        }
        String string = xPathFragment.getShortName();
        String string2 = this.resolveNamespacePrefix(xPathFragment, this.getNamespaceResolverForField(xMLField));
        Element element = node.getOwnerDocument().createElementNS(string2, string);
        if (xPathFragment.isGeneratedPrefix()) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
        return element;
    }

    private void addTypeAttributes(NodeList nodeList, XMLField xMLField, Object object, String string) {
        ArrayList<Object> arrayList;
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(xMLField);
        if (!xMLField.isTypedTextField()) {
            return;
        }
        if (object instanceof List) {
            arrayList = (ArrayList<Object>)object;
        } else {
            arrayList = new ArrayList<Object>();
            arrayList.add(object);
        }
        int n = nodeList.getLength();
        int n2 = arrayList.size();
        if (n != n2) {
            return;
        }
        Node node = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            QName qName;
            Class<?> clazz;
            node = nodeList.item(i);
            if (node.getNodeType() != 1 || (clazz = arrayList.get(i).getClass()) == ClassConstants.STRING || (qName = xMLField.getXMLType(clazz)) == null) continue;
            if (null == string) {
                string = namespaceResolver.generatePrefix("xsi");
                ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, "http://www.w3.org/2001/XMLSchema-instance");
            }
            if ((string3 = this.resolveNamespacePrefixForURI(qName.getNamespaceURI(), namespaceResolver)) == null || string3.equals("")) {
                string2 = qName.getLocalPart();
                string3 = namespaceResolver.generatePrefix();
                ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, qName.getNamespaceURI());
            }
            string2 = string3 + ":" + qName.getLocalPart();
            ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", string + ":" + "type", string2);
        }
    }

    private Node createElement(Node node, XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Node node2) {
        String string = xPathFragment.getXPath();
        Document document = node.getOwnerDocument();
        if (document == null && node.getNodeType() == 9) {
            document = (Document)node;
        }
        String string2 = node2.getNamespaceURI();
        String string3 = node2.getLocalName();
        String string4 = xPathFragment.getNamespaceURI();
        String string5 = xPathFragment.getLocalName();
        if (string3 != null && string3.equals(string5) && (string2 != null && string2.equals(string4) || string2 == null && string4 == null)) {
            if (document != node2.getOwnerDocument()) {
                return document.importNode(node2, true);
            }
            return node2;
        }
        String string6 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element = document.createElementNS(string6, string);
        NamedNodeMap namedNodeMap = node2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = document.importNode(namedNodeMap.item(i), true);
            element.setAttributeNode((Attr)node3);
        }
        NodeList nodeList = node2.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node4 = document.importNode(nodeList.item(i), true);
            element.appendChild(node4);
        }
        return element;
    }

    private Node addAttribute(XPathFragment xPathFragment, XMLField xMLField, Node node, Object object, AbstractSession abstractSession) {
        Object object2 = null;
        if (!(node instanceof Element)) {
            return node;
        }
        Element element = (Element)node;
        if (object instanceof Node) {
            if (((Node)object).getNodeType() == 2) {
                Attr attr = (Attr)object;
                if (node.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) == null) {
                    String string = null;
                    if (xMLField.getNamespaceResolver() != null) {
                        string = this.getNamespaceResolverForField(xMLField).resolveNamespaceURI(attr.getNamespaceURI());
                    }
                    if (string != null) {
                        element.setAttributeNS(attr.getNamespaceURI(), string + ":" + attr.getLocalName(), attr.getNodeValue());
                    } else {
                        element.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getNodeValue());
                    }
                }
                return node;
            }
            object2 = object;
        } else {
            object2 = this.getNonNodeValueToWrite(object, xMLField, abstractSession);
        }
        String string = xPathFragment.getLocalName();
        String string2 = this.resolveNamespacePrefix(xPathFragment, this.getNamespaceResolverForField(xMLField));
        if (object2 != null && node.getAttributes().getNamedItemNS(string2, string) == null) {
            if (object2 == this) {
                element.setAttributeNS(string2, xPathFragment.getShortName(), "");
            } else if (object2 instanceof String) {
                element.setAttributeNS(string2, xPathFragment.getShortName(), (String)object2);
            }
            if (xPathFragment.isGeneratedPrefix()) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
            }
        }
        return node;
    }

    public NodeList remove(XMLField xMLField, Node node) throws XMLMarshalException {
        return this.remove(xMLField, node, false);
    }

    public NodeList remove(XMLField xMLField, Node node, boolean bl) throws XMLMarshalException {
        String string = xMLField.getXPath();
        NodeList nodeList = this.unmarshalXPathEngine.selectNodes(node, xMLField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xMLField));
        int n = nodeList.getLength();
        boolean bl2 = this.containsIndex(string) && !bl;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 2) {
                ((Attr)node2).getOwnerElement().removeAttribute(node2.getNodeName());
                continue;
            }
            if (bl2) {
                Element element = node2.getParentNode().getOwnerDocument().createElementNS(node2.getNamespaceURI(), node2.getNodeName());
                node2.getParentNode().replaceChild(element, node2);
                continue;
            }
            node2.getParentNode().removeChild(node2);
        }
        return nodeList;
    }

    public NodeList replaceValue(XMLField xMLField, Node node, Object object, AbstractSession abstractSession) throws XMLMarshalException {
        NodeList nodeList = this.unmarshalXPathEngine.selectNodes(node, xMLField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xMLField));
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2;
            Node node3;
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() != 1) {
                if ((node4.getNodeType() == 3 || node4.getNodeType() == 4) && object == null) {
                    node3 = node4.getParentNode();
                    node2 = node3.getParentNode();
                    node2.removeChild(node3);
                    continue;
                }
                node4.setNodeValue((String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, ClassConstants.STRING));
                continue;
            }
            node3 = (Element)node4;
            node2 = node3.getParentNode();
            if (object == null) {
                node2.removeChild(node3);
                continue;
            }
            String string = node3.getTagName();
            Element element = null;
            Object object2 = this.getValueToWrite(object, xMLField, abstractSession);
            XPathFragment xPathFragment = new XPathFragment(string);
            xPathFragment.setNamespaceURI(node3.getNamespaceURI());
            element = (Element)this.createElement(node2, xPathFragment, xMLField, object2, abstractSession);
            if (element == node3) continue;
            node2.replaceChild(element, node3);
        }
        return nodeList;
    }

    public NodeList replaceCollection(XMLField xMLField, Node node, Collection collection, AbstractSession abstractSession) throws XMLMarshalException {
        Node node2;
        Node node3;
        int n;
        NodeList nodeList = null;
        nodeList = xMLField != null ? this.unmarshalXPathEngine.selectNodes(node, xMLField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xMLField)) : node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return nodeList;
        }
        Iterator iterator = collection.iterator();
        int n2 = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>();
        boolean bl = true;
        Object var11_11 = null;
        for (n = 0; n < n2 && iterator.hasNext(); ++n) {
            Node node4;
            node3 = nodeList.item(n);
            node2 = null;
            if (bl) {
                var11_11 = iterator.next();
            }
            Node node5 = node3.getParentNode();
            if (node3.getNodeType() != 1) {
                if ((node3.getNodeType() == 3 || node3.getNodeType() == 4) && var11_11 == null) {
                    node4 = node5.getParentNode();
                    node4.removeChild(node5);
                    continue;
                }
                node3.setNodeValue((String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(var11_11, ClassConstants.STRING));
                continue;
            }
            node4 = (Element)node3;
            String string = node4.getTagName();
            Object object = this.getValueToWrite(var11_11, xMLField, abstractSession);
            XPathFragment xPathFragment = new XPathFragment(string);
            xPathFragment.setNamespaceURI(node4.getNamespaceURI());
            node2 = (Element)this.createElement(node5, xPathFragment, xMLField, object, abstractSession);
            if (!vector.contains(node3)) {
                if (node2 != node3) {
                    node5.replaceChild(node2, node3);
                }
                vector.addElement(node2);
                bl = true;
                continue;
            }
            bl = false;
        }
        while (n < n2) {
            node3 = nodeList.item(n);
            node2 = node3.getParentNode();
            if (node2 != null && !vector.contains(node3)) {
                node2.removeChild(node3);
            }
            ++n;
        }
        if (var11_11 != null && !bl) {
            if (xMLField.getXPathFragment().getNextFragment() == null || xMLField.getXPathFragment().getHasText()) {
                this.create(xMLField, node, var11_11, xMLField, this.xmlBinderPolicy, abstractSession);
            } else {
                this.create(xMLField, node, var11_11, abstractSession);
            }
        }
        while (iterator.hasNext()) {
            var11_11 = iterator.next();
            if (xMLField.getXPathFragment().getNextFragment() == null || xMLField.getXPathFragment().getHasText()) {
                this.create(xMLField, node, var11_11, xMLField, this.xmlBinderPolicy, abstractSession);
                continue;
            }
            this.create(xMLField, node, var11_11, abstractSession);
        }
        return nodeList;
    }

    private boolean containsIndex(String string) {
        return string.lastIndexOf(91) != -1 && string.lastIndexOf(93) != -1;
    }

    private String resolveNamespacePrefix(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (xPathFragment.getNamespaceURI() != null) {
                return xPathFragment.getNamespaceURI();
            }
            if (xPathFragment.getPrefix() == null && xPathFragment.isAttribute()) {
                return null;
            }
            return namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String resolveNamespacePrefixForURI(String string, NamespaceResolver namespaceResolver) {
        if (null == namespaceResolver) {
            return null;
        }
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!namespaceResolver.resolveNamespacePrefix(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    private Node addText(XMLField xMLField, Node node, String string) {
        if (xMLField.isCDATA()) {
            CDATASection cDATASection = node.getOwnerDocument().createCDATASection(string);
            node.appendChild(cDATASection);
            return cDATASection;
        }
        Text text = node.getOwnerDocument().createTextNode(string);
        node.appendChild(text);
        return text;
    }

    private String getStringForQName(QName qName, NamespaceResolver namespaceResolver) {
        if (null == qName) {
            return null;
        }
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String string = qName.getNamespaceURI();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = namespaceResolver.resolveNamespaceURI(string);
        if (null == string2) {
            return qName.getLocalPart();
        }
        return string2 + ":" + qName.getLocalPart();
    }

    private NamespaceResolver getNamespaceResolverForField(XMLField xMLField) {
        NamespaceResolver namespaceResolver = xMLField.getNamespaceResolver();
        if (namespaceResolver == null) {
            xMLField.setNamespaceResolver(new NamespaceResolver());
        }
        return xMLField.getNamespaceResolver();
    }
}

