/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class XPathFragment {
    public static final String TEXT = "text()";
    public static final XPathFragment TEXT_FRAGMENT = new XPathFragment("text()");
    public static final XPathFragment SELF_FRAGMENT = new XPathFragment(".");
    public static final XPathFragment ANY_FRAGMENT = null;
    private XPathFragment nextFragment;
    private String xpath;
    private boolean hasAttribute = false;
    private boolean hasText = false;
    private boolean hasNamespace = false;
    private boolean containsIndex = false;
    private int indexValue = -1;
    private boolean shouldExecuteSelectNodes = false;
    private String shortName;
    private String prefix;
    private String localName;
    private String namespaceURI;
    private QName qname;
    protected boolean nameIsText = false;
    protected boolean isSelfFragment = false;
    private QName leafElementType;
    private boolean generatedPrefix = false;

    public XPathFragment(String string) {
        this.setXPath(string);
    }

    public XPathFragment() {
    }

    public XPathFragment getNextFragment() {
        return this.nextFragment;
    }

    public void setNextFragment(XPathFragment xPathFragment) {
        this.nextFragment = xPathFragment;
    }

    public void setXPath(String string) {
        this.xpath = string;
        if (this.xpath.indexOf("[") != -1 && this.xpath.indexOf("]") == -1) {
            this.setShouldExecuteSelectNodes(true);
            return;
        }
        if (this.xpath.indexOf("::") != -1) {
            this.setShouldExecuteSelectNodes(true);
            return;
        }
        this.shortName = string;
        int n = string.indexOf(64);
        if (n == 0) {
            this.hasAttribute = true;
            this.shortName = string.substring(n + 1);
            this.indexValue = this.hasIndex(string);
            this.setupNamespaceInformation(this.shortName);
            return;
        }
        if (string.startsWith("/")) {
            this.setShouldExecuteSelectNodes(true);
            this.shortName = string;
            this.indexValue = this.hasIndex(string);
            this.setupNamespaceInformation(this.shortName);
            return;
        }
        if (string.equals(TEXT)) {
            this.nameIsText = true;
            this.shortName = string;
            return;
        }
        this.nameIsText = false;
        if (string.equals(".")) {
            this.isSelfFragment = true;
            this.shortName = string;
            return;
        }
        this.indexValue = this.hasIndex(string);
        this.setupNamespaceInformation(this.shortName);
    }

    private void setupNamespaceInformation(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            this.hasNamespace = true;
            this.localName = string.substring(n + 1);
            this.prefix = string.substring(0, n);
        } else {
            this.localName = string;
        }
    }

    public boolean isAttribute() {
        return this.hasAttribute;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = this.isSelfFragment || "".equals(string) ? null : string;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    private int hasIndex(String string) {
        int n;
        int n2 = string.lastIndexOf(91);
        if (n2 != -1 && string.lastIndexOf(93) != -1) {
            this.setContainsIndex(true);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.setShouldExecuteSelectNodes(true);
                n = -1;
            }
            this.shortName = string2;
        } else {
            n = -1;
        }
        return n;
    }

    public int getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(int n) {
        this.indexValue = n;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public boolean isSelfFragment() {
        return this.isSelfFragment;
    }

    public boolean nameIsText() {
        return this.nameIsText;
    }

    public void setHasText(boolean bl) {
        this.hasText = bl;
    }

    public boolean getHasText() {
        return this.hasText;
    }

    public void setContainsIndex(boolean bl) {
        this.containsIndex = bl;
    }

    public boolean containsIndex() {
        return this.containsIndex;
    }

    public void setShouldExecuteSelectNodes(boolean bl) {
        this.shouldExecuteSelectNodes = bl;
    }

    public boolean shouldExecuteSelectNodes() {
        return this.shouldExecuteSelectNodes;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            return (this.nameIsText && xPathFragment.nameIsText() || this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.indexValue == xPathFragment.getIndexValue() && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean qNameEquals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            return (this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (null == this.localName ? 0 : this.localName.hashCode());
        n = 31 * n + (null == this.namespaceURI ? 0 : this.namespaceURI.hashCode());
        return n;
    }

    public QName getLeafElementType() {
        return this.leafElementType;
    }

    public boolean hasLeafElementType() {
        return this.getLeafElementType() != null;
    }

    public void setLeafElementType(QName qName) {
        this.leafElementType = qName;
    }

    public void setGeneratedPrefix(boolean bl) {
        this.generatedPrefix = bl;
    }

    public boolean isGeneratedPrefix() {
        return this.generatedPrefix;
    }
}

