/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;

public class SequencedUnmarshalContext
implements UnmarshalContext {
    private static final String TEXT_XPATH = "text()";
    private Setting currentSetting;

    public void startElement(UnmarshalRecord unmarshalRecord) {
        Setting setting = null == this.currentSetting ? null : (TEXT_XPATH.equals(this.currentSetting.getName()) ? null : this.currentSetting);
        XPathFragment xPathFragment = unmarshalRecord.getXPathNode().getXPathFragment();
        this.currentSetting = null != xPathFragment ? new Setting(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName()) : new Setting();
        int n = unmarshalRecord.getLevelIndex();
        if (0 != n) {
            if (1 == n) {
                ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
            } else {
                setting.addChild(this.currentSetting);
            }
        }
    }

    public void characters(UnmarshalRecord unmarshalRecord) {
        if (null == this.currentSetting || null == this.currentSetting.getName()) {
            this.currentSetting = new Setting(null, TEXT_XPATH);
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
        } else if (!TEXT_XPATH.equals(this.currentSetting.getName())) {
            Setting setting = this.currentSetting;
            this.currentSetting = new Setting(null, TEXT_XPATH);
            if (null != setting) {
                setting.addChild(this.currentSetting);
            }
        }
    }

    public void endElement(UnmarshalRecord unmarshalRecord) {
        if (null == this.currentSetting) {
            return;
        }
        this.currentSetting = TEXT_XPATH.equals(this.currentSetting.getName()) ? (null == this.currentSetting.getParent() ? null : this.currentSetting.getParent().getParent()) : this.currentSetting.getParent();
    }

    public void setAttributeValue(UnmarshalRecord unmarshalRecord, Object object, DatabaseMapping databaseMapping) {
        this.currentSetting.setMapping(databaseMapping);
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.setValue(object);
    }

    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object object) {
        this.addAttributeValue(unmarshalRecord, containerValue, object, unmarshalRecord.getContainerInstance(containerValue));
    }

    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object object, Object object2) {
        this.currentSetting.setMapping(containerValue.getMapping());
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.addValue(object, true, object2);
    }

    public void reference(Reference reference) {
        this.currentSetting.setObject(reference.getSourceObject());
        this.currentSetting.setMapping((DatabaseMapping)((Object)reference.getMapping()));
        reference.setSetting(this.currentSetting);
    }

    public void unmappedContent(UnmarshalRecord unmarshalRecord) {
        Setting setting = this.currentSetting.getParent();
        if (null == setting) {
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().remove(this.currentSetting);
        }
        this.currentSetting = setting;
    }
}

