/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.xml.sax.SAXException;

public class AnyMappingContentHandler
extends DeferredContentHandler {
    private boolean usesXMLRoot;

    public AnyMappingContentHandler(UnmarshalRecord unmarshalRecord, boolean bl) {
        super(unmarshalRecord);
        this.usesXMLRoot = bl;
    }

    protected void processEmptyElement() throws SAXException {
        this.processSimpleElement();
    }

    protected void processSimpleElement() throws SAXException {
        if (this.usesXMLRoot) {
            this.getEvents().remove(0);
            this.executeEvents(this.getParent());
        } else {
            this.processComplexElement();
        }
    }

    protected void processComplexElement() throws SAXException {
        Object object;
        UnmappedContentHandler unmappedContentHandler;
        this.getParent().unmappedContent();
        Class clazz = this.getParent().getUnmarshaller().getUnmappedContentHandlerClass();
        if (null == clazz) {
            unmappedContentHandler = UnmarshalRecord.DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                object = new PrivilegedNewInstanceFromClass(clazz);
                unmappedContentHandler = (UnmappedContentHandler)((PrivilegedNewInstanceFromClass)object).run();
            }
            catch (ClassCastException classCastException) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(classCastException, clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(illegalAccessException, clazz.getName());
            }
            catch (InstantiationException instantiationException) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(instantiationException, clazz.getName());
            }
        }
        object = new UnmappedContentHandlerWrapper(this.getParent(), unmappedContentHandler);
        this.executeEvents((UnmarshalRecord)object);
    }
}

