/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;

public class ListContainerPolicy
extends CollectionContainerPolicy {
    public ListContainerPolicy() {
    }

    public ListContainerPolicy(Class clazz) {
        super(clazz);
    }

    public ListContainerPolicy(String string) {
        super(string);
    }

    public Object get(int n, Object object, AbstractSession abstractSession) {
        if (n < 0 || n >= this.sizeFor(object)) {
            return null;
        }
        Object object2 = ((List)object).get(n);
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object2, abstractSession);
        }
        return object2;
    }

    public boolean isValidContainer(Object object) {
        return object instanceof List;
    }

    public boolean hasOrder() {
        return true;
    }

    public boolean isListPolicy() {
        return true;
    }

    public int indexOf(Object object, Object object2, AbstractSession abstractSession) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            int n = -1;
            Object object3 = this.iteratorFor(object2);
            while (this.hasNext(object3)) {
                ++n;
                Object object4 = this.next(object3);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object4, abstractSession).equals(object)) continue;
                return n;
            }
            return -1;
        }
        return ((List)object2).indexOf(object);
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getRemoveObjectList().remove(objectChangeSet);
        } else if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getAddOverFlow().add(objectChangeSet);
        } else {
            collectionChangeRecord.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            if (collectionChangeRecord.getAddOverFlow().contains(objectChangeSet)) {
                collectionChangeRecord.getAddOverFlow().remove(objectChangeSet);
            } else {
                collectionChangeRecord.getAddObjectList().remove(objectChangeSet);
            }
        } else {
            collectionChangeRecord.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void removeFromWithOrder(int n, Object object) {
        int n2;
        try {
            for (n2 = this.sizeFor(object) - 1; n2 >= n; --n2) {
                ((List)object).remove(n2);
            }
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
    }
}

