/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.QueryCounter;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.history.HistoricalSession;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.EmptyRecord;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.SessionFinalizer;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventManager;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.server.ClientSession;

public abstract class AbstractSession
implements Session,
CommandProcessor,
Serializable,
Cloneable {
    protected transient ExceptionHandler exceptionHandler;
    protected transient IntegrityChecker integrityChecker;
    protected transient Project project;
    protected transient ConcurrencyManager transactionMutex;
    protected IdentityMapAccessor identityMapAccessor;
    protected boolean wasJTSTransactionInternallyStarted;
    protected transient Accessor accessor;
    protected transient Platform platform;
    protected transient Map queries;
    protected transient List jpaQueries;
    protected transient CommitManager commitManager;
    protected transient SessionProfiler profiler;
    protected transient AbstractSession broker;
    protected String name;
    protected transient int numberOfActiveUnitsOfWork;
    protected transient SessionLog sessionLog;
    protected transient String logSessionString;
    protected transient SessionEventManager eventManager;
    protected Map properties;
    protected transient ExternalTransactionController externalTransactionController;
    protected transient ClassDescriptor lastDescriptorAccessed;
    protected boolean isInBroker;
    protected transient CommandManager commandManager;
    protected boolean shouldPropagateChanges;
    protected boolean isInProfile;
    protected boolean isLoggingOff;
    protected boolean isFinalizersEnabled = false;
    protected ExposedNodeLinkedList activeCommandThreads;
    protected boolean isSynchronized;
    protected ReferenceMode defaultReferenceMode = null;
    protected Integer pessimisticLockTimeoutDefault;
    protected int queryTimeoutDefault;

    protected AbstractSession() {
        this.name = "";
        this.initializeIdentityMapAccessor();
        this.numberOfActiveUnitsOfWork = 0;
        this.isInBroker = false;
        this.isSynchronized = false;
    }

    protected AbstractSession(int n) {
    }

    public AbstractSession(Login login) {
        this(new Project(login));
    }

    public AbstractSession(Project project) {
        this();
        this.project = project;
        if (project.getDatasourceLogin() == null) {
            throw ValidationException.projectLoginIsNull(this);
        }
        for (DatabaseQuery databaseQuery : project.getQueries()) {
            this.addQuery(databaseQuery.getName(), databaseQuery);
        }
    }

    public boolean isLoggingOff() {
        return this.isLoggingOff;
    }

    public long getNextQueryId() {
        return QueryCounter.getCount();
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork() {
        return this.acquireNonSynchronizedUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork(ReferenceMode referenceMode) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        UnitOfWorkImpl unitOfWorkImpl = new UnitOfWorkImpl(this, referenceMode);
        if (this.shouldLog(2, "transaction")) {
            this.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(unitOfWorkImpl)));
        }
        return unitOfWorkImpl;
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        if (asOfClause == null || asOfClause.getValue() == null) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        if (!(this.getProject().hasGenericHistorySupport() || this.hasBroker() || this.getPlatform() != null && this.getPlatform().isOracle())) {
            throw ValidationException.historicalSessionOnlySupportedOnOracle();
        }
        return new HistoricalSession(this, asOfClause);
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl unitOfWorkImpl = this.acquireNonSynchronizedUnitOfWork(this.getDefaultReferenceMode());
        unitOfWorkImpl.registerWithTransactionIfRequired();
        return unitOfWorkImpl;
    }

    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        UnitOfWorkImpl unitOfWorkImpl = this.acquireNonSynchronizedUnitOfWork(referenceMode);
        unitOfWorkImpl.registerWithTransactionIfRequired();
        return unitOfWorkImpl;
    }

    public void addAlias(String string, ClassDescriptor classDescriptor) {
        this.project.addAlias(string, classDescriptor);
    }

    public void addQuery(String string, DatabaseQuery databaseQuery) {
        databaseQuery.setName(string);
        this.addQuery(databaseQuery);
    }

    public void addJPAQuery(DatabaseQuery databaseQuery) {
        this.getJPAQueries().add(databaseQuery);
    }

    protected void addQuery(DatabaseQuery databaseQuery) {
        Vector vector = (Vector)this.getQueries().get(databaseQuery.getName());
        if (vector == null) {
            vector = NonSynchronizedVector.newInstance();
            this.getQueries().put(databaseQuery.getName(), vector);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery2 = (DatabaseQuery)enumeration.nextElement();
            if (!Helper.areTypesAssignable(databaseQuery.getArgumentTypes(), databaseQuery2.getArgumentTypes())) continue;
            throw ValidationException.existingQueryTypeConflict(databaseQuery, databaseQuery2);
        }
        vector.add(databaseQuery);
    }

    protected void basicBeginTransaction() throws DatabaseException {
        this.basicBeginTransaction(0);
    }

    protected void basicBeginTransaction(int n) throws DatabaseException {
        try {
            this.getAccessor().beginTransaction(this);
        }
        catch (DatabaseException databaseException) {
            if (!this.getLogin().shouldUseExternalTransactionController() && databaseException.isCommunicationFailure()) {
                DatabaseException databaseException2 = databaseException;
                this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                while (n < this.getLogin().getQueryRetryAttemptCount()) {
                    try {
                        databaseException.getAccessor().reestablishConnection(this);
                    }
                    catch (DatabaseException databaseException3) {
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                            this.log(5, "communication_failure_attempting_begintransaction_retry", (Object[])null, null);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
                if (n <= this.getLogin().getQueryRetryAttemptCount()) {
                    try {
                        ++n;
                        try {
                            if (n > 1) {
                                Thread.currentThread();
                                Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                            }
                            this.basicBeginTransaction(n);
                            return;
                        }
                        catch (DatabaseException databaseException4) {
                            databaseException2 = databaseException4;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.handleException(databaseException2);
            }
            this.handleException(databaseException);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public void releaseJTSConnection() {
    }

    protected void basicCommitTransaction() throws DatabaseException {
        try {
            this.getAccessor().commitTransaction(this);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        try {
            this.getAccessor().rollbackTransaction(this);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public boolean beginExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && !this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().beginTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_begun_internally");
            }
        }
        return bl;
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.isInTransaction()) {
            this.beginExternalTransaction();
        }
        if (this.isClientSession()) {
            this.getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        this.getTransactionMutex().acquire();
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preBeginTransaction();
            this.basicBeginTransaction();
            this.getEventManager().postBeginTransaction();
        }
    }

    protected ClassDescriptor checkHierarchyForDescriptor(Class clazz) {
        return this.getDescriptor(clazz.getSuperclass());
    }

    public void clearIntegrityChecker() {
        this.setIntegrityChecker(null);
    }

    public void clearLastDescriptorAccessed() {
        this.lastDescriptorAccessed = null;
    }

    public void clearProfile() {
        this.setProfiler(null);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean commitExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().commitTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_committed_internally");
            }
        }
        return bl;
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preCommitTransaction();
            this.basicCommitTransaction();
            this.getEventManager().postCommitTransaction();
        }
        this.getTransactionMutex().release();
        if (!this.isInTransaction()) {
            this.commitExternalTransaction();
        }
    }

    public boolean compareObjects(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(object.getClass()).getObjectBuilder();
        return objectBuilder.compareObjects(objectBuilder.unwrapObject(object, this), objectBuilder.unwrapObject(object2, this), this);
    }

    public boolean compareObjectsDontMatch(Object object, Object object2) {
        return !this.compareObjects(object, object2);
    }

    public boolean containsQuery(String string) {
        return this.getQueries().containsKey(string);
    }

    public Object copyObject(Object object) {
        return this.copyObject(object, new ObjectCopyingPolicy());
    }

    public Object copyObject(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            return object;
        }
        objectCopyingPolicy.setSession(this);
        return classDescriptor.getObjectBuilder().copyObject(object, objectCopyingPolicy);
    }

    public Vector copyReadOnlyClasses() {
        return this.getDefaultReadOnlyClasses();
    }

    public void deleteAllObjects(Collection collection) throws DatabaseException, OptimisticLockException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.deleteObject(iterator.next());
        }
    }

    public void deleteAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.deleteObject(enumeration.nextElement());
        }
    }

    public Object deleteObject(Object object) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setObject(object);
        deleteObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(deleteObjectQuery);
    }

    public boolean doesObjectExist(Object object) throws DatabaseException {
        DoesExistQuery doesExistQuery = new DoesExistQuery();
        doesExistQuery.setObject(object);
        doesExistQuery.checkDatabaseForDoesExist();
        doesExistQuery.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(doesExistQuery);
    }

    public void dontLogMessages() {
        this.setLogLevel(8);
    }

    public void endOperationProfile(String string) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(string);
        }
    }

    public void endOperationProfile(String string, DatabaseQuery databaseQuery, int n) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(string, databaseQuery, n);
        }
    }

    public void updateProfile(String string, Object object) {
        if (this.isInProfile()) {
            this.getProfiler().update(string, object);
        }
    }

    public void incrementProfile(String string) {
        if (this.isInProfile()) {
            this.getProfiler().occurred(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord abstractRecord, DatabaseQuery databaseQuery) throws DatabaseException {
        if (databaseQuery.getAccessor() == null) {
            databaseQuery.setAccessor(this.getAccessor());
        }
        try {
            Object object = databaseQuery.getAccessor().executeCall(call, abstractRecord, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                databaseQuery.setAccessor(null);
            }
        }
    }

    public int executeNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setIsExecutionClone(true);
        dataModifyQuery.setCall(call);
        Integer n = (Integer)this.executeQuery(dataModifyQuery);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void executeNonSelectingSQL(String string) throws DatabaseException {
        this.executeNonSelectingCall(new SQLCall(string));
    }

    public Object executeQuery(String string) throws DatabaseException {
        DatabaseQuery databaseQuery = this.getQuery(string);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string);
        }
        return this.executeQuery(databaseQuery);
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        if (classDescriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(clazz, string);
        }
        DatabaseQuery databaseQuery = classDescriptor.getQueryManager().getQuery(string);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string, clazz);
        }
        return this.executeQuery(databaseQuery);
    }

    public Object executeQuery(String string, Class clazz, Object object) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, Object object, Object object2) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, Object object, Object object2, Object object3) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, List list) throws DatabaseException {
        if (list instanceof Vector) {
            return this.executeQuery(string, clazz, (Vector)list);
        }
        return this.executeQuery(string, clazz, new Vector(list));
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        if (classDescriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(clazz, string);
        }
        DatabaseQuery databaseQuery = classDescriptor.getQueryManager().getQuery(string, vector);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string, clazz);
        }
        return this.executeQuery(databaseQuery, (List)vector);
    }

    public Object executeQuery(String string, Object object) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, Object object, Object object2) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, Object object, Object object2, Object object3) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, List list) throws DatabaseException {
        if (list instanceof Vector) {
            return this.executeQuery(string, (Vector)list);
        }
        return this.executeQuery(string, new Vector(list));
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        DatabaseQuery databaseQuery = this.getQuery(string, vector);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string);
        }
        return this.executeQuery(databaseQuery, (List)vector);
    }

    public Object executeQuery(DatabaseQuery databaseQuery) throws DatabaseException {
        return this.executeQuery(databaseQuery, EmptyRecord.getEmptyRecord());
    }

    public Object executeQuery(DatabaseQuery databaseQuery, List list) throws DatabaseException {
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined();
        }
        AbstractRecord abstractRecord = databaseQuery.rowFromArguments(list);
        return this.executeQuery(databaseQuery, abstractRecord);
    }

    public Object executeQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException {
        if (this.hasBroker() && (!databaseQuery.isDataModifyQuery() && !databaseQuery.isDataReadQuery() || databaseQuery.getSessionName() != null)) {
            return this.getBroker().executeQuery(databaseQuery, abstractRecord);
        }
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined();
        }
        this.log(1, "query", "execute_query", databaseQuery);
        return this.executeQuery(databaseQuery, abstractRecord, 0);
    }

    public Object executeQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, int n) throws DatabaseException {
        try {
            this.getEventManager().preExecuteQuery(databaseQuery);
            Object object = this.isInProfile() ? this.getProfiler().profileExecutionOfQuery(databaseQuery, abstractRecord, this) : this.internalExecuteQuery(databaseQuery, abstractRecord);
            this.getEventManager().postExecuteQuery(databaseQuery, object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            DatabaseException databaseException;
            if (runtimeException instanceof QueryException) {
                QueryException queryException = (QueryException)runtimeException;
                if (queryException.getQuery() == null) {
                    queryException.setQuery(databaseQuery);
                }
                if (queryException.getQueryArgumentsRecord() == null) {
                    queryException.setQueryArguments(abstractRecord);
                }
                if (queryException.getSession() == null) {
                    queryException.setSession(this);
                }
            } else if (runtimeException instanceof DatabaseException) {
                DatabaseException databaseException2 = (DatabaseException)runtimeException;
                if (databaseException2.getQuery() == null) {
                    databaseException2.setQuery(databaseQuery);
                }
                if (databaseException2.getQueryArgumentsRecord() == null) {
                    databaseException2.setQueryArguments(abstractRecord);
                }
                if (databaseException2.getSession() == null) {
                    databaseException2.setSession(this);
                }
                if (!this.isInTransaction() && databaseQuery.isReadQuery() && databaseException2.isCommunicationFailure()) {
                    this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                    if (this.isDatabaseSession()) {
                        while (n < this.getLogin().getQueryRetryAttemptCount()) {
                            try {
                                databaseException2.getAccessor().reestablishConnection(this);
                            }
                            catch (DatabaseException databaseException3) {
                                ++n;
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                                    this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break;
                        }
                    }
                    if (n <= this.getLogin().getQueryRetryAttemptCount()) {
                        try {
                            ++n;
                            try {
                                if (n > 1) {
                                    Thread.currentThread();
                                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                                }
                                return this.executeQuery(databaseQuery, abstractRecord, n);
                            }
                            catch (DatabaseException databaseException4) {
                                databaseException = databaseException4;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.handleException(databaseException);
        }
    }

    public Vector executeSelectingCall(Call call) throws DatabaseException {
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setCall(call);
        dataReadQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(dataReadQuery);
    }

    public Vector executeSQL(String string) throws DatabaseException {
        return this.executeSelectingCall(new SQLCall(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessor getAccessor() {
        if (this.accessor == null && this.project != null && this.project.getDatasourceLogin() != null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.accessor == null && this.project != null && this.project.getDatasourceLogin() != null) {
                    this.accessor = this.project.getDatasourceLogin().buildAccessor();
                }
            }
        }
        return this.accessor;
    }

    public Accessor getAccessor(Class clazz) {
        return this.getAccessor();
    }

    public Accessor getAccessor(String string) {
        return this.getAccessor();
    }

    public ExposedNodeLinkedList getActiveCommandThreads() {
        if (this.activeCommandThreads == null) {
            this.activeCommandThreads = new ExposedNodeLinkedList();
        }
        return this.activeCommandThreads;
    }

    public Session getActiveSession() {
        Session session = this.getActiveUnitOfWork();
        if (session == null) {
            session = this;
        }
        return session;
    }

    public UnitOfWork getActiveUnitOfWork() {
        if (this.hasExternalTransactionController()) {
            return this.getExternalTransactionController().getActiveUnitOfWork();
        }
        if (this.isClientSession()) {
            return ((ClientSession)this).getParent().getActiveUnitOfWork();
        }
        return null;
    }

    public Map getAliasDescriptors() {
        return this.project.getAliasDescriptors();
    }

    public AsOfClause getAsOfClause() {
        return null;
    }

    public AbstractSession getBroker() {
        return this.broker;
    }

    public AbstractSession getRootSession(DatabaseQuery databaseQuery) {
        return this.getParentIdentityMapSession(databaseQuery, false, true);
    }

    public AbstractSession getParent() {
        return null;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery) {
        return this.getParentIdentityMapSession(databaseQuery, false, false);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        return this;
    }

    public Integer getPessimisticLockTimeoutDefault() {
        return this.pessimisticLockTimeoutDefault;
    }

    public int getQueryTimeoutDefault() {
        return this.queryTimeoutDefault;
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        return this;
    }

    public boolean hasCommitManager() {
        return this.commitManager != null;
    }

    public CommitManager getCommitManager() {
        if (this.hasBroker()) {
            return this.getBroker().getCommitManager();
        }
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
        }
        return this.commitManager;
    }

    public Vector getDefaultReadOnlyClasses() {
        if (this.hasBroker()) {
            return this.getBroker().getDefaultReadOnlyClasses();
        }
        return this.getProject().getDefaultReadOnlyClasses();
    }

    public ClassDescriptor getClassDescriptor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.getDescriptor(clazz);
    }

    public ClassDescriptor getClassDescriptor(Object object) {
        if (object == null) {
            return null;
        }
        return this.getDescriptor(object);
    }

    public ClassDescriptor getClassDescriptorForAlias(String string) {
        return this.project.getDescriptorForAlias(string);
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.lastDescriptorAccessed;
        if (classDescriptor != null && classDescriptor.getJavaClass() == clazz) {
            return classDescriptor;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)this.project.getDescriptors().get(clazz);
        if (classDescriptor2 == null && this.hasBroker()) {
            classDescriptor2 = this.getBroker().getDescriptor(clazz);
        }
        if (classDescriptor2 == null) {
            this.getEventManager().missingDescriptor(clazz);
            classDescriptor2 = (ClassDescriptor)this.getDescriptors().get(clazz);
        }
        if (classDescriptor2 == null && !clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                classDescriptor2 = this.getDescriptor(clazz2);
                if (classDescriptor2 == null) continue;
                this.getDescriptors().put(clazz2, classDescriptor2);
                break;
            }
            if (classDescriptor2 == null) {
                classDescriptor2 = this.checkHierarchyForDescriptor(clazz);
            }
        }
        this.lastDescriptorAccessed = classDescriptor2;
        return classDescriptor2;
    }

    public ClassDescriptor getDescriptor(Object object) {
        if (object == null) {
            return null;
        }
        if (this.project.hasProxyIndirection()) {
            return this.getDescriptor(ProxyIndirectionPolicy.getValueFromProxy(object).getClass());
        }
        return this.getDescriptor(object.getClass());
    }

    public ClassDescriptor getDescriptorForAlias(String string) {
        return this.project.getDescriptorForAlias(string);
    }

    public Map getDescriptors() {
        return this.project.getDescriptors();
    }

    public List getJPAQueries() {
        if (this.jpaQueries == null) {
            this.jpaQueries = new Vector();
        }
        return this.jpaQueries;
    }

    public void processJPAQueries() {
        List list = this.getJPAQueries();
        for (DatabaseQuery databaseQuery : list) {
            databaseQuery.checkPrepare(this, null);
            DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.getProperty("databasequery");
            this.addQuery(databaseQuery2.getName(), databaseQuery2);
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionEventManager getEventManager() {
        if (this.eventManager == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.eventManager == null) {
                    this.eventManager = new SessionEventManager(this);
                }
            }
        }
        return this.eventManager;
    }

    public String getExceptionHandlerClass() {
        String string = null;
        try {
            string = this.getExceptionHandler().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ExternalTransactionController getExternalTransactionController() {
        return this.externalTransactionController;
    }

    public org.eclipse.persistence.sessions.IdentityMapAccessor getIdentityMapAccessor() {
        return this.identityMapAccessor;
    }

    public IdentityMapAccessor getIdentityMapAccessorInstance() {
        return this.identityMapAccessor;
    }

    public IntegrityChecker getIntegrityChecker() {
        if (this.integrityChecker == null) {
            this.integrityChecker = new IntegrityChecker();
        }
        return this.integrityChecker;
    }

    public Writer getLog() {
        return this.getSessionLog().getWriter();
    }

    public String getLogSessionString() {
        if (this.logSessionString == null) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(this.getSessionTypeString());
            stringWriter.write("(");
            stringWriter.write(String.valueOf(System.identityHashCode(this)));
            stringWriter.write(")");
            this.logSessionString = stringWriter.toString();
        }
        return this.logSessionString;
    }

    public String getSessionTypeString() {
        return Helper.getShortClassName(this.getClass());
    }

    public DatabaseLogin getLogin() {
        try {
            return (DatabaseLogin)this.getDatasourceLogin();
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    public Login getDatasourceLogin() {
        return this.getProject().getDatasourceLogin();
    }

    public String getName() {
        return this.name;
    }

    public Number getNextSequenceNumberValue(Class clazz) {
        return (Number)this.getSequencing().getNextValue(clazz);
    }

    public int getNumberOfActiveUnitsOfWork() {
        return this.numberOfActiveUnitsOfWork;
    }

    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getPlatform();
        }
        return (DatabasePlatform)this.platform;
    }

    public ClassLoader getLoader() {
        return this.getDatasourcePlatform().getConversionManager().getLoader();
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getDatasourcePlatform();
        }
        return this.platform;
    }

    public ServerPlatform getServerPlatform() {
        return null;
    }

    public Platform getPlatform(Class clazz) {
        if (this.platform == null) {
            this.platform = this.getDatasourcePlatform();
        }
        return this.platform;
    }

    public SessionProfiler getProfiler() {
        return this.profiler;
    }

    public Project getProject() {
        return this.project;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(string);
    }

    public Map getQueries() {
        if (this.queries == null) {
            this.queries = new HashMap(5);
        }
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector vector = new Vector();
        Iterator iterator = this.getQueries().values().iterator();
        while (iterator.hasNext()) {
            vector.addAll((Vector)iterator.next());
        }
        return vector;
    }

    public DatabaseQuery getQuery(String string) {
        return this.getQuery(string, null);
    }

    public DatabaseQuery getQuery(String string, List list) {
        if (list instanceof Vector) {
            return this.getQuery(string, (Vector)list);
        }
        return this.getQuery(string, new Vector(list));
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null || vector2.isEmpty()) {
            return null;
        }
        if (vector2.size() == 1) {
            return (DatabaseQuery)vector2.firstElement();
        }
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        Vector vector3 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            vector3.addElement(vector.elementAt(i).getClass());
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            if (!Helper.areTypesAssignable(vector3, databaseQuery.getArgumentTypes())) continue;
            return databaseQuery;
        }
        return null;
    }

    public Sequencing getSequencing() {
        return null;
    }

    public AbstractSession getSessionForClass(Class clazz) {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForClass(clazz);
        }
        return this;
    }

    public SessionLog getSessionLog() {
        if (this.sessionLog == null) {
            this.setSessionLog(new DefaultSessionLog());
        }
        return this.sessionLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getTransactionMutex() {
        if (this.transactionMutex == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.transactionMutex == null) {
                    this.transactionMutex = new ConcurrencyManager();
                }
            }
        }
        return this.transactionMutex;
    }

    public Object handleException(RuntimeException runtimeException) throws RuntimeException {
        if (runtimeException instanceof EclipseLinkException) {
            EclipseLinkException eclipseLinkException = (EclipseLinkException)runtimeException;
            if (eclipseLinkException.getSession() == null) {
                eclipseLinkException.setSession(this);
            }
            if (!eclipseLinkException.hasBeenLogged()) {
                this.logThrowable(6, null, runtimeException);
                eclipseLinkException.setHasBeenLogged(true);
            }
        } else {
            this.logThrowable(6, null, runtimeException);
        }
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(runtimeException);
        }
        throw runtimeException;
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    public boolean hasDescriptor(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.getDescriptors().get(clazz) != null;
    }

    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    public boolean hasExternalTransactionController() {
        return this.externalTransactionController != null;
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object insertObject(Object object) throws DatabaseException {
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setObject(object);
        insertObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(insertObjectQuery);
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException {
        return databaseQuery.execute(this, abstractRecord);
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isInBroker() {
        return this.isInBroker;
    }

    public boolean isClassReadOnly(Class clazz) {
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        return this.isClassReadOnly(clazz, classDescriptor);
    }

    public boolean isClassReadOnly(Class clazz, ClassDescriptor classDescriptor) {
        if (classDescriptor != null && classDescriptor.shouldBeReadOnly()) {
            return true;
        }
        if (clazz != null) {
            return this.getDefaultReadOnlyClasses().contains(clazz);
        }
        return false;
    }

    public boolean isClientSession() {
        return false;
    }

    public boolean isIsolatedClientSession() {
        return false;
    }

    public boolean isExclusiveIsolatedClientSession() {
        return false;
    }

    public boolean isConnected() {
        if (this.getAccessor() == null) {
            return false;
        }
        return this.getAccessor().isConnected();
    }

    public boolean isDatabaseSession() {
        return false;
    }

    public boolean isDistributedSession() {
        return false;
    }

    public boolean isInProfile() {
        return this.isInProfile;
    }

    public void setIsInProfile(boolean bl) {
        this.isInProfile = bl;
    }

    public void setIsInBroker(boolean bl) {
        this.isInBroker = bl;
    }

    public boolean isFinalizersEnabled() {
        return this.isFinalizersEnabled;
    }

    public void registerFinalizer() {
        this.setProperty("finalizer", new SessionFinalizer(this));
    }

    public boolean isHistoricalSession() {
        return false;
    }

    public void setIsFinalizersEnabled(boolean bl) {
        this.isFinalizersEnabled = bl;
    }

    public boolean isInTransaction() {
        return this.getTransactionMutex().isAcquired();
    }

    public boolean isRemoteSession() {
        return false;
    }

    public boolean isRemoteUnitOfWork() {
        return false;
    }

    public boolean isServerSession() {
        return false;
    }

    public boolean isSessionBroker() {
        return false;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isUnitOfWork() {
        return false;
    }

    public Vector keyFromObject(Object object) throws ValidationException {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        return this.keyFromObject(object, classDescriptor);
    }

    public Vector keyFromObject(Object object, ClassDescriptor classDescriptor) throws ValidationException {
        if (classDescriptor == null) {
            throw ValidationException.missingDescriptor(object.getClass().getName());
        }
        Object object2 = classDescriptor.getObjectBuilder().unwrapObject(object, this);
        if (object2 == null) {
            return null;
        }
        return classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, this);
    }

    public void log(SessionLogEntry sessionLogEntry) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            if (sessionLogEntry.getSession() == null) {
                sessionLogEntry.setSession(this);
            }
            this.getSessionLog().log(sessionLogEntry);
        }
    }

    public void logMessage(String string) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, string, (Object[])null, null, false);
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery databaseQuery) {
        if (!this.isUnitOfWork() && databaseQuery.isObjectLevelReadQuery()) {
            return ((ObjectLevelReadQuery)databaseQuery).prepareOutsideUnitOfWork(this);
        }
        return databaseQuery;
    }

    public Vector readAllObjects(Class clazz) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setIsExecutionClone(true);
        readAllQuery.setReferenceClass(clazz);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, String string) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setSQLString(string);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, Call call) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setCall(call);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, Expression expression) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setSelectionCriteria(expression);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Object readObject(Class clazz) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, String string) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSQLString(string);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, Call call) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setCall(call);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, Expression expression) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSelectionCriteria(expression);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Object object) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionObject(object);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object refreshAndLockObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)1);
    }

    public Object refreshAndLockObject(Object object, short s) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionObject(object);
        readObjectQuery.refreshIdentityMapResult();
        readObjectQuery.cascadePrivateParts();
        readObjectQuery.setLockMode(s);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object refreshObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)0);
    }

    public void release() {
    }

    public void releaseUnitOfWork(UnitOfWorkImpl unitOfWorkImpl) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() - 1);
    }

    public void removeProperty(String string) {
        this.getProperties().remove(string);
    }

    public void removeQuery(String string) {
        this.getQueries().remove(string);
    }

    public void removeQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null) {
            return;
        }
        DatabaseQuery databaseQuery = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements() && !Helper.areTypesAssignable(vector, (databaseQuery = (DatabaseQuery)enumeration.nextElement()).getArgumentTypes())) {
        }
        if (databaseQuery != null) {
            vector2.remove(databaseQuery);
        }
    }

    protected boolean rollbackExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().rollbackTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_rolled_back_internally");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        try {
            if (!this.getTransactionMutex().isNested()) {
                this.getEventManager().preRollbackTransaction();
                this.basicRollbackTransaction();
                this.getEventManager().postRollbackTransaction();
            }
        }
        finally {
            this.getTransactionMutex().release();
            if (!this.isInTransaction()) {
                this.rollbackExternalTransaction();
            }
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setBroker(AbstractSession abstractSession) {
        this.broker = abstractSession;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public void setEventManager(SessionEventManager sessionEventManager) {
        this.eventManager = sessionEventManager != null ? sessionEventManager : new SessionEventManager();
        this.eventManager.setSession(this);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        this.externalTransactionController = externalTransactionController;
        if (externalTransactionController == null) {
            return;
        }
        externalTransactionController.setSession(this);
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public void setLog(Writer writer) {
        this.getSessionLog().setWriter(writer);
    }

    public void setLogin(DatabaseLogin databaseLogin) {
        this.setDatasourceLogin(databaseLogin);
    }

    public void setLogin(Login login) {
        this.setDatasourceLogin(login);
    }

    public void setDatasourceLogin(Login login) {
        this.getProject().setDatasourceLogin(login);
        this.platform = null;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setNumberOfActiveUnitsOfWork(int n) {
        this.numberOfActiveUnitsOfWork = n;
    }

    public void setPessimisticLockTimeoutDefault(Integer n) {
        this.pessimisticLockTimeoutDefault = n;
    }

    public void setQueryTimeoutDefault(int n) {
        this.queryTimeoutDefault = n;
    }

    public void setProfiler(SessionProfiler sessionProfiler) {
        this.profiler = sessionProfiler;
        if (sessionProfiler != null) {
            sessionProfiler.setSession(this);
            this.setIsInProfile(this.getProfiler().getProfileWeight() != 0);
            this.getIdentityMapAccessorInstance().getIdentityMapManager().clearCacheAccessPreCheck();
        } else {
            this.setIsInProfile(false);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Map map) {
        if (null == map) {
            this.properties = map;
        } else {
            this.properties = new HashMap();
            this.properties.putAll(map);
        }
    }

    public void setProperty(String string, Object object) {
        this.getProperties().put(string, object);
    }

    protected void setQueries(Map map) {
        this.queries = map;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.isLoggingOff = false;
        this.sessionLog = sessionLog;
        if (sessionLog != null && sessionLog.getSession() == null) {
            sessionLog.setSession(this);
        }
    }

    public void setSynchronized(boolean bl) {
        this.isSynchronized = bl;
    }

    protected void setTransactionMutex(ConcurrencyManager concurrencyManager) {
        this.transactionMutex = concurrencyManager;
    }

    public void setWasJTSTransactionInternallyStarted(boolean bl) {
        this.wasJTSTransactionInternallyStarted = bl;
    }

    public boolean shouldLogMessages() {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getLogLevel(null) != 8;
    }

    public void startOperationProfile(String string) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(string);
        }
    }

    public void startOperationProfile(String string, DatabaseQuery databaseQuery, int n) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(string, databaseQuery, n);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString() + "(" + Helper.cr() + "\t" + this.getAccessor() + Helper.cr() + "\t" + this.getDatasourcePlatform() + ")");
        return stringWriter.toString();
    }

    public Object unwrapObject(Object object) {
        return this.getDescriptor(object).getObjectBuilder().unwrapObject(object, this);
    }

    public Object updateObject(Object object) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setObject(object);
        updateObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(updateObjectQuery);
    }

    public void validateCache() {
        this.getIdentityMapAccessorInstance().validateCache();
    }

    public void validateQuery(DatabaseQuery databaseQuery) {
    }

    public boolean verifyDelete(Object object) {
        ObjectBuilder objectBuilder = this.getDescriptor(object).getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        return objectBuilder.verifyDelete(object2, this);
    }

    public boolean wasJTSTransactionInternallyStarted() {
        return this.wasJTSTransactionInternallyStarted;
    }

    public Object wrapObject(Object object) {
        return this.getDescriptor(object).getObjectBuilder().wrapObject(object, this);
    }

    protected void writeAllObjectsWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjectsWithChangeSet(unitOfWorkChangeSet);
    }

    public Object writeObject(Object object) throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = new WriteObjectQuery();
        writeObjectQuery.setObject(object);
        writeObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(writeObjectQuery);
    }

    public void writesCompleted() {
        this.getAccessor().writesCompleted(this);
    }

    public void processCommand(Object object) {
        ((Command)object).executeWithSession(this);
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setCommandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public boolean shouldPropagateChanges() {
        return this.shouldPropagateChanges;
    }

    public void setShouldPropagateChanges(boolean bl) {
        this.shouldPropagateChanges = bl;
    }

    public boolean shouldLogMessages(int n) {
        if (this.isLoggingOff) {
            return false;
        }
        if (1 == n) {
            return this.getLogLevel("propagation") <= 7;
        }
        if (2 == n) {
            return this.getLogLevel("propagation") <= 6;
        }
        if (3 == n) {
            return this.getLogLevel("propagation") <= 2;
        }
        if (4 == n) {
            return this.getLogLevel("propagation") <= 1;
        }
        return false;
    }

    public void logMessage(int n, String string) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLogMessages(n)) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 7;
                    break;
                }
                case 2: {
                    n2 = 6;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 1;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.log(n2, string, null, null, false);
        }
    }

    public int getLogLevel(String string) {
        return this.getSessionLog().getLevel(string);
    }

    public int getLogLevel() {
        return this.getSessionLog().getLevel();
    }

    public void setLogLevel(int n) {
        this.isLoggingOff = false;
        this.getSessionLog().setLevel(n);
    }

    public boolean shouldLog(int n, String string) {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getSessionLog().shouldLog(n, string);
    }

    public void log(int n, String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, (Object[])null);
    }

    public void log(int n, String string, String string2, Object object) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object});
    }

    public void log(int n, String string, String string2, Object object, Object object2) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object, object2});
    }

    public void log(int n, String string, String string2, Object object, Object object2, Object object3) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object, object2, object3});
    }

    public void log(int n, String string, String string2, Object[] objectArray) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(n, string, string2, objectArray, null);
    }

    public void log(int n, String string, String string2, Object[] objectArray, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(n, string, string2, objectArray, accessor, true);
    }

    public void log(int n, String string, String string2, Object[] objectArray, Accessor accessor, boolean bl) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(n, string)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(n, string, this, string2, objectArray, accessor, bl));
            this.endOperationProfile("logging");
        }
    }

    public void log(int n, String string, Object[] objectArray, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(n, string, objectArray, accessor, true);
    }

    public void log(int n, String string, Object[] objectArray, Accessor accessor, boolean bl) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(n, null)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(n, this, string, objectArray, accessor, bl));
            this.endOperationProfile("logging");
        }
    }

    public void logThrowable(int n, String string, Throwable throwable) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(n, string)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(this, n, string, throwable));
            this.endOperationProfile("logging");
        }
    }

    public void severe(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(7, string2, string);
    }

    public void warning(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(6, string2, string);
    }

    public void info(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(5, string2, string);
    }

    public void config(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(4, string2, string);
    }

    public void fine(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(3, string2, string);
    }

    public void finer(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, string2, string);
    }

    public void finest(String string, String string2) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(1, string2, string);
    }

    public Object handleSevere(RuntimeException runtimeException) throws RuntimeException {
        this.logThrowable(7, null, runtimeException);
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(runtimeException);
        }
        throw runtimeException;
    }

    public void releaseReadConnection(Accessor accessor) {
    }

    public void copyDescriptorNamedQueries(boolean bl) {
        Vector vector = this.getProject().getOrderedDescriptors();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Map map = ((ClassDescriptor)iterator.next()).getQueryManager().getQueries();
            if (map == null || map.size() <= 0) continue;
            for (Map.Entry entry : map.entrySet()) {
                Vector vector2 = (Vector)entry.getValue();
                if (vector2 == null || vector2.size() <= 0) continue;
                for (DatabaseQuery databaseQuery : vector2) {
                    if (bl) {
                        this.addQuery(databaseQuery);
                        continue;
                    }
                    if (this.getQuery(databaseQuery.getName()) == null) {
                        this.addQuery(databaseQuery);
                        continue;
                    }
                    this.log(6, "properties", "descriptor_named_query_cannot_be_added", new Object[]{databaseQuery, databaseQuery.getName(), databaseQuery.getArgumentTypes()});
                }
            }
        }
    }

    public void postConnectExternalConnection(Accessor accessor) {
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
    }

    public boolean isExclusiveConnectionRequired() {
        return false;
    }

    public ReferenceMode getDefaultReferenceMode() {
        return this.defaultReferenceMode;
    }

    public void setDefaultReferenceMode(ReferenceMode referenceMode) {
        this.defaultReferenceMode = referenceMode;
    }
}

