/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public abstract class AbstractCompositeObjectMapping
extends AggregateMapping {
    protected DatabaseField field;
    protected Converter converter;

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object2, unitOfWorkImpl, map);
        }
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 != null) {
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWorkImpl, map3);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWorkImpl, map);
        }
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            Object object2 = this.getAttributeAccessor().getAttributeValueFromObject(object);
            if (object2 == null) {
                return null;
            }
            return object2;
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public boolean hasConverter() {
        return this.getConverter() != null;
    }

    public boolean isAbstractCompositeObjectMapping() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.hasConverter()) {
            this.getConverter().initialize(this, abstractSession);
        }
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        try {
            this.attributeAccessor.setAttributeValueInObject(object, object2);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) throws DescriptorException {
        Object object2 = this.getAttributeValueFromObject(object);
        if (this.getConverter() != null) {
            this.getConverter().convertObjectValueToDataValue(object2, abstractSession);
        }
        if (object2 == null) {
            return null;
        }
        return this.getObjectBuilder(object2, abstractSession).extractValueFromObjectForField(object2, databaseField, abstractSession);
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Serializable serializable;
        Object object = abstractRecord.get(this.getField());
        if (object == null || object instanceof String) {
            return null;
        }
        AbstractRecord abstractRecord2 = this.getReferenceDescriptor().buildNestedRowFromFieldValue(object);
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (classDescriptor.hasInheritance()) {
            serializable = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord2, abstractSession);
            classDescriptor = this.getReferenceDescriptor((Class)serializable, abstractSession);
        }
        serializable = classDescriptor.getObjectBuilder();
        Object object2 = this.buildCompositeObject((ObjectBuilder)serializable, abstractRecord2, objectBuildingQuery, joinedAttributeManager);
        if (this.getConverter() != null) {
            object2 = this.getConverter().convertDataValueToObjectValue(object2, abstractSession);
        }
        return this.buildCompositeObject((ObjectBuilder)serializable, abstractRecord2, objectBuildingQuery, joinedAttributeManager);
    }

    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Serializable serializable;
        Object object2 = abstractRecord.get(this.getField());
        if (object2 == null || object2 instanceof String) {
            return;
        }
        AbstractRecord abstractRecord2 = this.getReferenceDescriptor().buildNestedRowFromFieldValue(object2);
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (classDescriptor.hasInheritance()) {
            serializable = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord2, abstractSession);
            classDescriptor = this.getReferenceDescriptor((Class)serializable, abstractSession);
        }
        serializable = classDescriptor.getObjectBuilder();
        Object object3 = ((ObjectBuilder)serializable).buildNewInstance();
        ((ObjectBuilder)serializable).buildAttributesIntoShallowObject(object3, abstractRecord2, objectBuildingQuery);
        this.setAttributeValueInObject(object, object3);
    }

    protected abstract Object buildCompositeObject(ObjectBuilder var1, AbstractRecord var2, ObjectBuildingQuery var3, JoinedAttributeManager var4);

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (this.getConverter() != null) {
            this.getConverter().convertObjectValueToDataValue(object2, abstractSession);
        }
        if (object2 == null) {
            abstractRecord.put(this.getField(), (Object)null);
        } else {
            Object object3 = this.buildCompositeRow(object2, abstractSession, abstractRecord);
            abstractRecord.put(this.getField(), object3);
        }
    }

    protected abstract Object buildCompositeRow(Object var1, AbstractSession var2, AbstractRecord var3);

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) throws DescriptorException {
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, writeObjectQuery.getSession());
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz = null;
        if (this.getReferenceClassName() != null) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), privilegedActionException.getException());
                        }
                    }
                    clazz = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), classNotFoundException);
                }
            }
            this.setReferenceClass(clazz);
        }
    }
}

