/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

public class XMLDescriptor
extends ClassDescriptor {
    private NamespaceResolver namespaceResolver;
    private XMLSchemaReference schemaReference;
    private boolean shouldPreserveDocument = false;
    private XMLField defaultRootElementField;
    private boolean sequencedObject = false;
    private boolean isWrapper = false;

    public XMLDescriptor() {
        this.tables = NonSynchronizedVector.newInstance(3);
        this.mappings = NonSynchronizedVector.newInstance();
        this.primaryKeyFields = new ArrayList(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap(5);
        this.queryKeys = new HashMap(5);
        this.initializationStage = 0;
        this.interfaceInitializationStage = 0;
        this.shouldAlwaysRefreshCache = false;
        this.shouldOnlyRefreshCacheIfNewerVersion = false;
        this.shouldDisableCacheHits = false;
        this.identityMapSize = 100;
        this.remoteIdentityMapSize = -1;
        this.identityMapClass = AbstractIdentityMap.getDefaultIdentityMapClass();
        this.remoteIdentityMapClass = null;
        this.descriptorType = 0;
        this.shouldAlwaysRefreshCacheOnRemote = false;
        this.shouldDisableCacheHitsOnRemote = false;
        this.shouldOrderMappings = true;
        this.shouldBeReadOnly = false;
        this.shouldAlwaysConformResultsInUnitOfWork = false;
        this.shouldAcquireCascadedLocks = false;
        this.hasSimplePrimaryKey = false;
        this.isIsolated = false;
        this.objectBuilder = new TreeObjectBuilder(this);
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
        this.shouldOrderMappings = false;
        this.descriptorIsAggregate();
    }

    public String getDefaultRootElement() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().firstElement().getName();
    }

    public boolean shouldPreserveDocument() {
        return this.shouldPreserveDocument;
    }

    public void setShouldPreserveDocument(boolean bl) {
        this.shouldPreserveDocument = bl;
    }

    public void addRootElement(String string) {
        if (string != null && !this.getTableNames().contains(string)) {
            this.addTableName(string);
        }
    }

    public void setDefaultRootElement(String string) {
        if (string != null) {
            this.setDefaultRootElementField(new XMLField(string));
            int n = this.getTableNames().indexOf(string);
            if (n == 0) {
                return;
            }
            if (n >= 0) {
                this.getTables().remove(n);
                this.getTables().add(0, new DatabaseTable(string));
            } else {
                this.getTables().add(0, new DatabaseTable(string));
            }
        }
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public NamespaceResolver getNonNullNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new QNameInheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public XMLSchemaReference getSchemaReference() {
        return this.schemaReference;
    }

    public void setSchemaReference(XMLSchemaReference xMLSchemaReference) {
        this.schemaReference = xMLSchemaReference;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isXMLMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object object) {
        if (object instanceof XMLRecord) {
            return (XMLRecord)object;
        }
        if (!(object instanceof Vector)) {
            return this.getObjectBuilder().createRecord(null);
        }
        Vector vector = (Vector)object;
        if (vector.isEmpty()) {
            return this.getObjectBuilder().createRecord(null);
        }
        if (!(vector.firstElement() instanceof AbstractRecord)) {
            return this.getObjectBuilder().createRecord(null);
        }
        return (XMLRecord)vector.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object object, AbstractSession abstractSession) {
        if (!(object instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)object;
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(string);
        xMLDirectMapping.setXPath(string2);
        return this.addMapping(xMLDirectMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(string);
        xMLDirectMapping.setSetMethodName(string3);
        xMLDirectMapping.setGetMethodName(string2);
        xMLDirectMapping.setXPath(string4);
        return this.addMapping(xMLDirectMapping);
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        if (!(object instanceof Vector)) {
            Vector<Object> vector = new Vector<Object>(1);
            vector.add(object);
            return vector;
        }
        return (Vector)object;
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        return vector;
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        return vector;
    }

    public DatabaseField buildField(String string) {
        XMLField xMLField = new XMLField(string);
        xMLField.setNamespaceResolver(this.getNamespaceResolver());
        return xMLField;
    }

    public DatabaseField buildField(DatabaseField databaseField) {
        try {
            XMLField xMLField = (XMLField)databaseField;
            xMLField.setNamespaceResolver(this.getNamespaceResolver());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return super.buildField(databaseField);
    }

    public void initializeAggregateInheritancePolicy(AbstractSession abstractSession) {
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        Object descriptorException;
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        for (DatabaseTable object22 : this.getTables()) {
            if (object22.getName().indexOf(32) == -1) continue;
            descriptorException = ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (object22.getName().indexOf((String)descriptorException) != -1) continue;
            object22.setName((String)descriptorException + object22.getName() + (String)descriptorException);
        }
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            try {
                descriptorException = enumeration.nextElement();
                ((DatabaseMapping)descriptorException).preInitialize(abstractSession);
            }
            catch (DescriptorException descriptorException2) {
                abstractSession.getIntegrityChecker().handleError(descriptorException2);
            }
        }
        this.validateBeforeInitialization(abstractSession);
        this.preInitializeInheritancePolicy(abstractSession);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(abstractSession);
        } else {
            this.setInternalDefaultTable();
        }
        this.verifyTableQualifiers(abstractSession.getDatasourcePlatform());
        this.initializeProperties(abstractSession);
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(abstractSession);
        }
    }

    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        int n;
        Cloneable cloneable;
        Enumeration<DatabaseMapping> enumeration;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            enumeration = this.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                ((ClassDescriptor)((Object)enumeration.nextElement())).postInitialize(abstractSession);
            }
        }
        enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            ((DatabaseMapping)cloneable).postInitialize(abstractSession);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(abstractSession);
        }
        for (n = this.getPrimaryKeyFields().size() - 1; n >= 0; --n) {
            cloneable = this.getPrimaryKeyFields().get(n);
            int n2 = this.getFields().indexOf(cloneable);
            if (n2 == -1) continue;
            cloneable = this.getFields().get(n2);
            this.getPrimaryKeyFields().set(n, (DatabaseField)cloneable);
        }
        for (n = 0; n < this.getFields().size(); ++n) {
            DatabaseMapping databaseMapping;
            cloneable = this.getFields().elementAt(n);
            if (((DatabaseField)cloneable).getType() == null && (databaseMapping = this.getObjectBuilder().getMappingForField((DatabaseField)cloneable)) != null) {
                ((DatabaseField)cloneable).setType(databaseMapping.getFieldClassification((DatabaseField)cloneable));
            }
            ((DatabaseField)cloneable).setIndex(n);
        }
        this.validateAfterInitialization(abstractSession);
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        if (this.hasInheritance()) {
            ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.getNamespaceResolver());
        }
        if (this.shouldBeReadOnly() && !abstractSession.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            abstractSession.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(abstractSession);
        }
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            this.validateMappingType(databaseMapping);
            databaseMapping.initialize(abstractSession);
            Helper.addAllUniqueToVector(this.getFields(), databaseMapping.getFields());
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(abstractSession);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(abstractSession);
        if (this.hasInterfacePolicy()) {
            this.interfaceInitialization(abstractSession);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(abstractSession);
        }
        this.getEventManager().initialize(abstractSession);
        this.getCopyPolicy().initialize(abstractSession);
        this.getInstantiationPolicy().initialize(abstractSession);
        if (this.getSchemaReference() != null) {
            this.getSchemaReference().initialize(abstractSession);
        }
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        return new DatabaseTable();
    }

    public Object wrapObjectInXMLRoot(UnmarshalRecord unmarshalRecord, boolean bl) {
        String string = unmarshalRecord.getRootElementName();
        int n = string.indexOf(":");
        String string2 = string;
        String string3 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        String string4 = unmarshalRecord.getRootElementNamespaceUri();
        if (bl || this.shouldWrapObject(unmarshalRecord.getCurrentObject(), string4, string2, string3)) {
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setLocalName(string2);
            xMLRoot.setNamespaceURI(string4);
            xMLRoot.setObject(unmarshalRecord.getCurrentObject());
            xMLRoot.setEncoding(unmarshalRecord.getEncoding());
            xMLRoot.setVersion(unmarshalRecord.getVersion());
            xMLRoot.setSchemaLocation(unmarshalRecord.getSchemaLocation());
            xMLRoot.setNoNamespaceSchemaLocation(unmarshalRecord.getNoNamespaceSchemaLocation());
            return xMLRoot;
        }
        return this.wrapObjectInXMLRoot(unmarshalRecord.getCurrentObject(), string4, string2, string3, bl);
    }

    public Object wrapObjectInXMLRoot(Object object, String string, String string2, String string3, boolean bl) {
        if (bl || this.shouldWrapObject(object, string, string2, string3)) {
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setLocalName(string2);
            xMLRoot.setNamespaceURI(string);
            xMLRoot.setObject(object);
            return xMLRoot;
        }
        return object;
    }

    public Object wrapObjectInXMLRoot(Object object, String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (bl || this.shouldWrapObject(object, string, string2, string3)) {
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setLocalName(string2);
            xMLRoot.setNamespaceURI(string);
            xMLRoot.setObject(object);
            xMLRoot.setEncoding(string4);
            xMLRoot.setVersion(string5);
            return xMLRoot;
        }
        return object;
    }

    public boolean shouldWrapObject(Object object, String string, String string2, String string3) {
        String string4 = this.getDefaultRootElement();
        if (string4 != null) {
            String string5 = null;
            int n = string4.indexOf(":");
            if (n != -1) {
                string5 = this.getNamespaceResolver().resolveNamespacePrefix(string4.substring(0, n));
                string4 = string4.substring(n + 1);
            } else if (this.getNamespaceResolver() != null) {
                string5 = this.getNamespaceResolver().getDefaultNamespaceURI();
            }
            if ((string5 == null && string == null || string5 == null && string.equals("") || string == null && string5.equals("") || string5 != null && string != null && string5.equals(string)) && string4.equals(string2)) {
                return false;
            }
        }
        return true;
    }

    public XMLField getDefaultRootElementField() {
        return this.defaultRootElementField;
    }

    public void setDefaultRootElementField(XMLField xMLField) {
        this.defaultRootElementField = xMLField;
    }

    public QName getDefaultRootElementType() {
        if (this.defaultRootElementField != null) {
            return this.defaultRootElementField.getLeafElementType();
        }
        return null;
    }

    public void setDefaultRootElementType(QName qName) {
        if (this.defaultRootElementField != null) {
            this.defaultRootElementField.setLeafElementType(qName);
        }
    }

    public boolean isSequencedObject() {
        return this.sequencedObject;
    }

    public void setSequencedObject(boolean bl) {
        this.sequencedObject = bl;
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public void setIsWrapper(boolean bl) {
        this.isWrapper = bl;
    }
}

