/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.wls.WebLogicTransactionController;

public class WebLogicPlatform
extends ServerPlatformBase {
    protected Class weblogicConnectionClass;
    protected Method vendorConnectionMethod;
    protected Method clearStatementCacheMethod;

    public WebLogicPlatform(DatabaseSession databaseSession) {
        super(databaseSession);
    }

    public void initializeServerNameAndVersion() {
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName("weblogic.version");
            Method method = PrivilegedAccessHelper.getMethod(clazz, "getBuildVersion", null, false);
            this.serverNameAndVersion = (String)PrivilegedAccessHelper.invokeMethod(method, null, null);
        }
        catch (Exception exception) {
            this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
        }
    }

    public String getApplicationName() {
        return DEFAULT_SERVER_NAME_AND_VERSION;
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = WebLogicTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    protected Class getWebLogicConnectionClass() {
        if (this.weblogicConnectionClass == null) {
            try {
                this.weblogicConnectionClass = (Class)this.getDatabaseSession().getPlatform().convertObject("weblogic.jdbc.extensions.WLConnection", Class.class);
            }
            catch (Throwable throwable) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, throwable);
                this.weblogicConnectionClass = Void.TYPE;
            }
        }
        return this.weblogicConnectionClass;
    }

    protected Method getVendorConnectionMethod() {
        if (this.vendorConnectionMethod == null && !this.getWebLogicConnectionClass().equals(Void.TYPE)) {
            try {
                this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebLogicConnectionClass(), "getVendorConnection", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, noSuchMethodException);
            }
        }
        return this.vendorConnectionMethod;
    }

    public Connection unwrapConnection(Connection connection) {
        if (this.getWebLogicConnectionClass().isInstance(connection) && this.getVendorConnectionMethod() != null) {
            try {
                return (Connection)PrivilegedAccessHelper.invokeMethod(this.getVendorConnectionMethod(), connection);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, invocationTargetException);
            }
        }
        return super.unwrapConnection(connection);
    }

    protected Method getClearStatementCacheMethod() {
        if (this.clearStatementCacheMethod == null && !this.getWebLogicConnectionClass().equals(Void.TYPE)) {
            try {
                this.clearStatementCacheMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebLogicConnectionClass(), "clearStatementCache", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, noSuchMethodException);
            }
        }
        return this.clearStatementCacheMethod;
    }

    public void clearStatementCache(Connection connection) {
        if (this.getWebLogicConnectionClass().isInstance(connection) && this.getClearStatementCacheMethod() != null) {
            try {
                PrivilegedAccessHelper.invokeMethod(this.getClearStatementCacheMethod(), connection);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, invocationTargetException);
            }
        }
    }
}

