/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class ConstructorReportItem
extends ReportItem {
    protected Class[] constructorArgTypes;
    protected List constructorMappings;
    protected List reportItems;
    protected Constructor constructor;

    public ConstructorReportItem() {
    }

    public ConstructorReportItem(String string) {
        super(string, null);
    }

    public void addAttribute(Expression expression) {
        ReportItem reportItem = new ReportItem(this.getName() + this.getReportItems().size(), expression);
        this.getReportItems().add(reportItem);
    }

    public void addAttribute(String string, Expression expression, List list) {
        ReportItem reportItem = new ReportItem(string, expression);
        reportItem.getJoinedAttributeManager().setJoinedAttributeExpressions_(list);
        this.getReportItems().add(reportItem);
    }

    public void addItem(ReportItem reportItem) {
        this.getReportItems().add(reportItem);
    }

    public Class[] getConstructorArgTypes() {
        return this.constructorArgTypes;
    }

    public List getConstructorMappings() {
        return this.constructorMappings;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public List getReportItems() {
        if (this.reportItems == null) {
            this.reportItems = new ArrayList();
        }
        return this.reportItems;
    }

    public void initialize(ReportQuery reportQuery) throws QueryException {
        Class[] classArray;
        int n;
        int n2 = this.getReportItems().size();
        ArrayList<DatabaseMapping> arrayList = new ArrayList<DatabaseMapping>();
        for (n = 0; n < n2; ++n) {
            classArray = (Class[])this.reportItems.get(n);
            classArray.initialize(reportQuery);
            arrayList.add(classArray.getMapping());
        }
        this.setConstructorMappings(arrayList);
        n = this.getReportItems().size();
        if (this.getConstructorArgTypes() == null) {
            this.setConstructorArgTypes(new Class[n]);
        }
        classArray = this.getConstructorArgTypes();
        for (int i = 0; i < n; ++i) {
            if (classArray[i] != null) continue;
            ReportItem reportItem = (ReportItem)this.getReportItems().get(i);
            classArray[i] = arrayList.get(i) != null ? ((DatabaseMapping)this.constructorMappings.get(i)).getAttributeClassification() : (reportItem.getResultType() != null ? reportItem.getResultType() : (reportItem.getDescriptor() != null ? reportItem.getDescriptor().getJavaClass() : ClassConstants.OBJECT));
        }
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getResultType(), classArray, true));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(privilegedActionException.getException(), reportQuery);
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getResultType(), classArray, true);
            }
            this.setConstructor(constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw QueryException.exceptionWhileUsingConstructorExpression(noSuchMethodException, reportQuery);
        }
    }

    public boolean isConstructorItem() {
        return true;
    }

    public void setConstructorArgTypes(Class[] classArray) {
        this.constructorArgTypes = classArray;
    }

    public void setConstructorMappings(List list) {
        this.constructorMappings = list;
    }

    public void setReportItems(List list) {
        this.reportItems = list;
    }

    public String toString() {
        String string = "ConstructorReportItem(" + this.getName() + " -> [";
        if (this.reportItems != null) {
            int n = this.reportItems.size();
            for (int i = 0; i < n; ++i) {
                string = string + this.reportItems.get(i).toString();
            }
        }
        return string + "])";
    }
}

