/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public class DoesExistQuery
extends DatabaseQuery {
    public static final int AssumeNonExistence = 1;
    public static final int AssumeExistence = 2;
    public static final int CheckCache = 3;
    public static final int CheckDatabase = 4;
    protected Vector primaryKey;
    protected Object object;
    protected int existencePolicy = 3;
    protected boolean checkDatabaseIfInvalid = true;
    public boolean checkCacheFirst = true;

    public DoesExistQuery() {
    }

    public DoesExistQuery(Object object) {
        this();
        this.object = object;
    }

    public DoesExistQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void assumeExistenceForDoesExist() {
        this.setExistencePolicy(2);
    }

    public void assumeNonExistenceForDoesExist() {
        this.setExistencePolicy(1);
    }

    public void checkCacheForDoesExist() {
        this.setExistencePolicy(3);
    }

    public void checkDatabaseForDoesExist() {
        this.setExistencePolicy(4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object checkEarlyReturn(Object object, Vector vector, AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.buildSelectionCriteria(abstractSession);
        if (object == null) {
            return Boolean.FALSE;
        }
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(object.getClass());
        if (vector == null && (vector = this.getPrimaryKey()) == null) {
            vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession, true);
        }
        if (vector == null || vector.contains(null)) {
            return Boolean.FALSE;
        }
        if ((this.shouldCheckCacheForDoesExist() || this.checkCacheFirst) && !classDescriptor.isDescriptorForInterface()) {
            CacheKey cacheKey;
            if (this.checkDatabaseIfInvalid && abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).shouldReadFromDB()) {
                return null;
            }
            Class<?> clazz = object.getClass();
            AbstractSession abstractSession2 = abstractSession;
            while (abstractSession2.isUnitOfWork()) {
                cacheKey = abstractSession2.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(vector, clazz, classDescriptor);
                if (cacheKey != null) {
                    return Boolean.TRUE;
                }
                abstractSession2 = ((UnitOfWorkImpl)abstractSession2).getParent();
            }
            cacheKey = abstractSession2.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, clazz, classDescriptor);
            if (cacheKey != null) {
                if (this.checkDatabaseIfInvalid) {
                    this.checkDescriptor(object, abstractSession);
                    if (this.getDescriptor().getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis())) {
                        return null;
                    }
                }
                Object object2 = cacheKey.getObject();
                if (!abstractSession.isUnitOfWork() || !((UnitOfWorkImpl)abstractSession).wasDeleted(object2)) return Boolean.TRUE;
                if (this.shouldCheckCacheForDoesExist()) {
                    return Boolean.FALSE;
                }
            } else if (this.shouldCheckCacheForDoesExist()) {
                return Boolean.FALSE;
            }
        }
        if (this.shouldAssumeNonExistenceForDoesExist()) {
            return Boolean.FALSE;
        }
        if (!this.shouldAssumeExistenceForDoesExist()) return null;
        return Boolean.TRUE;
    }

    public Object checkEarlyReturn(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        return this.checkEarlyReturn(this.getObject(), this.getPrimaryKey(), abstractSession, abstractRecord);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        DatabaseField databaseField = this.getDoesExistField();
        AbstractRecord abstractRecord = this.getQueryMechanism().selectRowForDoesExist(databaseField);
        return new Boolean(abstractRecord != null);
    }

    protected DatabaseField getDoesExistField() {
        return this.getDescriptor().getPrimaryKeyFields().get(0);
    }

    public int getExistencePolicy() {
        return this.existencePolicy;
    }

    public Object getObject() {
        return this.object;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected void prepare() throws QueryException {
        if (this.getObject() != null) {
            this.checkDescriptor(this.getObject(), this.getSession());
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        super.prepare();
        this.getQueryMechanism().prepareDoesExist(this.getDoesExistField());
    }

    public void checkDescriptor(Object object, AbstractSession abstractSession) throws QueryException {
        if (this.getDescriptor() == null) {
            if (object == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(object);
            if (classDescriptor == null) {
                throw QueryException.descriptorIsMissing(object.getClass(), this);
            }
            this.setDescriptor(classDescriptor);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.getDescriptor() == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject().getClass()));
        }
        if (this.getPrimaryKey() == null) {
            this.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getObject(), this.getSession()));
        }
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }

    public void setExistencePolicy(int n) {
        this.existencePolicy = n;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setPrimaryKey(Vector vector) {
        this.primaryKey = vector;
    }

    public boolean shouldAssumeExistenceForDoesExist() {
        return this.existencePolicy == 2;
    }

    public boolean shouldAssumeNonExistenceForDoesExist() {
        return this.existencePolicy == 1;
    }

    public boolean shouldCheckCacheForDoesExist() {
        return this.existencePolicy == 3;
    }

    public boolean shouldCheckDatabaseForDoesExist() {
        return this.existencePolicy == 4;
    }

    public void setCheckCacheFirst(boolean bl) {
        this.checkCacheFirst = bl;
    }

    public boolean getCheckCacheFirst() {
        return this.checkCacheFirst;
    }

    public void setCheckDatabaseIfInvalid(boolean bl) {
        this.checkCacheFirst = bl;
    }

    public boolean getCheckDatabaseIfInvalid() {
        return this.checkCacheFirst;
    }
}

