/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.corba;

import java.io.IOException;
import java.net.InetAddress;
import javax.naming.Context;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.SerializationHelper;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.corba.CORBAConnection;
import org.eclipse.persistence.internal.sessions.coordination.corba.CORBARemoteCommandConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.omg.CORBA.Object;

public abstract class CORBATransportManager
extends TransportManager {
    protected RemoteCommandManager rcm;

    public CORBATransportManager(RemoteCommandManager remoteCommandManager) {
        this.rcm = remoteCommandManager;
        this.initialize();
    }

    public void initialize() {
        super.initialize();
        if (this.rcm.getServiceId().getURL() == null) {
            this.rcm.getServiceId().setURL(this.getDefaultLocalUrl());
        }
        this.namingServiceType = 0;
        this.setInitialContextFactoryName(this.getDefaultInitialContextFactoryName());
    }

    public String getDefaultLocalUrl() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            return "iiop://" + string + ":" + "23791";
        }
        catch (IOException iOException) {
            throw RemoteCommandManagerException.errorGettingHostName(iOException);
        }
    }

    public void removeLocalConnection() {
        String string = null;
        try {
            if (this.namingServiceType != 0) {
                return;
            }
            string = this.rcm.getServiceId().getId();
            this.getContext(this.getLocalContextProperties()).unbind(string);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorUnbindingLocalConnection(string, exception));
        }
        this.localConnection = null;
    }

    public int getNamingServiceType() {
        return 0;
    }

    public abstract String getDefaultInitialContextFactoryName();

    public abstract CORBAConnection narrow(Object var1);

    public abstract CORBAConnection buildCORBAConnection();

    public RemoteConnection createConnection(ServiceId serviceId) {
        CORBARemoteCommandConnection cORBARemoteCommandConnection = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{serviceId.getId(), serviceId.getURL()};
        this.rcm.logDebug("looking_up_remote_conn_in_jndi", objectArray);
        try {
            Context context = this.getRemoteHostContext(serviceId.getURL());
            CORBAConnection cORBAConnection = this.narrow((Object)context.lookup(serviceId.getId()));
            cORBARemoteCommandConnection = new CORBARemoteCommandConnection(cORBAConnection);
            cORBARemoteCommandConnection.setServiceId(serviceId);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(serviceId.getId(), serviceId.getURL(), exception));
        }
        return cORBARemoteCommandConnection;
    }

    public static byte[] processCommand(byte[] byArray, RemoteCommandManager remoteCommandManager) {
        try {
            Command command = (Command)SerializationHelper.deserialize(byArray);
            remoteCommandManager.processCommandFromRemoteConnection(command);
        }
        catch (Exception exception) {
            java.lang.Object[] objectArray = new java.lang.Object[]{Helper.getShortClassName(byArray), Helper.printStackTraceToString(exception)};
            remoteCommandManager.logWarning("error_executing_remote_command", objectArray);
            return exception.toString().getBytes();
        }
        return null;
    }

    public void createLocalConnection() {
        CORBAConnection cORBAConnection = this.buildCORBAConnection();
        java.lang.Object[] objectArray = new java.lang.Object[]{this.rcm.getServiceId().getId()};
        this.rcm.logDebug("register_local_connection_in_jndi", objectArray);
        try {
            this.getRemoteHostContext(this.rcm.getUrl()).rebind(this.rcm.getServiceId().getId(), (java.lang.Object)cORBAConnection);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorBindingConnection(this.rcm.getServiceId().toString(), exception));
            return;
        }
        this.localConnection = new CORBARemoteCommandConnection(cORBAConnection);
        this.localConnection.setServiceId(this.rcm.getServiceId());
    }
}

