/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class SessionManager {
    protected static boolean shouldUseSchemaValidation = true;
    protected static SessionManager manager = SessionManager.initializeManager();
    protected AbstractSession defaultSession;
    protected Map sessions = new Hashtable(5);
    protected static boolean shouldPerformDTDValidation;

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean bl) {
        shouldUseSchemaValidation = bl;
    }

    public void addSession(Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String string, Session session) {
        session.setName(string);
        this.getSessions().put(string, session);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroySession(String string) {
        DatabaseSession databaseSession = (DatabaseSession)this.getSessions().get(string);
        if (databaseSession != null) {
            this.destroy(databaseSession);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(string));
        }
    }

    private void destroy(DatabaseSession databaseSession) {
        if (databaseSession.isConnected()) {
            databaseSession.logout();
        }
        this.sessions.remove(databaseSession.getName());
        databaseSession = null;
    }

    public void destroyAllSessions() {
        Iterator iterator = new ArrayList(this.getSessions().values()).iterator();
        while (iterator.hasNext()) {
            this.destroy((DatabaseSession)iterator.next());
        }
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String string, ClassLoader classLoader) {
        return this.getInternalMWConfigObjects(string, classLoader, true);
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String string, ClassLoader classLoader, boolean bl) {
        return new XMLSessionConfigLoader(string).loadConfigsForMappingWorkbench(classLoader, bl);
    }

    public static SessionManager getManager() {
        if (manager == null) {
            SessionManager.initializeManager();
        }
        return manager;
    }

    protected static SessionManager initializeManager() {
        return new SessionManager();
    }

    public AbstractSession getSession(String string) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, boolean bl) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setShouldLogin(bl);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, boolean bl, boolean bl2) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setShouldLogin(bl);
        xMLSessionConfigLoader.setShouldRefresh(bl2);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, Object object) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(object.getClass()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(object.getClass());
        }
        xMLSessionConfigLoader.setClassLoader(classLoader);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, String string2) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setResourceName(string2);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, String string2, ClassLoader classLoader) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setResourceName(string2);
        xMLSessionConfigLoader.setClassLoader(classLoader);
        xMLSessionConfigLoader.setShouldCheckClassLoader(true);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(String string, ClassLoader classLoader) {
        XMLSessionConfigLoader xMLSessionConfigLoader = new XMLSessionConfigLoader();
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setClassLoader(classLoader);
        xMLSessionConfigLoader.setShouldCheckClassLoader(true);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader) {
        if (xMLSessionConfigLoader == null) {
            xMLSessionConfigLoader = new XMLSessionConfigLoader();
        }
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setClassLoader(classLoader);
        xMLSessionConfigLoader.setShouldCheckClassLoader(true);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        if (xMLSessionConfigLoader == null) {
            xMLSessionConfigLoader = new XMLSessionConfigLoader();
        }
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setClassLoader(classLoader);
        xMLSessionConfigLoader.setShouldLogin(bl);
        xMLSessionConfigLoader.setShouldRefresh(bl2);
        return this.getSession(xMLSessionConfigLoader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        if (xMLSessionConfigLoader == null) {
            xMLSessionConfigLoader = new XMLSessionConfigLoader();
        }
        xMLSessionConfigLoader.setSessionName(string);
        xMLSessionConfigLoader.setClassLoader(classLoader);
        xMLSessionConfigLoader.setShouldLogin(bl);
        xMLSessionConfigLoader.setShouldRefresh(bl2);
        xMLSessionConfigLoader.setShouldCheckClassLoader(bl3);
        return this.getSession(xMLSessionConfigLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession getSession(XMLSessionConfigLoader xMLSessionConfigLoader) {
        SessionManager sessionManager;
        AbstractSession abstractSession = (AbstractSession)this.getSessions().get(xMLSessionConfigLoader.getSessionName());
        boolean bl = xMLSessionConfigLoader.shouldRefresh();
        if (xMLSessionConfigLoader.shouldCheckClassLoader() && abstractSession != null && !abstractSession.getDatasourcePlatform().getConversionManager().getLoader().equals(xMLSessionConfigLoader.getClassLoader())) {
            bl = true;
        }
        if (abstractSession == null || bl) {
            sessionManager = this;
            synchronized (sessionManager) {
                abstractSession = (AbstractSession)this.getSessions().get(xMLSessionConfigLoader.getSessionName());
                if (xMLSessionConfigLoader.shouldCheckClassLoader() && abstractSession != null && !abstractSession.getDatasourcePlatform().getConversionManager().getLoader().equals(xMLSessionConfigLoader.getClassLoader())) {
                    bl = true;
                }
                if (abstractSession == null || bl) {
                    if (abstractSession != null) {
                        if (abstractSession.isDatabaseSession() && abstractSession.isConnected()) {
                            try {
                                ((DatabaseSession)((Object)abstractSession)).logout();
                            }
                            catch (Throwable throwable) {
                                AbstractSessionLog.getLog().logThrowable(6, throwable);
                            }
                        }
                        this.getSessions().remove(xMLSessionConfigLoader.getSessionName());
                    }
                    if (xMLSessionConfigLoader.load(this, xMLSessionConfigLoader.getClassLoader())) {
                        abstractSession = (AbstractSession)this.getSessions().get(xMLSessionConfigLoader.getSessionName());
                    }
                }
            }
        }
        if (abstractSession == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(xMLSessionConfigLoader.getSessionName(), xMLSessionConfigLoader.getResourcePath()));
        } else if (xMLSessionConfigLoader.shouldLogin() && !abstractSession.isConnected()) {
            sessionManager = this;
            synchronized (sessionManager) {
                if (xMLSessionConfigLoader.shouldLogin() && !abstractSession.isConnected()) {
                    ((DatabaseSession)((Object)abstractSession)).login();
                }
            }
        }
        return abstractSession;
    }

    private void logAndThrowException(int n, RuntimeException runtimeException) throws RuntimeException {
        AbstractSessionLog.getLog().logThrowable(n, runtimeException);
        throw runtimeException;
    }

    public void setSessions(Hashtable hashtable) {
        this.sessions = hashtable;
    }

    public Map getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(Session session) {
        this.defaultSession = (AbstractSession)session;
        this.addSession("default", session);
    }

    public static void setManager(SessionManager sessionManager) {
        manager = sessionManager;
    }
}

