/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.factories.PersistenceEntityResolver;
import org.eclipse.persistence.internal.sessions.factories.SessionsFactory;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigToplinkProject;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSessionConfigLoader {
    protected String resourceName;
    protected String resourcePath = "sessions.xml";
    protected String sessionName = "default";
    protected boolean shouldLogin = true;
    protected boolean shouldRefresh = false;
    protected ClassLoader classLoader;
    protected boolean shouldCheckClassLoader = false;
    protected Vector exceptionStore;
    protected PersistenceEntityResolver entityResolver;
    public static final String ECLIPSELINK_SESSIONS_SCHEMA = "xsd/eclipselink_sessions_1.1.xsd";
    protected static final String DEFAULT_RESOURCE_NAME = "sessions.xml";
    protected static final String DEFAULT_RESOURCE_NAME_IN_META_INF = "META-INF/sessions.xml";
    protected static Project project = new XMLSessionConfigProject_11_1_1();

    protected static Project getProject() {
        return project;
    }

    public XMLSessionConfigLoader() {
        this(DEFAULT_RESOURCE_NAME);
    }

    public XMLSessionConfigLoader(String string) {
        this.resourceName = string;
        this.exceptionStore = new Vector();
        this.entityResolver = new PersistenceEntityResolver();
        this.classLoader = ConversionManager.getDefaultManager().getLoader();
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Vector getExceptionStore() {
        return this.exceptionStore;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public boolean shouldLogin() {
        return this.shouldLogin;
    }

    public void setShouldLogin(boolean bl) {
        this.shouldLogin = bl;
    }

    public boolean shouldRefresh() {
        return this.shouldRefresh;
    }

    public void setShouldRefresh(boolean bl) {
        this.shouldRefresh = bl;
    }

    public boolean shouldCheckClassLoader() {
        return this.shouldCheckClassLoader;
    }

    public void setShouldCheckClassLoader(boolean bl) {
        this.shouldCheckClassLoader = bl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean load(SessionManager sessionManager, ClassLoader classLoader) {
        Document document = this.loadDocument(classLoader);
        if (this.getExceptionStore().isEmpty()) {
            if (document.getDocumentElement().getTagName().equals("sessions")) {
                return this.buildSessionConfigs(sessionManager, classLoader, document, XMLSessionConfigLoader.getProject());
            }
        } else {
            if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
                return this.buildSessionConfigs(sessionManager, classLoader, document, new XMLSessionConfigToplinkProject());
            }
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
        return false;
    }

    private boolean buildSessionConfigs(SessionManager sessionManager, ClassLoader classLoader, Document document, Project project) {
        XMLContext xMLContext = new XMLContext(project);
        XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
        SessionConfigs sessionConfigs = (SessionConfigs)xMLUnmarshaller.unmarshal(document);
        SessionsFactory sessionsFactory = new SessionsFactory();
        Map map = sessionsFactory.buildSessionConfigs(sessionConfigs, classLoader);
        for (Map.Entry entry : map.entrySet()) {
            if (sessionManager.getSessions().containsKey(entry.getKey())) continue;
            sessionManager.addSession((String)entry.getKey(), (Session)entry.getValue());
        }
        return true;
    }

    public SessionConfigs loadConfigsForMappingWorkbench(ClassLoader classLoader) {
        return this.loadConfigsForMappingWorkbench(classLoader, true);
    }

    public SessionConfigs loadConfigsForMappingWorkbench(ClassLoader classLoader, boolean bl) {
        Document document = this.loadDocument(classLoader, bl);
        if (this.getExceptionStore().isEmpty()) {
            if (document.getDocumentElement().getTagName().equals("sessions")) {
                XMLContext xMLContext = new XMLContext(XMLSessionConfigLoader.getProject());
                XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
                return (SessionConfigs)xMLUnmarshaller.unmarshal(document);
            }
            throw SessionLoaderException.InvalidSessionXML();
        }
        if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
            XMLContext xMLContext = new XMLContext(new XMLSessionConfigToplinkProject());
            XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
            return (SessionConfigs)xMLUnmarshaller.unmarshal(document);
        }
        throw SessionLoaderException.finalException(this.getExceptionStore());
    }

    protected Document loadDocument(ClassLoader classLoader) {
        return this.loadDocument(classLoader, SessionManager.shouldUseSchemaValidation());
    }

    protected Document loadDocument(ClassLoader classLoader, boolean bl) {
        URL uRL = classLoader.getResource(this.resourceName);
        File file = new File(this.resourceName);
        if (uRL == null) {
            if (this.resourceName.equals(DEFAULT_RESOURCE_NAME)) {
                uRL = classLoader.getResource(DEFAULT_RESOURCE_NAME_IN_META_INF);
            }
            if (uRL == null && !file.exists()) {
                throw ValidationException.noSessionsXMLFound(this.resourceName);
            }
        }
        this.resourcePath = uRL == null ? file.getAbsolutePath() : uRL.getPath();
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLParser xMLParser = xMLPlatform.newXMLParser();
        if (bl) {
            xMLParser.setValidationMode(3);
        } else {
            xMLParser.setValidationMode(0);
        }
        xMLParser.setWhitespacePreserving(false);
        xMLParser.setXMLSchema(classLoader.getResource(ECLIPSELINK_SESSIONS_SCHEMA));
        xMLParser.setEntityResolver(this.entityResolver);
        xMLParser.setErrorHandler(new XMLSessionConfigLoaderErrorHandler());
        if (uRL == null) {
            return xMLParser.parse(file);
        }
        return xMLParser.parse(uRL);
    }

    public class XMLSessionConfigLoaderErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(SessionLoaderException.failedToParseXML(ExceptionLocalization.buildMessage("parsing_warning"), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(sAXParseException);
        }
    }
}

