/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();
    protected HashMap<String, ForeignKeyConstraint> foreignKeyMap = new HashMap();
    protected Vector<UniqueKeyConstraint> uniqueKeys = new Vector();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;

    public void addField(String string, Class clazz) {
        this.addField(new FieldDefinition(string, clazz));
    }

    public void addField(String string, Class clazz, int n) {
        this.addField(new FieldDefinition(string, clazz, n));
    }

    public void addField(String string, Class clazz, int n, int n2) {
        this.addField(new FieldDefinition(string, clazz, n, n2));
    }

    public void addField(String string, String string2) {
        this.addField(new FieldDefinition(string, string2));
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.getFields().addElement(fieldDefinition);
    }

    public void addForeignKeyConstraint(String string, String string2, String string3, String string4) {
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint(string, string2, string3, string4);
        this.addForeignKeyConstraint(foreignKeyConstraint);
    }

    public void addUniqueKeyConstraint(String string, String string2) {
        UniqueKeyConstraint uniqueKeyConstraint = new UniqueKeyConstraint(string, string2);
        this.addUniqueKeyConstraint(uniqueKeyConstraint);
    }

    public void addUniqueKeyConstraint(String string, String[] stringArray) {
        UniqueKeyConstraint uniqueKeyConstraint = new UniqueKeyConstraint(string, stringArray);
        this.addUniqueKeyConstraint(uniqueKeyConstraint);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKeyConstraint) {
        if (!this.foreignKeyMap.containsKey(foreignKeyConstraint.getName())) {
            this.foreignKeyMap.put(foreignKeyConstraint.getName(), foreignKeyConstraint);
        }
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKeyConstraint) {
        this.getUniqueKeys().addElement(uniqueKeyConstraint);
    }

    public void addIdentityField(String string, Class clazz) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz);
        fieldDefinition.setIsIdentity(true);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addIdentityField(String string, Class clazz, int n) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz, n);
        fieldDefinition.setIsIdentity(true);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addPrimaryKeyField(String string, Class clazz) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addPrimaryKeyField(String string, Class clazz, int n) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz, n);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public Writer buildConstraintCreationWriter(AbstractSession abstractSession, ForeignKeyConstraint foreignKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!abstractSession.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKeyConstraint.getName() + " ");
            }
            foreignKeyConstraint.appendDBString(writer, abstractSession);
            if (abstractSession.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKeyConstraint.getName());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession abstractSession, ForeignKeyConstraint foreignKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(abstractSession.getPlatform().getConstraintDeletionString() + foreignKeyConstraint.getName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession abstractSession, UniqueKeyConstraint uniqueKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!abstractSession.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKeyConstraint.getName() + " ");
            }
            uniqueKeyConstraint.appendDBString(writer, abstractSession);
            if (abstractSession.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKeyConstraint.getName());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession abstractSession, UniqueKeyConstraint uniqueKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(abstractSession.getPlatform().getConstraintDeletionString() + uniqueKeyConstraint.getName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String string) {
        this.creationPrefix = string;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String string) {
        this.creationSuffix = string;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            Object object;
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Object object2 = this.getFields().elements();
            while (object2.hasMoreElements()) {
                object = (FieldDefinition)object2.nextElement();
                ((FieldDefinition)object).appendDBString(writer, abstractSession, this);
                if (!object2.hasMoreElements()) continue;
                writer.write(", ");
            }
            object2 = this.getPrimaryKeyFieldNames();
            if (!((Vector)object2).isEmpty() && abstractSession.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (abstractSession.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    writer.write((String)object.nextElement());
                    if (!object.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            if (this.getCreationSuffix().length() > 0) {
                writer.write(this.getCreationSuffix());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession abstractSession) {
        FieldDefinition fieldDefinition = null;
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            fieldDefinition = (FieldDefinition)enumeration.nextElement();
            if (fieldDefinition.getForeignKeyFieldName() == null) continue;
            this.addForeignKeyConstraint(this.buildForeignKeyConstraint(fieldDefinition, abstractSession.getPlatform()));
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition fieldDefinition, DatabasePlatform databasePlatform) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        DatabaseField databaseField = new DatabaseField(fieldDefinition.getForeignKeyFieldName());
        DatabaseField databaseField2 = new DatabaseField(fieldDefinition.getName());
        vector.addElement(databaseField2.getName());
        vector2.addElement(databaseField.getName());
        foreignKeyConstraint.setSourceFields(vector);
        foreignKeyConstraint.setTargetFields(vector2);
        foreignKeyConstraint.setTargetTable(databaseField.getTable().getQualifiedName());
        String string = this.buildForeignKeyConstraintName(this.getName(), databaseField2.getName(), databasePlatform.getMaxForeignKeyNameSize());
        foreignKeyConstraint.setName(string);
        return foreignKeyConstraint;
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(Vector vector, Vector vector2, TableDefinition tableDefinition, DatabasePlatform databasePlatform) {
        assert (vector.size() > 0 && vector.size() == vector2.size());
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        for (int i = 0; i < vector.size(); ++i) {
            foreignKeyConstraint.getSourceFields().add(vector.get(i));
            foreignKeyConstraint.getTargetFields().add(vector2.get(i));
        }
        foreignKeyConstraint.setTargetTable(tableDefinition.getFullName());
        String string = (String)vector.get(0);
        String string2 = this.buildForeignKeyConstraintName(this.getName(), string, databasePlatform.getMaxForeignKeyNameSize());
        foreignKeyConstraint.setName(string2);
        return foreignKeyConstraint;
    }

    protected String buildForeignKeyConstraintName(String string, String string2, int n) {
        String string3;
        String string4;
        CharSequence charSequence;
        String string5 = string;
        if (string5.indexOf(32) != -1 || string5.indexOf(34) != -1 || string5.indexOf(96) != -1) {
            charSequence = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                ((StringBuffer)charSequence).append(c);
            }
            string5 = ((StringBuffer)charSequence).toString();
        }
        if (((String)(charSequence = "FK_" + string5 + "_" + string2)).length() > n && ((String)(charSequence = string5 + "_" + string2)).length() > n && ((String)(charSequence = Helper.removeAllButAlphaNumericToFit(string5 + string2, n))).length() > n && ((String)(charSequence = Helper.shortenStringsByRemovingVowelsToFit(string4 = Helper.removeAllButAlphaNumericToFit(string5, 0), string3 = Helper.removeAllButAlphaNumericToFit(string2, 0), n))).length() > n) {
            String string6 = Helper.removeVowels(string3);
            String string7 = Helper.removeVowels(string4);
            charSequence = Helper.truncate(string7, n - string6.length()) + string6;
        }
        return charSequence;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(List<String> list, int n, DatabasePlatform databasePlatform) {
        assert (list.size() > 0);
        UniqueKeyConstraint uniqueKeyConstraint = new UniqueKeyConstraint();
        for (String string : list) {
            uniqueKeyConstraint.addSourceField(string);
        }
        String string = this.buildUniqueKeyConstraintName(this.getName(), n, databasePlatform.getMaxUniqueKeyNameSize());
        uniqueKeyConstraint.setName(string);
        return uniqueKeyConstraint;
    }

    protected String buildUniqueKeyConstraintName(String string, int n, int n2) {
        String string2;
        String string3;
        String string4 = "UNQ_" + string + "_" + n;
        if (string4.length() > n2 && (string4 = string + n).length() > n2 && (string4 = Helper.removeAllButAlphaNumericToFit(string + n, n2)).length() > n2 && (string4 = Helper.shortenStringsByRemovingVowelsToFit(string3 = Helper.removeAllButAlphaNumericToFit(string, 0), string2 = String.valueOf(n), n2)).length() > n2) {
            String string5 = Helper.removeVowels(string3);
            string4 = Helper.truncate(string5, n2 - string2.length()) + string2;
        }
        return string4;
    }

    @Override
    public Object clone() {
        TableDefinition tableDefinition = (TableDefinition)super.clone();
        if (this.fields != null) {
            tableDefinition.setFields(new Vector(this.fields.size()));
            Enumeration enumeration = this.getFields().elements();
            while (enumeration.hasMoreElements()) {
                FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
                tableDefinition.addField((FieldDefinition)fieldDefinition.clone());
            }
        }
        if (this.foreignKeyMap != null) {
            tableDefinition.setForeignKeyMap((HashMap)this.foreignKeyMap.clone());
        }
        if (this.uniqueKeys != null) {
            tableDefinition.setUniqueKeys((Vector)this.uniqueKeys.clone());
        }
        return tableDefinition;
    }

    public void createConstraints(AbstractSession abstractSession, Writer writer) throws EclipseLinkException {
        this.createUniqueConstraints(abstractSession, writer);
        this.createForeignConstraints(abstractSession, writer);
    }

    void createUniqueConstraints(AbstractSession abstractSession, Writer writer) throws ValidationException {
        if (writer == null) {
            this.createUniqueConstraintsOnDatabase(abstractSession);
            return;
        }
        Enumeration<UniqueKeyConstraint> enumeration = this.getUniqueKeys().elements();
        while (enumeration.hasMoreElements()) {
            UniqueKeyConstraint uniqueKeyConstraint = enumeration.nextElement();
            this.buildUniqueConstraintCreationWriter(abstractSession, uniqueKeyConstraint, writer).toString();
            try {
                if (this.createSQLFiles) {
                    writer.write(abstractSession.getPlatform().getStoredProcedureTerminationToken());
                }
                writer.write("\n");
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        }
    }

    void createForeignConstraints(AbstractSession abstractSession, Writer writer) throws ValidationException {
        if (writer == null) {
            this.createForeignConstraintsOnDatabase(abstractSession);
            return;
        }
        for (ForeignKeyConstraint foreignKeyConstraint : this.getForeignKeyMap().values()) {
            this.buildConstraintCreationWriter(abstractSession, foreignKeyConstraint, writer).toString();
            try {
                if (this.createSQLFiles) {
                    writer.write(abstractSession.getPlatform().getStoredProcedureTerminationToken());
                }
                writer.write("\n");
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession abstractSession) throws EclipseLinkException {
        this.createUniqueConstraintsOnDatabase(abstractSession);
        this.createForeignConstraintsOnDatabase(abstractSession);
    }

    void createUniqueConstraintsOnDatabase(AbstractSession abstractSession) throws ValidationException, DatabaseException {
        if (!abstractSession.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> enumeration = this.getUniqueKeys().elements();
        while (enumeration.hasMoreElements()) {
            UniqueKeyConstraint uniqueKeyConstraint = enumeration.nextElement();
            abstractSession.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(abstractSession, uniqueKeyConstraint, new StringWriter()).toString()));
        }
    }

    void createForeignConstraintsOnDatabase(AbstractSession abstractSession) throws ValidationException, DatabaseException {
        if (!abstractSession.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKeyConstraint : this.getForeignKeyMap().values()) {
            abstractSession.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(abstractSession, foreignKeyConstraint, new StringWriter()).toString()));
        }
    }

    public String deletionStringFor(DatabaseAccessor databaseAccessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession abstractSession, Writer writer) throws EclipseLinkException {
        if (writer == null) {
            this.dropConstraintsOnDatabase(abstractSession);
        } else {
            for (Serializable serializable : this.getForeignKeyMap().values()) {
                this.buildConstraintDeletionWriter(abstractSession, (ForeignKeyConstraint)serializable, writer).toString();
                try {
                    if (this.createSQLFiles) {
                        writer.write(abstractSession.getPlatform().getStoredProcedureTerminationToken());
                    }
                    writer.write("\n");
                }
                catch (IOException iOException) {
                    throw ValidationException.fileError(iOException);
                }
            }
            Enumeration<UniqueKeyConstraint> enumeration = this.getUniqueKeys().elements();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                serializable = (UniqueKeyConstraint)enumeration.nextElement();
                this.buildUniqueConstraintDeletionWriter(abstractSession, (UniqueKeyConstraint)serializable, writer).toString();
                try {
                    if (this.createSQLFiles) {
                        writer.write(abstractSession.getPlatform().getStoredProcedureTerminationToken());
                    }
                    writer.write("\n");
                }
                catch (IOException iOException) {
                    throw ValidationException.fileError(iOException);
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession abstractSession) throws EclipseLinkException {
        this.dropForeignConstraintsOnDatabase(abstractSession);
        this.dropUniqueConstraintsOnDatabase(abstractSession);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession abstractSession) throws ValidationException {
        if (!abstractSession.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> enumeration = this.getUniqueKeys().elements();
        while (enumeration.hasMoreElements()) {
            UniqueKeyConstraint uniqueKeyConstraint = enumeration.nextElement();
            try {
                abstractSession.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(abstractSession, uniqueKeyConstraint, new StringWriter()).toString()));
            }
            catch (DatabaseException databaseException) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession abstractSession) throws ValidationException {
        if (!abstractSession.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKeyConstraint : this.getForeignKeyMap().values()) {
            try {
                abstractSession.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(abstractSession, foreignKeyConstraint, new StringWriter()).toString()));
            }
            catch (DatabaseException databaseException) {}
        }
    }

    HashMap<String, ForeignKeyConstraint> getForeignKeyMap() {
        return this.foreignKeyMap;
    }

    void setForeignKeyMap(HashMap<String, ForeignKeyConstraint> hashMap) {
        this.foreignKeyMap = hashMap;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector<ForeignKeyConstraint> getForeignKeys() {
        return new Vector<ForeignKeyConstraint>(this.foreignKeyMap.values());
    }

    public Vector<UniqueKeyConstraint> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
            if (!fieldDefinition.isPrimaryKey()) continue;
            vector.addElement(fieldDefinition.getName());
        }
        return vector;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setForeignKeys(Vector<ForeignKeyConstraint> vector) {
        this.foreignKeyMap.clear();
        if (vector != null) {
            for (ForeignKeyConstraint foreignKeyConstraint : vector) {
                this.foreignKeyMap.put(foreignKeyConstraint.getName(), foreignKeyConstraint);
            }
        }
    }

    public void setUniqueKeys(Vector<UniqueKeyConstraint> vector) {
        this.uniqueKeys = vector;
    }

    public void setCreateSQLFiles(boolean bl) {
        this.createSQLFiles = bl;
    }
}

