/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.ConnectorClassLoaderServiceImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AppLibClassLoaderServiceImpl {
    @Inject
    ConnectorClassLoaderServiceImpl connectorCLS;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    Map<URI, DelegatingClassLoader.ClassFinder> classFinderRegistry = new HashMap<URI, DelegatingClassLoader.ClassFinder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        DelegatingClassLoader connectorCL = this.connectorCLS.getConnectorClassLoader(application);
        if (libURIs == null || libURIs.isEmpty()) {
            return connectorCL;
        }
        DelegatingClassLoader applibCL = new DelegatingClassLoader(this.commonCLS.getCommonClassLoader(), connectorCL.getDelegates());
        for (URI libURI : libURIs) {
            AppLibClassLoaderServiceImpl appLibClassLoaderServiceImpl = this;
            synchronized (appLibClassLoaderServiceImpl) {
                DelegatingClassLoader.ClassFinder libCF = this.classFinderRegistry.get(libURI);
                if (libCF == null) {
                    libCF = new URLClassFinder(new URL[]{libURI.toURL()}, applibCL.getParent());
                    this.classFinderRegistry.put(libURI, libCF);
                }
                applibCL.addDelegate(libCF);
            }
        }
        return applibCL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLClassFinder
    extends URLClassLoader
    implements DelegatingClassLoader.ClassFinder {
        public URLClassFinder(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return super.findClass(name);
        }

        public Class<?> findExistingClass(String name) {
            return super.findLoadedClass(name);
        }
    }
}

