/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderListener;
import org.glassfish.web.admin.monitor.telemetry.HttpServiceRequestTelemetry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="http-service")
@Scoped(value=Singleton.class)
public class HttpServiceTelemetryBootstrap
implements ProbeProviderListener,
TelemetryProvider,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    private ProbeClientMediator pcm;
    private boolean httpServiceMonitoringEnabled = false;
    private TreeNode serverNode = null;
    private boolean requestProviderRegistered = false;
    private boolean isRequestTreeBuilt = false;
    private boolean probeProviderListenerRegistered = false;
    private TreeNode httpServiceNode = null;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;
    private List<HttpServiceRequestTelemetry> vsRequestTMs = null;

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the HttpServiceRequestTelemetry bootstrap ************");
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
    }

    public void onLevelChange(String newLevel) {
        boolean newLevelEnabledValue = this.getEnabledValue(newLevel);
        this.logger.finest("[Monitor]In the Http Service Level Change = " + newLevel + "  ************");
        if (this.httpServiceMonitoringEnabled == newLevelEnabledValue) {
            return;
        }
        this.httpServiceMonitoringEnabled = newLevelEnabledValue;
        if (this.httpServiceMonitoringEnabled) {
            if (!this.probeProviderListenerRegistered) {
                this.registerProbeProviderListener();
            } else {
                this.enableHttpServiceMonitoring(true);
            }
        } else {
            this.enableHttpServiceMonitoring(false);
        }
    }

    public void providerRegistered(String moduleName, String providerName, String appName) {
        try {
            this.logger.finest("[Monitor]Provider registered event received - providerName = " + providerName + " : module name = " + moduleName + " : appName = " + appName);
            if (providerName.equals("request")) {
                this.logger.finest("[Monitor]and it is Http Request");
                this.requestProviderRegistered = true;
                if (this.isRequestTreeBuilt || !this.httpServiceMonitoringEnabled) {
                    return;
                }
                this.buildRequestMonitoringTree();
            }
        }
        catch (Exception e) {
            this.logger.finest("[Monitor]WARNING: Exception in HttpService Monitor Startup : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void providerUnregistered(String moduleName, String providerName, String appName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void registerProbeProviderListener() {
        this.ppem.registerProbeProviderListener((ProbeProviderListener)this);
        this.probeProviderListenerRegistered = true;
    }

    private void buildTopLevelMonitoringTree() {
        if (this.serverNode != null) {
            return;
        }
        if (this.mrdr.get("server") != null) {
            this.serverNode = this.mrdr.get("server");
            this.httpServiceNode = this.serverNode.getNode("http-service");
            if (this.httpServiceNode == null) {
                this.httpServiceNode = TreeNodeFactory.createTreeNode((String)"http-service", null, (String)"http-service");
                this.serverNode.addChild(this.httpServiceNode);
            }
            return;
        }
        this.serverNode = TreeNodeFactory.createTreeNode((String)"server", null, (String)"server");
        this.mrdr.add("server", this.serverNode);
        this.httpServiceNode = TreeNodeFactory.createTreeNode((String)"http-service", null, (String)"http-service");
        this.serverNode.addChild(this.httpServiceNode);
    }

    private void buildRequestMonitoringTree() {
        if (this.isRequestTreeBuilt || !this.httpServiceMonitoringEnabled) {
            return;
        }
        this.buildTopLevelMonitoringTree();
        this.logger.finest("[Monitor]Http Service Monitoring tree is being built");
        this.vsRequestTMs = new ArrayList<HttpServiceRequestTelemetry>();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            TreeNode vsNode = TreeNodeFactory.createTreeNode((String)vs.getId(), null, (String)"virtual-server");
            this.httpServiceNode.addChild(vsNode);
            TreeNode requestNode = TreeNodeFactory.createTreeNode((String)"request", null, (String)"http-service");
            vsNode.addChild(requestNode);
            HttpServiceRequestTelemetry vsRequestTM = new HttpServiceRequestTelemetry(requestNode, vs.getId(), this.logger);
            Collection handles = this.pcm.registerListener((Object)vsRequestTM);
            vsRequestTM.setProbeListenerHandles(handles);
            this.vsRequestTMs.add(vsRequestTM);
        }
        this.isRequestTreeBuilt = true;
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }

    private void enableHttpServiceMonitoring(boolean isEnabled) {
        this.httpServiceNode.setEnabled(isEnabled);
        if (this.requestProviderRegistered && this.vsRequestTMs != null) {
            for (HttpServiceRequestTelemetry requestTM : this.vsRequestTMs) {
                requestTM.enableMonitoring(isEnabled);
            }
        }
    }

    public static String getVirtualServer(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            NetworkListener listener = null;
            for (NetworkListener hl : networkConfig.getNetworkListeners().getNetworkListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                listener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getNetworkListeners().contains(listener.getName())) continue;
                virtualServer = vs;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(HttpServiceTelemetryBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

